/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.docusafe.business.impl;

import org.adorsys.cryptoutils.exceptions.BaseException;
import org.adorsys.docusafe.business.impl.CacheType;
import org.adorsys.docusafe.business.impl.DocusafeCacheWrapper;
import org.adorsys.docusafe.business.impl.caches.DocumentGuardCache;
import org.adorsys.docusafe.business.impl.caches.DocumentKeyIDCache;
import org.adorsys.docusafe.business.impl.caches.UserAuthCache;
import org.adorsys.docusafe.business.impl.caches.guava.DocumentGuardCacheGuavaImpl;
import org.adorsys.docusafe.business.impl.caches.guava.DocumentKeyIDCacheGuavaImpl;
import org.adorsys.docusafe.business.impl.caches.guava.UserAuthCacheGuavaImpl;
import org.adorsys.docusafe.business.impl.caches.hashmap.DocumentGuardCacheHashMapImpl;
import org.adorsys.docusafe.business.impl.caches.hashmap.DocumentKeyIDCacheHashMapImpl;
import org.adorsys.docusafe.business.impl.caches.hashmap.UserAuthCacheHashMapImpl;

public class DocusafeCacheWrapperImpl
implements DocusafeCacheWrapper {
    private UserAuthCache userAuthCache;
    private DocumentGuardCache guardCache;
    private DocumentKeyIDCache documentKeyIDCache;

    public DocusafeCacheWrapperImpl(CacheType cacheType) {
        switch (cacheType) {
            case GUAVA: {
                this.userAuthCache = new UserAuthCacheGuavaImpl();
                this.guardCache = new DocumentGuardCacheGuavaImpl();
                this.documentKeyIDCache = new DocumentKeyIDCacheGuavaImpl();
                break;
            }
            case HASH_MAP: {
                this.userAuthCache = new UserAuthCacheHashMapImpl();
                this.guardCache = new DocumentGuardCacheHashMapImpl();
                this.documentKeyIDCache = new DocumentKeyIDCacheHashMapImpl();
                break;
            }
            default: {
                throw new BaseException("Programming Error missing switch for " + (Object)((Object)cacheType));
            }
        }
    }

    @Override
    public UserAuthCache getUserAuthCache() {
        return this.userAuthCache;
    }

    @Override
    public DocumentGuardCache getDocumentGuardCache() {
        return this.guardCache;
    }

    @Override
    public DocumentKeyIDCache getDocumentKeyIDCache() {
        return this.documentKeyIDCache;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DOCUSAFE_CACHE WRAPPER");
        sb.append(" ");
        sb.append("number of users: " + this.getUserAuthCache().size());
        sb.append(" ");
        sb.append("number of guards: " + this.getDocumentGuardCache().size());
        sb.append(" ");
        sb.append("number of doc keys: " + this.getDocumentKeyIDCache().size());
        return sb.toString();
    }
}

