/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.docusafe.business.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import org.adorsys.docusafe.business.types.UserID;
import org.adorsys.docusafe.business.types.complex.GrantAccessList;
import org.adorsys.docusafe.business.utils.UserIDUtil;
import org.adorsys.docusafe.service.BucketService;
import org.adorsys.docusafe.service.types.AccessType;
import org.adorsys.docusafe.service.types.PlainFileContent;
import org.adorsys.encobject.complextypes.BucketDirectory;
import org.adorsys.encobject.complextypes.BucketPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrantUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(GrantUtil.class);
    public static final String GRANT_EXT = ".grants";

    public static void saveBucketGrantFile(BucketService bucketService, BucketDirectory documentDirectory, UserID owner, UserID receiver, AccessType accessType) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        BucketPath grantFile = UserIDUtil.getGrantBucketDirectory(owner).append(documentDirectory.addSuffix(GRANT_EXT));
        GrantAccessList grantAccessList = new GrantAccessList();
        if (bucketService.fileExists(grantFile)) {
            PlainFileContent plainFileContent = bucketService.readPlainFile(grantFile);
            String gsonString = new String(plainFileContent.getValue());
            grantAccessList = (GrantAccessList)gson.fromJson(gsonString, GrantAccessList.class);
        }
        grantAccessList.addOrReplace(receiver, accessType);
        if (grantAccessList.isEmpty()) {
            bucketService.deletePlainFile(grantFile);
            return;
        }
        String gsonString = gson.toJson((Object)grantAccessList);
        LOGGER.debug("write grant file contains " + gsonString);
        PlainFileContent plainFileContent = new PlainFileContent(gsonString.getBytes());
        bucketService.createPlainFile(grantFile, plainFileContent);
    }

    public static AccessType getAccessTypeOfBucketGrantFile(BucketService bucketService, BucketDirectory documentDirectory, UserID owner, UserID receiver) {
        BucketPath grantFile = UserIDUtil.getGrantBucketDirectory(owner).append(documentDirectory.addSuffix(GRANT_EXT));
        if (!bucketService.fileExists(grantFile)) {
            return AccessType.NONE;
        }
        PlainFileContent plainFileContent = bucketService.readPlainFile(grantFile);
        String gsonString = new String(plainFileContent.getValue());
        LOGGER.debug("read grant file contains " + gsonString);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        GrantAccessList grantAccessList = (GrantAccessList)gson.fromJson(gsonString, GrantAccessList.class);
        if (grantAccessList.find(receiver) != null) {
            return grantAccessList.find(receiver);
        }
        return AccessType.NONE;
    }
}

