/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.docusafe.business.utils;

import org.adorsys.docusafe.business.types.complex.DocumentDirectoryFQN;
import org.adorsys.docusafe.business.types.complex.DocumentFQN;
import org.adorsys.encobject.complextypes.BucketDirectory;
import org.adorsys.encobject.complextypes.BucketPath;

public class BucketPath2FQNHelper {
    public static DocumentFQN path2FQN(BucketDirectory bucketDirectory, BucketPath bucketPath) {
        String bucketDirectoryString = BucketPath2FQNHelper.bucketDirectory2String(bucketDirectory);
        String bucketPathString = BucketPath2FQNHelper.bucketPath2String(bucketPath);
        if (bucketPathString.startsWith(bucketDirectoryString)) {
            return new DocumentFQN(bucketPathString.substring(bucketDirectoryString.length()));
        }
        throw new RuntimeException("Programming error. Expected " + bucketPathString + " to start with " + bucketDirectoryString);
    }

    public static DocumentDirectoryFQN directory2FQN(BucketDirectory bucketDirectory, BucketDirectory subdirectory) {
        String bucketDirectoryString = BucketPath2FQNHelper.bucketDirectory2String(bucketDirectory);
        String subdirString = BucketPath2FQNHelper.bucketDirectory2String(subdirectory);
        if (subdirString.startsWith(bucketDirectoryString)) {
            return new DocumentDirectoryFQN(subdirString.substring(bucketDirectoryString.length()));
        }
        throw new RuntimeException("Programming error. Expected " + subdirString + " to start with " + bucketDirectoryString);
    }

    private static String bucketPath2String(BucketPath bucketPath) {
        return bucketPath.getObjectHandle().getContainer() + "/" + bucketPath.getObjectHandle().getName();
    }

    private static String bucketDirectory2String(BucketDirectory bucketDirectory) {
        return bucketDirectory.getObjectHandle().getContainer() + "/" + bucketDirectory.getObjectHandle().getName();
    }
}

