/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.docusafe.business.impl;

import de.adorsys.common.exceptions.BaseException;
import de.adorsys.common.exceptions.BaseExceptionHandler;
import de.adorsys.dfs.connection.api.complextypes.BucketDirectory;
import de.adorsys.dfs.connection.api.complextypes.BucketPath;
import de.adorsys.dfs.connection.api.domain.Payload;
import de.adorsys.dfs.connection.api.domain.PayloadStream;
import de.adorsys.dfs.connection.api.service.api.DFSConnection;
import de.adorsys.dfs.connection.api.service.impl.SimplePayloadImpl;
import de.adorsys.dfs.connection.api.service.impl.SimplePayloadStreamImpl;
import de.adorsys.dfs.connection.api.types.ListRecursiveFlag;
import de.adorsys.dfs.connection.api.types.properties.ConnectionProperties;
import de.adorsys.dfs.connection.impl.factory.DFSConnectionFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.crypto.SecretKey;
import org.adorsys.docusafe.business.DocumentSafeService;
import org.adorsys.docusafe.business.exceptions.UserExistsException;
import org.adorsys.docusafe.business.impl.FolderHelper;
import org.adorsys.docusafe.business.impl.jsonserialisation.Class2JsonHelper;
import org.adorsys.docusafe.business.types.DFSCredentials;
import org.adorsys.docusafe.business.types.DSDocument;
import org.adorsys.docusafe.business.types.DSDocumentStream;
import org.adorsys.docusafe.business.types.DocumentDirectoryFQN;
import org.adorsys.docusafe.business.types.DocumentFQN;
import org.adorsys.docusafe.business.types.EncryptionInputStreamWrapper;
import org.adorsys.docusafe.business.types.MoveType;
import org.adorsys.docusafe.service.api.bucketpathencryption.BucketPathEncryptionService;
import org.adorsys.docusafe.service.api.cmsencryption.CMSEncryptionService;
import org.adorsys.docusafe.service.api.keystore.KeyStoreService;
import org.adorsys.docusafe.service.api.keystore.types.KeyStoreAccess;
import org.adorsys.docusafe.service.api.keystore.types.KeyStoreAuth;
import org.adorsys.docusafe.service.api.keystore.types.KeyStoreCreationConfig;
import org.adorsys.docusafe.service.api.keystore.types.KeyStoreType;
import org.adorsys.docusafe.service.api.keystore.types.PublicKeyIDWithPublicKey;
import org.adorsys.docusafe.service.api.keystore.types.PublicKeyList;
import org.adorsys.docusafe.service.api.keystore.types.ReadStorePassword;
import org.adorsys.docusafe.service.api.types.DocumentContent;
import org.adorsys.docusafe.service.api.types.UserID;
import org.adorsys.docusafe.service.api.types.UserIDAuth;
import org.adorsys.docusafe.service.impl.bucketpathencryption.BucketPathEncryptionServiceImpl;
import org.adorsys.docusafe.service.impl.cmsencryption.services.CMSEncryptionServiceImpl;
import org.adorsys.docusafe.service.impl.keystore.service.KeyStoreServiceImpl;
import org.bouncycastle.cms.CMSEnvelopedData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentSafeServiceImpl
implements DocumentSafeService {
    private static final Logger log = LoggerFactory.getLogger(DocumentSafeServiceImpl.class);
    private final DFSConnection systemDFS;
    private final Class2JsonHelper class2JsonHelper = new Class2JsonHelper();
    private final BucketPathEncryptionService bucketPathEncryptionService = new BucketPathEncryptionServiceImpl();
    private final CMSEncryptionService cmsEncryptionService = new CMSEncryptionServiceImpl();
    private final DFSCredentials defaultUserDFSCredentials;
    private final KeyStoreService keyStoreService = new KeyStoreServiceImpl();

    private DFSCredentials getDefaultDFSCredentials(ConnectionProperties props) {
        DFSCredentials dfsCredentials = new DFSCredentials(props);
        return dfsCredentials;
    }

    public DocumentSafeServiceImpl(DFSConnection dfsConnection) {
        DFSCredentials dfsCredentials = new DFSCredentials(dfsConnection.getConnectionProperties());
        dfsCredentials.addRootBucket(DFSCredentials.TYPE.SYSTEM_DFS);
        this.systemDFS = DFSConnectionFactory.get((ConnectionProperties)dfsCredentials.getProperties());
        dfsCredentials = new DFSCredentials(dfsConnection.getConnectionProperties());
        dfsCredentials.addRootBucket(DFSCredentials.TYPE.USERS_DFS);
        this.defaultUserDFSCredentials = new DFSCredentials(dfsCredentials.getProperties());
    }

    @Override
    public void createUser(UserIDAuth userIDAuth) {
        try {
            if (this.userExists(userIDAuth.getUserID())) {
                throw new UserExistsException(userIDAuth.getUserID());
            }
            KeyStoreAccess publicKeyStoreAccess = null;
            KeyStoreAuth keyStoreAuth = new KeyStoreAuth(new ReadStorePassword(userIDAuth.getReadKeyPassword().getValue()), userIDAuth.getReadKeyPassword());
            KeyStore usersSystemKeyStore = this.keyStoreService.createKeyStore(keyStoreAuth, KeyStoreType.DEFAULT, new KeyStoreCreationConfig(Integer.valueOf(1), Integer.valueOf(0), Integer.valueOf(0)));
            this.persistKeystore(userIDAuth, usersSystemKeyStore, this.systemDFS);
            publicKeyStoreAccess = new KeyStoreAccess(usersSystemKeyStore, keyStoreAuth);
            DFSCredentials userDFSCredentials = null;
            userDFSCredentials = new DFSCredentials(this.defaultUserDFSCredentials);
            this.storeUserDFSCredentials(userIDAuth, publicKeyStoreAccess, userDFSCredentials);
            DFSConnection usersDFSConnection = null;
            usersDFSConnection = DFSConnectionFactory.get((ConnectionProperties)userDFSCredentials.getProperties());
            KeyStoreAccess privateKeyStoreAccess = null;
            KeyStoreAuth keyStoreAuth2 = new KeyStoreAuth(new ReadStorePassword(userIDAuth.getReadKeyPassword().getValue()), userIDAuth.getReadKeyPassword());
            KeyStore usersSystemKeyStore2 = this.keyStoreService.createKeyStore(keyStoreAuth2, KeyStoreType.DEFAULT, new KeyStoreCreationConfig(Integer.valueOf(5), Integer.valueOf(0), Integer.valueOf(1)));
            this.persistKeystore(userIDAuth, usersSystemKeyStore2, usersDFSConnection);
            privateKeyStoreAccess = new KeyStoreAccess(usersSystemKeyStore2, keyStoreAuth2);
            PublicKeyList publicKeys = this.keyStoreService.getPublicKeys(privateKeyStoreAccess);
            Payload payload = this.class2JsonHelper.keyListToContent((List<PublicKeyIDWithPublicKey>)publicKeys);
            this.systemDFS.putBlob(FolderHelper.getPublicKeyListPath(userIDAuth.getUserID()), payload);
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    @Override
    public void destroyUser(UserIDAuth userIDAuth) {
        DFSConnection usersDFSConnection = this.getUsersDFS(userIDAuth);
        usersDFSConnection.removeBlobFolder(FolderHelper.getRootDirectory(userIDAuth.getUserID()));
        this.systemDFS.removeBlobFolder(FolderHelper.getRootDirectory(userIDAuth.getUserID()));
    }

    @Override
    public boolean userExists(UserID userID) {
        return this.systemDFS.blobExists(FolderHelper.getKeyStorePath(userID));
    }

    @Override
    public void registerDFSCredentials(UserIDAuth userIDAuth, DFSCredentials dfsCredentials) {
        try {
            DFSAndKeystoreAndPath dfsAndKeystoreAndPath = this.getUsersAccess(userIDAuth);
            DFSConnection oldUsersDFSConnection = dfsAndKeystoreAndPath.usersDFS;
            DFSConnection newUsersDFSConnection = DFSConnectionFactory.get((ConnectionProperties)dfsCredentials.getProperties());
            int numberOfFilesCopied = 0;
            for (BucketPath bucketPath : oldUsersDFSConnection.list(new BucketDirectory("/"), ListRecursiveFlag.TRUE)) {
                Payload blob = oldUsersDFSConnection.getBlob(bucketPath);
                newUsersDFSConnection.putBlob(bucketPath, blob);
                ++numberOfFilesCopied;
            }
            log.debug("copied " + numberOfFilesCopied + " from old dfs to new dfs");
            KeyStoreAccess publicKeyStoreAccess = this.getKeyStoreAccess(this.systemDFS, userIDAuth);
            this.storeUserDFSCredentials(userIDAuth, publicKeyStoreAccess, dfsCredentials);
            oldUsersDFSConnection.removeBlobFolder(new BucketDirectory("/"));
            log.debug("deleted user from old dfs");
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    @Override
    public void storeDocument(UserIDAuth userIDAuth, DSDocument dsDocument) {
        DFSAndKeystoreAndPath dfsAndKeystoreAndPath = this.getUsersAccess(userIDAuth, dsDocument.getDocumentFQN());
        Payload payload = this.encryptDataForUserWithRandomKey(userIDAuth.getUserID(), (Payload)new SimplePayloadImpl(dsDocument.getDocumentContent().getValue()));
        dfsAndKeystoreAndPath.usersDFS.putBlob(dfsAndKeystoreAndPath.encryptedBucketPath, payload);
    }

    @Override
    public DSDocument readDocument(UserIDAuth userIDAuth, DocumentFQN documentFQN) {
        try {
            DFSAndKeystoreAndPath dfsAndKeystoreAndPath = this.getUsersAccess(userIDAuth, documentFQN);
            Payload payload = dfsAndKeystoreAndPath.usersDFS.getBlob(dfsAndKeystoreAndPath.encryptedBucketPath);
            CMSEnvelopedData cmsEnvelopedData = new CMSEnvelopedData(payload.getData());
            Payload decrypt = this.cmsEncryptionService.decrypt(cmsEnvelopedData, dfsAndKeystoreAndPath.privateKeystoreAccess);
            return new DSDocument(documentFQN, new DocumentContent(decrypt.getData()));
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    @Override
    public void storeDocumentStream(UserIDAuth userIDAuth, DSDocumentStream dsDocumentStream) {
        try {
            DFSAndKeystoreAndPath dfsAndKeystoreAndPath = this.getUsersAccess(userIDAuth, dsDocumentStream.getDocumentFQN());
            PublicKeyIDWithPublicKey publicKeyIDWithPublicKey = this.getPublicKeyIDWithPublicKey(userIDAuth.getUserID());
            InputStream encryptedStream = this.cmsEncryptionService.buildEncryptionInputStream(dsDocumentStream.getDocumentStream(), publicKeyIDWithPublicKey.getPublicKey(), publicKeyIDWithPublicKey.getKeyID());
            dfsAndKeystoreAndPath.usersDFS.putBlobStream(dfsAndKeystoreAndPath.encryptedBucketPath, (PayloadStream)new SimplePayloadStreamImpl(encryptedStream));
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    @Override
    public DSDocumentStream readDocumentStream(UserIDAuth userIDAuth, DocumentFQN documentFQN) {
        try {
            DFSAndKeystoreAndPath dfsAndKeystoreAndPath = this.getUsersAccess(userIDAuth, documentFQN);
            PayloadStream payloadStream = null;
            payloadStream = dfsAndKeystoreAndPath.usersDFS.getBlobStream(dfsAndKeystoreAndPath.encryptedBucketPath);
            InputStream decryptedStream = this.cmsEncryptionService.buildDecryptionInputStream(payloadStream.openStream(), dfsAndKeystoreAndPath.privateKeystoreAccess);
            EncryptionInputStreamWrapper encryptionInputStreamWrapper = new EncryptionInputStreamWrapper(decryptedStream, payloadStream.openStream());
            return new DSDocumentStream(documentFQN, encryptionInputStreamWrapper);
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    @Override
    public void deleteDocument(UserIDAuth userIDAuth, DocumentFQN documentFQN) {
        DFSAndKeystoreAndPath dfsAndKeystoreAndPath = this.getUsersAccess(userIDAuth, documentFQN);
        dfsAndKeystoreAndPath.usersDFS.removeBlob(dfsAndKeystoreAndPath.encryptedBucketPath);
    }

    @Override
    public boolean documentExists(UserIDAuth userIDAuth, DocumentFQN documentFQN) {
        DFSAndKeystoreAndPath dfsAndKeystoreAndPath = this.getUsersAccess(userIDAuth, documentFQN);
        return dfsAndKeystoreAndPath.usersDFS.blobExists(dfsAndKeystoreAndPath.encryptedBucketPath);
    }

    @Override
    public void deleteFolder(UserIDAuth userIDAuth, DocumentDirectoryFQN documentDirectoryFQN) {
        DFSAndKeystoreAndPath dfsAndKeystoreAndPath = this.getUsersAccess(userIDAuth, documentDirectoryFQN);
        dfsAndKeystoreAndPath.usersDFS.removeBlobFolder(dfsAndKeystoreAndPath.encryptedBucketDirectory);
    }

    @Override
    public List<DocumentFQN> list(UserIDAuth userIDAuth, DocumentDirectoryFQN documentDirectoryFQN, ListRecursiveFlag recursiveFlag) {
        ArrayList<DocumentFQN> retList = new ArrayList<DocumentFQN>();
        DFSAndKeystoreAndPath dfsAndKeystoreAndPath = this.getUsersAccess(userIDAuth, documentDirectoryFQN);
        List list = dfsAndKeystoreAndPath.usersDFS.list(dfsAndKeystoreAndPath.encryptedBucketDirectory, recursiveFlag);
        String homeDirectoryAsString = FolderHelper.getHomeDirectory(userIDAuth.getUserID()).getValue();
        for (BucketPath encryptedBucketPath : list) {
            BucketPath unecryptedBucketPath = this.bucketPathEncryptionService.decrypt(dfsAndKeystoreAndPath.pathEncryptionKey, encryptedBucketPath);
            String unecryptedBucketPathAsString = unecryptedBucketPath.getValue();
            if (!unecryptedBucketPathAsString.startsWith(homeDirectoryAsString)) {
                throw new BaseException("ProgrammingError:" + unecryptedBucketPathAsString + " does not start with " + homeDirectoryAsString);
            }
            String documentFQN = unecryptedBucketPathAsString.substring(homeDirectoryAsString.length());
            retList.add(new DocumentFQN(documentFQN));
        }
        return retList;
    }

    @Override
    public List<DocumentFQN> listInbox(UserIDAuth userIDAuth) {
        ArrayList<DocumentFQN> retList = new ArrayList<DocumentFQN>();
        BucketDirectory inboxDirectory = FolderHelper.getInboxDirectory(userIDAuth.getUserID());
        String inboxDirectoryAsString = inboxDirectory.getValue();
        List list = this.systemDFS.list(inboxDirectory, ListRecursiveFlag.TRUE);
        for (BucketPath bucketPath : list) {
            String bucketPathAsString = bucketPath.getValue();
            if (!bucketPathAsString.startsWith(inboxDirectoryAsString)) {
                throw new BaseException("ProgrammingError:" + bucketPathAsString + " does not start with " + inboxDirectoryAsString);
            }
            String documentFQN = bucketPathAsString.substring(inboxDirectoryAsString.length());
            retList.add(new DocumentFQN(documentFQN));
        }
        return retList;
    }

    @Override
    public void writeDocumentToInboxOfUser(UserID receiverUserID, DSDocument document, DocumentFQN destDocumentFQN) {
        Payload payload = this.encryptDataForUserWithRandomKey(receiverUserID, (Payload)new SimplePayloadImpl(document.getDocumentContent().getValue()));
        BucketDirectory inboxDirectory = FolderHelper.getInboxDirectory(receiverUserID);
        BucketPath destination = inboxDirectory.appendName(destDocumentFQN.getValue());
        this.systemDFS.putBlob(destination, payload);
    }

    @Override
    public DSDocument readDocumentFromInbox(UserIDAuth userIDAuth, DocumentFQN source) {
        try {
            BucketDirectory inboxDirectory = FolderHelper.getInboxDirectory(userIDAuth.getUserID());
            BucketPath bucketPath = inboxDirectory.appendName(source.getValue());
            Payload blob = this.systemDFS.getBlob(bucketPath);
            DFSAndKeystoreAndPath dfsAndKeystoreAndPath = this.getUsersAccess(userIDAuth, source);
            CMSEnvelopedData cmsEnvelopedData = new CMSEnvelopedData(blob.getData());
            Payload decrypt = this.cmsEncryptionService.decrypt(cmsEnvelopedData, dfsAndKeystoreAndPath.privateKeystoreAccess);
            return new DSDocument(source, new DocumentContent(decrypt.getData()));
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    @Override
    public void deleteDocumentFromInbox(UserIDAuth userIDAuth, DocumentFQN documentFQN) {
        BucketDirectory inboxDirectory = FolderHelper.getInboxDirectory(userIDAuth.getUserID());
        BucketPath bucketPath = inboxDirectory.appendName(documentFQN.getValue());
        this.systemDFS.removeBlob(bucketPath);
    }

    @Override
    public void moveDocumnetToInboxOfUser(UserIDAuth userIDAuth, UserID receiverUserID, DocumentFQN sourceDocumentFQN, DocumentFQN destDocumentFQN, MoveType moveType) {
        DSDocument dsDocument = this.readDocument(userIDAuth, sourceDocumentFQN);
        this.writeDocumentToInboxOfUser(receiverUserID, dsDocument, destDocumentFQN);
        if (moveType.equals((Object)MoveType.MOVE)) {
            this.deleteDocument(userIDAuth, sourceDocumentFQN);
        }
    }

    @Override
    public DSDocument moveDocumentFromInbox(UserIDAuth userIDAuth, DocumentFQN source, DocumentFQN destination) {
        DSDocument dsDocument = this.readDocumentFromInbox(userIDAuth, source);
        DSDocument destDocument = new DSDocument(destination, dsDocument.getDocumentContent());
        this.storeDocument(userIDAuth, destDocument);
        this.deleteDocumentFromInbox(userIDAuth, source);
        return destDocument;
    }

    private void persistKeystore(UserIDAuth userIDAuth, KeyStore usersSystemKeyStore, DFSConnection systemDFS) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        usersSystemKeyStore.store(stream, userIDAuth.getReadKeyPassword().getValue().toCharArray());
        SimplePayloadImpl payload = new SimplePayloadImpl(stream.toByteArray());
        systemDFS.putBlob(FolderHelper.getKeyStorePath(userIDAuth.getUserID()), (Payload)payload);
    }

    private DFSConnection getUsersDFS(UserIDAuth userIDAuth) {
        try {
            KeyStoreAccess publicKeyStoreAccess = this.getKeyStoreAccess(this.systemDFS, userIDAuth);
            DFSCredentials userDFSCredentials = null;
            Payload encryptedPayload = this.systemDFS.getBlob(FolderHelper.getDFSCredentialsPath(userIDAuth.getUserID()));
            CMSEnvelopedData cmsEnvelopedData = new CMSEnvelopedData(encryptedPayload.getData());
            Payload decrypt = this.cmsEncryptionService.decrypt(cmsEnvelopedData, publicKeyStoreAccess);
            userDFSCredentials = this.class2JsonHelper.contentToDFSConnection(decrypt);
            return DFSConnectionFactory.get((ConnectionProperties)userDFSCredentials.getProperties());
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    private KeyStoreAccess getKeyStoreAccess(DFSConnection dfs, UserIDAuth userIDAuth) {
        try {
            KeyStoreAccess keyStoreAccess = null;
            KeyStoreAuth keyStoreAuth = new KeyStoreAuth(new ReadStorePassword(userIDAuth.getReadKeyPassword().getValue()), userIDAuth.getReadKeyPassword());
            Payload payload = dfs.getBlob(FolderHelper.getKeyStorePath(userIDAuth.getUserID()));
            ByteArrayInputStream in = new ByteArrayInputStream(payload.getData());
            KeyStore keystore = KeyStore.getInstance(KeyStoreType.DEFAULT.getValue());
            keystore.load(in, userIDAuth.getReadKeyPassword().getValue().toCharArray());
            keyStoreAccess = new KeyStoreAccess(keystore, keyStoreAuth);
            return keyStoreAccess;
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    private DFSAndKeystoreAndPath getUsersAccess(UserIDAuth userIDAuth) {
        return this.getUsersAccess(userIDAuth, null, null);
    }

    private DFSAndKeystoreAndPath getUsersAccess(UserIDAuth userIDAuth, DocumentFQN documentFQN) {
        return this.getUsersAccess(userIDAuth, null, documentFQN);
    }

    private DFSAndKeystoreAndPath getUsersAccess(UserIDAuth userIDAuth, DocumentDirectoryFQN documentDirectoryFQN) {
        return this.getUsersAccess(userIDAuth, documentDirectoryFQN, null);
    }

    private DFSAndKeystoreAndPath getUsersAccess(UserIDAuth userIDAuth, DocumentDirectoryFQN documentDirectoryFQN, DocumentFQN documentFQN) {
        DFSAndKeystoreAndPath dfsAndKeystoreAndPath = new DFSAndKeystoreAndPath();
        dfsAndKeystoreAndPath.usersDFS = this.getUsersDFS(userIDAuth);
        KeyStoreAccess privateKeyStoreAccess = this.getKeyStoreAccess(dfsAndKeystoreAndPath.usersDFS, userIDAuth);
        dfsAndKeystoreAndPath.pathEncryptionKey = this.keyStoreService.getRandomSecretKeyID(privateKeyStoreAccess).getSecretKey();
        dfsAndKeystoreAndPath.privateKeystoreAccess = this.getKeyStoreAccess(dfsAndKeystoreAndPath.usersDFS, userIDAuth);
        if (documentFQN != null) {
            BucketPath unencryptedPath = FolderHelper.getHomeDirectory(userIDAuth.getUserID()).appendName(documentFQN.getValue());
            dfsAndKeystoreAndPath.encryptedBucketPath = this.bucketPathEncryptionService.encrypt(dfsAndKeystoreAndPath.pathEncryptionKey, unencryptedPath);
        }
        if (documentDirectoryFQN != null) {
            BucketDirectory unencryptedDirectory = FolderHelper.getHomeDirectory(userIDAuth.getUserID()).appendDirectory(documentDirectoryFQN.getValue());
            dfsAndKeystoreAndPath.encryptedBucketDirectory = this.bucketPathEncryptionService.encrypt(dfsAndKeystoreAndPath.pathEncryptionKey, unencryptedDirectory);
        }
        return dfsAndKeystoreAndPath;
    }

    private Payload encryptDataForUserWithRandomKey(UserID userID, Payload unencryptedContent) {
        try {
            PublicKeyIDWithPublicKey publicKeyIDWithPublicKey = this.getPublicKeyIDWithPublicKey(userID);
            SimplePayloadImpl unencryptedPayload = new SimplePayloadImpl(unencryptedContent.getData());
            CMSEnvelopedData cmsEnvelope = this.cmsEncryptionService.encrypt((Payload)unencryptedPayload, publicKeyIDWithPublicKey.getPublicKey(), publicKeyIDWithPublicKey.getKeyID());
            return new SimplePayloadImpl(cmsEnvelope.getEncoded());
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    private PublicKeyIDWithPublicKey getPublicKeyIDWithPublicKey(UserID userID) {
        Payload publicKeysAsPayload = this.systemDFS.getBlob(FolderHelper.getPublicKeyListPath(userID));
        List<PublicKeyIDWithPublicKey> publicKeys = this.class2JsonHelper.contentToKeyList(publicKeysAsPayload);
        Random random = new Random();
        return publicKeys.get(random.nextInt(publicKeys.size()));
    }

    private void storeUserDFSCredentials(UserIDAuth userIDAuth, KeyStoreAccess publicKeyStoreAccess, DFSCredentials userDFSCredentials) throws IOException {
        PublicKeyIDWithPublicKey publicKeyIDWithPublicKey = (PublicKeyIDWithPublicKey)this.keyStoreService.getPublicKeys(publicKeyStoreAccess).get(0);
        Payload payload = this.class2JsonHelper.dfsCredentialsToContent(userDFSCredentials);
        CMSEnvelopedData encryptedDFSCredentialsAsEnvelope = this.cmsEncryptionService.encrypt(payload, publicKeyIDWithPublicKey.getPublicKey(), publicKeyIDWithPublicKey.getKeyID());
        SimplePayloadImpl encryptedPayload = new SimplePayloadImpl(encryptedDFSCredentialsAsEnvelope.getEncoded());
        this.systemDFS.putBlob(FolderHelper.getDFSCredentialsPath(userIDAuth.getUserID()), (Payload)encryptedPayload);
        log.debug("stored the new dfs credentials info");
    }

    private static final class DFSAndKeystoreAndPath {
        DFSConnection usersDFS;
        KeyStoreAccess privateKeystoreAccess;
        SecretKey pathEncryptionKey;
        BucketPath encryptedBucketPath;
        BucketDirectory encryptedBucketDirectory;

        private DFSAndKeystoreAndPath() {
        }
    }
}

