/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.docusafe.business.types;

import de.adorsys.common.basetypes.BaseTypeString;
import de.adorsys.common.exceptions.BaseException;
import de.adorsys.dfs.connection.api.complextypes.BucketDirectory;
import org.adorsys.docusafe.business.types.DocumentFQN;

public class DocumentDirectoryFQN
extends BaseTypeString {
    public DocumentDirectoryFQN(String value) {
        super(DocumentFQN.check(DocumentDirectoryFQN.prependStartingSeparator(value)));
    }

    public DocumentFQN addName(String value) {
        if (this.getValue().length() == 1) {
            return new DocumentFQN(value);
        }
        return this.addName(new DocumentFQN(value));
    }

    public DocumentFQN addName(DocumentFQN fqn) {
        if (this.getValue().length() == 1) {
            return fqn;
        }
        return new DocumentFQN(this.getValue() + fqn.getValue());
    }

    public DocumentDirectoryFQN addDirectory(String value) {
        if (this.getValue().length() == 1) {
            return new DocumentDirectoryFQN(value);
        }
        return this.addDirectory(new DocumentDirectoryFQN(value));
    }

    public DocumentDirectoryFQN addDirectory(DocumentDirectoryFQN value) {
        if (this.getValue().length() == 1) {
            return value;
        }
        if (value.getValue().length() == 1) {
            return new DocumentDirectoryFQN(this.getValue());
        }
        return new DocumentDirectoryFQN(this.getValue() + value.getValue());
    }

    public BucketDirectory prepend(BucketDirectory bucketDirectory) {
        if (this.getValue().length() == 1) {
            return bucketDirectory;
        }
        return bucketDirectory.appendDirectory(this.getValue());
    }

    private static String prependStartingSeparator(String s) {
        if (s.startsWith("/")) {
            if (s.length() > 1 && s.startsWith("//")) {
                throw new BaseException("programming error, path never should start with two dashes" + s);
            }
            return s;
        }
        return "/" + s;
    }
}

