/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.docusafe.business.impl.jsonserialisation;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import de.adorsys.common.exceptions.BaseExceptionHandler;
import de.adorsys.dfs.connection.api.domain.Payload;
import de.adorsys.dfs.connection.api.service.impl.SimplePayloadImpl;
import java.lang.reflect.Type;
import java.security.PublicKey;
import java.util.List;
import org.adorsys.docusafe.business.impl.jsonserialisation.PublicKeyJsonAdapter;
import org.adorsys.docusafe.business.types.DFSCredentials;
import org.adorsys.docusafe.service.api.keystore.types.PublicKeyIDWithPublicKey;
import org.adorsys.docusafe.service.api.keystore.types.PublicKeyList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Class2JsonHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(Class2JsonHelper.class);
    private static final String CHARSET = "UTF-8";
    public static final String DATE_FORMAT_STRING = "yyyy-MM-dd HH:mm:ss.SSS";
    private Gson gson = new GsonBuilder().setPrettyPrinting().enableComplexMapKeySerialization().registerTypeAdapter(PublicKey.class, (Object)new PublicKeyJsonAdapter()).setDateFormat("yyyy-MM-dd HH:mm:ss.SSS").create();

    public Payload dfsCredentialsToContent(DFSCredentials dfsConnection) {
        try {
            String s = this.gson.toJson((Object)dfsConnection);
            return new SimplePayloadImpl(s.getBytes(CHARSET));
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    public DFSCredentials contentToDFSConnection(Payload payload) {
        try {
            String jsonString = new String(payload.getData(), CHARSET);
            return (DFSCredentials)this.gson.fromJson(jsonString, DFSCredentials.class);
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    public Payload keyListToContent(List<PublicKeyIDWithPublicKey> list) {
        try {
            PublicKeyList publicKeyList = new PublicKeyList();
            publicKeyList.addAll(list);
            String s = this.gson.toJson((Object)publicKeyList);
            return new SimplePayloadImpl(s.getBytes(CHARSET));
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    public List<PublicKeyIDWithPublicKey> contentToKeyList(Payload payload) {
        try {
            String jsonString = new String(payload.getData(), CHARSET);
            return (List)this.gson.fromJson(jsonString, PublicKeyList.class);
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    private static class InterfaceAdapter<T>
    implements JsonSerializer<T>,
    JsonDeserializer<T> {
        private static final String CLASSNAME = "CLASSNAME";
        private static final String DATA = "DATA";

        private InterfaceAdapter() {
        }

        public T deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            JsonPrimitive prim = (JsonPrimitive)jsonObject.get(CLASSNAME);
            String className = prim.getAsString();
            Class klass = this.getObjectClass(className);
            return (T)jsonDeserializationContext.deserialize(jsonObject.get(DATA), (Type)klass);
        }

        public JsonElement serialize(T jsonElement, Type type, JsonSerializationContext jsonSerializationContext) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty(CLASSNAME, jsonElement.getClass().getName());
            jsonObject.add(DATA, jsonSerializationContext.serialize(jsonElement));
            return jsonObject;
        }

        public Class getObjectClass(String className) {
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new JsonParseException(e.getMessage());
            }
        }
    }
}

