/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.dfs.connection.impl.pathencryption;

import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.StringTokenizer;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.adorsys.common.exceptions.BaseExceptionHandler;
import org.adorsys.common.utils.HexUtil;
import org.adorsys.dfs.connection.api.complextypes.BucketDirectory;
import org.adorsys.dfs.connection.api.complextypes.BucketPath;
import org.adorsys.dfs.connection.api.complextypes.BucketPathUtil;
import org.adorsys.dfs.connection.api.exceptions.PathDecryptionException;
import org.adorsys.dfs.connection.api.exceptions.PathEncryptionException;
import org.adorsys.dfs.connection.api.types.BucketPathEncryptionPassword;
import org.adorsys.dfs.connection.api.types.properties.BucketPathEncryptionFilenameOnly;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BucketPathEncryption {
    private static final Logger LOGGER = LoggerFactory.getLogger(BucketPathEncryption.class);
    public static final String UTF_8 = "UTF-8";
    private static final Charset CHARSET = Charset.forName("UTF-8");

    public static BucketDirectory encrypt(BucketPathEncryptionPassword bucketPathEncryptionPassword, BucketPathEncryptionFilenameOnly bucketPathEncryptionFilenameOnly, BucketDirectory bucketDirectory) {
        return new BucketDirectory(BucketPathEncryption.encrypt(bucketPathEncryptionPassword, bucketPathEncryptionFilenameOnly, BucketPathUtil.getAsString((BucketDirectory)bucketDirectory), false));
    }

    public static BucketPath encrypt(BucketPathEncryptionPassword bucketPathEncryptionPassword, BucketPathEncryptionFilenameOnly bucketPathEncryptionFilenameOnly, BucketPath bucketPath) {
        return new BucketPath(BucketPathEncryption.encrypt(bucketPathEncryptionPassword, bucketPathEncryptionFilenameOnly, BucketPathUtil.getAsString((BucketPath)bucketPath), true));
    }

    public static BucketDirectory decrypt(BucketPathEncryptionPassword bucketPathEncryptionPassword, BucketPathEncryptionFilenameOnly bucketPathEncryptionFilenameOnly, BucketDirectory bucketDirectory) {
        return new BucketDirectory(BucketPathEncryption.decrypt(bucketPathEncryptionPassword, bucketPathEncryptionFilenameOnly, BucketPathUtil.getAsString((BucketDirectory)bucketDirectory), false));
    }

    public static BucketPath decrypt(BucketPathEncryptionPassword bucketPathEncryptionPassword, BucketPathEncryptionFilenameOnly bucketPathEncryptionFilenameOnly, BucketPath bucketPath) {
        return new BucketPath(BucketPathEncryption.decrypt(bucketPathEncryptionPassword, bucketPathEncryptionFilenameOnly, BucketPathUtil.getAsString((BucketPath)bucketPath), true));
    }

    private static String encrypt(BucketPathEncryptionPassword bucketPathEncryptionPassword, BucketPathEncryptionFilenameOnly bucketPathEncryptionFilenameOnly, String fullString, Boolean isPath) {
        try {
            Cipher cipher = BucketPathEncryption.createCipher(bucketPathEncryptionPassword, 1);
            StringBuilder encryptedPath = new StringBuilder();
            StringTokenizer st = new StringTokenizer(fullString, "/");
            while (st.hasMoreTokens()) {
                byte[] encryptedBytes;
                byte[] compressedBytes;
                String plainString = st.nextToken();
                String encryptedBytesAsHexString = null;
                if (isPath.booleanValue() && !st.hasMoreTokens()) {
                    compressedBytes = BucketPathEncryption.compress(plainString);
                    encryptedBytes = cipher.doFinal(compressedBytes);
                    encryptedBytesAsHexString = HexUtil.convertBytesToHexString((byte[])encryptedBytes).toLowerCase();
                } else if (bucketPathEncryptionFilenameOnly.equals((Object)BucketPathEncryptionFilenameOnly.TRUE)) {
                    encryptedBytesAsHexString = plainString;
                } else {
                    compressedBytes = BucketPathEncryption.compress(plainString);
                    encryptedBytes = cipher.doFinal(compressedBytes);
                    encryptedBytesAsHexString = HexUtil.convertBytesToHexString((byte[])encryptedBytes).toLowerCase();
                }
                encryptedPath.append("/" + encryptedBytesAsHexString);
            }
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace(String.format("%3d -> %3d", fullString.length(), encryptedPath.toString().length()) + " encrypted (" + fullString + ") -> (" + encryptedPath.toString() + ")");
            }
            return encryptedPath.toString();
        }
        catch (Exception e) {
            throw new PathEncryptionException(fullString, e);
        }
    }

    public static String decrypt(BucketPathEncryptionPassword BucketPathEncryptionPassword2, BucketPathEncryptionFilenameOnly bucketPathEncryptionFilenameOnly, String encryptedHexString, Boolean isPath) {
        try {
            Cipher cipher = BucketPathEncryption.createCipher(BucketPathEncryptionPassword2, 2);
            StringBuilder plainPath = new StringBuilder();
            StringTokenizer st = new StringTokenizer(encryptedHexString, "/");
            while (st.hasMoreTokens()) {
                byte[] compressedBytes;
                byte[] encryptedBytes;
                String encryptedBytesAsHexString = st.nextToken();
                String plainString = null;
                if (isPath.booleanValue() && !st.hasMoreTokens()) {
                    encryptedBytes = HexUtil.convertHexStringToBytes((String)encryptedBytesAsHexString.toUpperCase());
                    compressedBytes = cipher.doFinal(encryptedBytes);
                    plainString = BucketPathEncryption.decompress(compressedBytes);
                } else if (bucketPathEncryptionFilenameOnly.equals((Object)BucketPathEncryptionFilenameOnly.TRUE)) {
                    plainString = encryptedBytesAsHexString;
                } else {
                    encryptedBytes = HexUtil.convertHexStringToBytes((String)encryptedBytesAsHexString.toUpperCase());
                    compressedBytes = cipher.doFinal(encryptedBytes);
                    plainString = BucketPathEncryption.decompress(compressedBytes);
                }
                plainPath.append("/" + plainString);
            }
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace(String.format("%3d -> %3d", encryptedHexString.length(), plainPath.toString().length()) + " decrypted (" + encryptedHexString + ") -> (" + plainPath.toString() + ")");
            }
            return plainPath.toString();
        }
        catch (Exception e) {
            throw new PathDecryptionException(encryptedHexString, e);
        }
    }

    private static Cipher createCipher(BucketPathEncryptionPassword bucketPathEncryptionPassword, int cipherMode) {
        try {
            byte[] key = bucketPathEncryptionPassword.getValue().getBytes(UTF_8);
            MessageDigest sha = MessageDigest.getInstance("SHA-256");
            key = sha.digest(key);
            key = Arrays.copyOf(key, 16);
            SecretKeySpec secretKeySpec = new SecretKeySpec(key, "AES");
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(cipherMode, secretKeySpec);
            return cipher;
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    private static byte[] compress(String data) {
        return data.getBytes(CHARSET);
    }

    private static String decompress(byte[] compressed) {
        return new String(compressed, CHARSET);
    }
}

