/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.dfs.connection.impl.pathencryption;

import java.util.ArrayList;
import java.util.List;
import org.adorsys.common.exceptions.BaseException;
import org.adorsys.common.utils.Frame;
import org.adorsys.dfs.connection.api.complextypes.BucketDirectory;
import org.adorsys.dfs.connection.api.complextypes.BucketPath;
import org.adorsys.dfs.connection.api.complextypes.BucketPathUtil;
import org.adorsys.dfs.connection.api.domain.Payload;
import org.adorsys.dfs.connection.api.domain.PayloadStream;
import org.adorsys.dfs.connection.api.domain.StorageMetadata;
import org.adorsys.dfs.connection.api.domain.StorageType;
import org.adorsys.dfs.connection.api.exceptions.BucketRestrictionException;
import org.adorsys.dfs.connection.api.service.api.ExtendedStoreConnection;
import org.adorsys.dfs.connection.api.service.impl.SimplePayloadImpl;
import org.adorsys.dfs.connection.api.service.impl.SimplePayloadStreamImpl;
import org.adorsys.dfs.connection.api.service.impl.SimpleStorageMetadataImpl;
import org.adorsys.dfs.connection.api.types.BucketPathEncryptionPassword;
import org.adorsys.dfs.connection.api.types.ExtendedStoreConnectionType;
import org.adorsys.dfs.connection.api.types.ListRecursiveFlag;
import org.adorsys.dfs.connection.api.types.properties.BucketPathEncryptionFilenameOnly;
import org.adorsys.dfs.connection.impl.pathencryption.BucketPathEncryption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BucketPathEncryptingExtendedStoreConnection
implements ExtendedStoreConnection {
    private static final MaxLengthInfo AMAZONS3_MAX_LENGTH = new MaxLengthInfo(175, -1);
    private static final MaxLengthInfo MONGO__MAX_LENGTH = new MaxLengthInfo(88, -1);
    private MaxLengthInfo maxLengthInfo;
    private static final Logger LOGGER = LoggerFactory.getLogger(BucketPathEncryptingExtendedStoreConnection.class);
    protected ExtendedStoreConnection extendedStoreConnection;
    BucketPathEncryption bucketPathEncryption;
    BucketPathEncryptionPassword bucketPathEncryptionPassword;
    BucketPathEncryptionFilenameOnly bucketPathEncryptionFilenameOnly;
    boolean active;

    public BucketPathEncryptingExtendedStoreConnection(ExtendedStoreConnection extendedStoreConnection, BucketPathEncryptionPassword bucketPathEncryptionPassword, BucketPathEncryptionFilenameOnly bucketPathEncryptionFilenameOnly) {
        this.active = this.bucketPathEncryptionPassword != null;
        this.extendedStoreConnection = extendedStoreConnection;
        this.bucketPathEncryption = new BucketPathEncryption();
        this.bucketPathEncryptionPassword = bucketPathEncryptionPassword;
        this.active = bucketPathEncryptionPassword != null;
        this.maxLengthInfo = BucketPathEncryptingExtendedStoreConnection.getMaxLengthTupel(this.extendedStoreConnection);
        this.bucketPathEncryptionFilenameOnly = bucketPathEncryptionFilenameOnly;
        Frame frame = new Frame();
        if (extendedStoreConnection.getType().equals((Object)ExtendedStoreConnectionType.MONGO)) {
            if (this.active) {
                frame.add("WARNING WARNING WARNING");
                frame.add("MONGO DB FILE NAMES CAN NOT BE ENCRYPTED DUE TO LENGTH RESTRICTION");
            }
            this.active = false;
            this.bucketPathEncryptionPassword = null;
        }
        if (this.active) {
            frame.add(bucketPathEncryptionPassword.toString());
            frame.add("BucketPathEncryptionFilenameOnly:" + bucketPathEncryptionFilenameOnly.toString());
        } else {
            frame.add("Filenames will not be encrypted");
        }
        LOGGER.info(frame.toString());
        if (LOGGER.isTraceEnabled()) {
            new BaseException("JUST A STACK, TO SEE WHERE THE CONNECTION IS CREATED");
        }
    }

    public void putBlob(BucketPath bucketPath, Payload payload) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("putBlob(" + bucketPath + ", payload)");
        }
        this.extendedStoreConnection.putBlob(this.e(bucketPath), payload);
    }

    public Payload getBlob(BucketPath bucketPath) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("getBlob(" + bucketPath + ")");
        }
        return this.d(this.extendedStoreConnection.getBlob(this.e(bucketPath)));
    }

    public Payload getBlob(BucketPath bucketPath, StorageMetadata storageMetadata) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("getBlob(" + bucketPath + " ,storageMetadata)");
        }
        return this.d(this.extendedStoreConnection.getBlob(this.e(bucketPath), this.e(storageMetadata)));
    }

    public void putBlobStream(BucketPath bucketPath, PayloadStream payloadStream) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("putBlobStream(" + bucketPath + " ,payloadStream)");
        }
        this.extendedStoreConnection.putBlobStream(this.e(bucketPath), payloadStream);
    }

    public PayloadStream getBlobStream(BucketPath bucketPath) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("getBlobStream(" + bucketPath + ")");
        }
        return this.d(this.extendedStoreConnection.getBlobStream(this.e(bucketPath)));
    }

    public PayloadStream getBlobStream(BucketPath bucketPath, StorageMetadata storageMetadata) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("getBlobStream(" + bucketPath + " ,storageMetadata)");
        }
        return this.d(this.extendedStoreConnection.getBlobStream(this.e(bucketPath), this.e(storageMetadata)));
    }

    public void putBlob(BucketPath bucketPath, byte[] bytes) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("putBlob(" + bucketPath + " ,byte[])");
        }
        this.extendedStoreConnection.putBlob(this.e(bucketPath), bytes);
    }

    public StorageMetadata getStorageMetadata(BucketPath bucketPath) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("getStorageMetadata(" + bucketPath + ")");
        }
        return this.d(this.extendedStoreConnection.getStorageMetadata(this.e(bucketPath)));
    }

    public boolean blobExists(BucketPath bucketPath) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("blobExists(" + bucketPath + ")");
        }
        return this.extendedStoreConnection.blobExists(this.e(bucketPath));
    }

    public void removeBlob(BucketPath bucketPath) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("removeBlob(" + bucketPath + ")");
        }
        this.extendedStoreConnection.removeBlob(this.e(bucketPath));
    }

    public void removeBlobFolder(BucketDirectory bucketDirectory) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("removeBlobFolder(" + bucketDirectory + ")");
        }
        this.extendedStoreConnection.removeBlobFolder(this.e(bucketDirectory));
    }

    public void createContainer(BucketDirectory bucketDirectory) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("createContainer(" + bucketDirectory + ")");
        }
        this.extendedStoreConnection.createContainer(this.e(bucketDirectory));
    }

    public boolean containerExists(BucketDirectory bucketDirectory) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("containerExists(" + bucketDirectory + ")");
        }
        return this.extendedStoreConnection.containerExists(this.e(bucketDirectory));
    }

    public void deleteContainer(BucketDirectory bucketDirectory) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("deleteContainer(" + bucketDirectory + ")");
        }
        this.extendedStoreConnection.deleteContainer(this.e(bucketDirectory));
    }

    public List<StorageMetadata> list(BucketDirectory bucketDirectory, ListRecursiveFlag listRecursiveFlag) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("list(" + bucketDirectory + " ," + listRecursiveFlag + ")");
        }
        return this.d(this.extendedStoreConnection.list(this.e(bucketDirectory), listRecursiveFlag));
    }

    public List<BucketDirectory> listAllBuckets() {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("listAllBuckets()");
        }
        return this.de(this.extendedStoreConnection.listAllBuckets());
    }

    public ExtendedStoreConnectionType getType() {
        return this.extendedStoreConnection.getType();
    }

    public MaxLengthInfo getMaxLengthInfo() {
        return this.maxLengthInfo;
    }

    private List<BucketDirectory> de(List<BucketDirectory> bucketDirectories) {
        ArrayList<BucketDirectory> newBucketDirectoryList = new ArrayList<BucketDirectory>();
        bucketDirectories.forEach(bucketDirectory -> newBucketDirectoryList.add(this.d((BucketDirectory)bucketDirectory)));
        return newBucketDirectoryList;
    }

    private BucketPath e(BucketPath bucketPath) {
        if (!this.active) {
            return this.checkLength(this.maxLengthInfo, bucketPath, null);
        }
        return this.checkLength(this.maxLengthInfo, BucketPathEncryption.encrypt(this.bucketPathEncryptionPassword, this.bucketPathEncryptionFilenameOnly, bucketPath), bucketPath);
    }

    private BucketDirectory e(BucketDirectory bucketDirectory) {
        if (!this.active) {
            return this.checkLength(this.maxLengthInfo, bucketDirectory, null);
        }
        return this.checkLength(this.maxLengthInfo, BucketPathEncryption.encrypt(this.bucketPathEncryptionPassword, this.bucketPathEncryptionFilenameOnly, bucketDirectory), bucketDirectory);
    }

    private BucketDirectory d(BucketDirectory bucketDirectory) {
        if (!this.active) {
            return bucketDirectory;
        }
        return BucketPathEncryption.decrypt(this.bucketPathEncryptionPassword, this.bucketPathEncryptionFilenameOnly, bucketDirectory);
    }

    private Payload d(Payload payload) {
        if (!this.active) {
            return payload;
        }
        return new SimplePayloadImpl(this.d(payload.getStorageMetadata()), payload.getData());
    }

    private PayloadStream d(PayloadStream payloadStream) {
        if (!this.active) {
            return payloadStream;
        }
        return new SimplePayloadStreamImpl(this.d(payloadStream.getStorageMetadata()), payloadStream.openStream());
    }

    private StorageMetadata d(StorageMetadata storageMetadata) {
        if (!this.active) {
            return storageMetadata;
        }
        String encryptedName = storageMetadata.getName();
        String decryptedName = null;
        if (((StorageType)storageMetadata.getType()).equals((Object)StorageType.BLOB)) {
            BucketPath encryptedBucketPath = new BucketPath(encryptedName);
            BucketPath decryptedBucketPath = BucketPathEncryption.decrypt(this.bucketPathEncryptionPassword, this.bucketPathEncryptionFilenameOnly, encryptedBucketPath);
            decryptedName = BucketPathUtil.getAsString((BucketPath)decryptedBucketPath);
        }
        if (((StorageType)storageMetadata.getType()).equals((Object)StorageType.FOLDER)) {
            BucketDirectory encryptedBucketDirectory = new BucketDirectory(encryptedName);
            BucketDirectory decryptedBucketDirectory = BucketPathEncryption.decrypt(this.bucketPathEncryptionPassword, this.bucketPathEncryptionFilenameOnly, encryptedBucketDirectory);
            decryptedName = BucketPathUtil.getAsString((BucketDirectory)decryptedBucketDirectory);
        }
        SimpleStorageMetadataImpl newStorageMetadata = new SimpleStorageMetadataImpl(storageMetadata);
        newStorageMetadata.setName(decryptedName);
        return newStorageMetadata;
    }

    private StorageMetadata e(StorageMetadata storageMetadata) {
        if (!this.active) {
            return storageMetadata;
        }
        if (storageMetadata == null) {
            return storageMetadata;
        }
        String plainName = storageMetadata.getName();
        BucketPath plainBucketPath = new BucketPath(plainName);
        BucketPath encryptedBucketPath = BucketPathEncryption.encrypt(this.bucketPathEncryptionPassword, this.bucketPathEncryptionFilenameOnly, plainBucketPath);
        String encryptedName = BucketPathUtil.getAsString((BucketPath)encryptedBucketPath);
        SimpleStorageMetadataImpl newStorageMetadata = new SimpleStorageMetadataImpl(storageMetadata);
        newStorageMetadata.setName(encryptedName);
        return newStorageMetadata;
    }

    private List<StorageMetadata> d(List<StorageMetadata> list) {
        if (!this.active) {
            return list;
        }
        ArrayList<StorageMetadata> newStorageMetadataList = new ArrayList<StorageMetadata>();
        list.forEach(storageMetadata -> newStorageMetadataList.add(this.d((StorageMetadata)storageMetadata)));
        return newStorageMetadataList;
    }

    private static MaxLengthInfo getMaxLengthTupel(ExtendedStoreConnection extendedStoreConnection) {
        switch (extendedStoreConnection.getType()) {
            case FILESYSTEM: 
            case AMAZONS3: {
                return AMAZONS3_MAX_LENGTH;
            }
            case MONGO: {
                return MONGO__MAX_LENGTH;
            }
        }
        throw new BaseException("missing switch for " + extendedStoreConnection.getType());
    }

    private BucketDirectory checkLength(MaxLengthInfo maxLengthInfo, BucketDirectory realPath, BucketDirectory plainPath) {
        String realPathAsString = BucketPathUtil.getAsString((BucketDirectory)realPath);
        for (String s : BucketPathUtil.split((String)realPathAsString)) {
            if (s.length() <= maxLengthInfo.getPartMaxLength()) continue;
            if (plainPath == null) {
                throw new BucketRestrictionException(realPathAsString + " has part " + s + " with length " + s.length() + " must not exceed part length " + maxLengthInfo.getPartMaxLength());
            }
            throw new BucketRestrictionException(BucketPathUtil.getAsString((BucketDirectory)plainPath) + " -> " + realPathAsString + " has part " + s + " with length " + s.length() + " must not exceed part length " + maxLengthInfo.getPartMaxLength());
        }
        if (maxLengthInfo.getTotalMaxLength() > -1 && realPathAsString.length() > maxLengthInfo.getTotalMaxLength()) {
            if (plainPath == null) {
                throw new BucketRestrictionException(realPathAsString + " with length " + realPathAsString.length() + " must not exceed part length " + maxLengthInfo.getTotalMaxLength());
            }
            throw new BucketRestrictionException(BucketPathUtil.getAsString((BucketDirectory)plainPath) + " -> " + realPathAsString + " with length " + realPathAsString.length() + " must not exceed part length " + maxLengthInfo.getTotalMaxLength());
        }
        return realPath;
    }

    private BucketPath checkLength(MaxLengthInfo maxLengthInfo, BucketPath realPath, BucketPath plainPath) {
        String realPathAsString = BucketPathUtil.getAsString((BucketPath)realPath);
        for (String s : BucketPathUtil.split((String)realPathAsString)) {
            if (s.length() <= maxLengthInfo.getPartMaxLength()) continue;
            if (plainPath == null) {
                throw new BucketRestrictionException(realPathAsString + " has part " + s + " with length " + s.length() + " must not exceed part length " + maxLengthInfo.getPartMaxLength());
            }
            throw new BucketRestrictionException(BucketPathUtil.getAsString((BucketPath)plainPath) + " -> " + realPathAsString + " has part " + s + " with length " + s.length() + " must not exceed part length " + maxLengthInfo.getPartMaxLength());
        }
        if (maxLengthInfo.getTotalMaxLength() > -1 && realPathAsString.length() > maxLengthInfo.getTotalMaxLength()) {
            if (plainPath == null) {
                throw new BucketRestrictionException(realPathAsString + " with length " + realPathAsString.length() + " must not exceed part length " + maxLengthInfo.getTotalMaxLength());
            }
            throw new BucketRestrictionException(BucketPathUtil.getAsString((BucketPath)plainPath) + " -> " + realPathAsString + " with length " + realPathAsString.length() + " must not exceed part length " + maxLengthInfo.getTotalMaxLength());
        }
        return realPath;
    }

    public static class MaxLengthInfo {
        int partMaxLength;
        int totalMaxLength;

        public MaxLengthInfo(int partMaxLength, int totalMaxLength) {
            this.partMaxLength = partMaxLength;
            this.totalMaxLength = totalMaxLength;
        }

        public int getPartMaxLength() {
            return this.partMaxLength;
        }

        public int getTotalMaxLength() {
            return this.totalMaxLength;
        }
    }
}

