/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.dfs.connection.impl.mongodb;

import com.mongodb.DB;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.MongoCommandException;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.gridfs.GridFSBucket;
import com.mongodb.client.gridfs.GridFSBuckets;
import com.mongodb.client.gridfs.GridFSDownloadStream;
import com.mongodb.client.gridfs.GridFSFindIterable;
import com.mongodb.client.gridfs.model.GridFSDownloadOptions;
import com.mongodb.client.gridfs.model.GridFSUploadOptions;
import com.mongodb.client.model.Filters;
import com.mongodb.gridfs.GridFS;
import com.mongodb.gridfs.GridFSDBFile;
import de.adorsys.common.exceptions.BaseException;
import de.adorsys.common.exceptions.BaseExceptionHandler;
import de.adorsys.common.utils.Frame;
import de.adorsys.dfs.connection.api.complextypes.BucketDirectory;
import de.adorsys.dfs.connection.api.complextypes.BucketPath;
import de.adorsys.dfs.connection.api.complextypes.BucketPathUtil;
import de.adorsys.dfs.connection.api.domain.Payload;
import de.adorsys.dfs.connection.api.domain.PayloadStream;
import de.adorsys.dfs.connection.api.domain.StorageMetadata;
import de.adorsys.dfs.connection.api.domain.StorageType;
import de.adorsys.dfs.connection.api.exceptions.ResourceNotFoundException;
import de.adorsys.dfs.connection.api.exceptions.StorageConnectionException;
import de.adorsys.dfs.connection.api.filesystem.StorageMetadataFlattenerGSON;
import de.adorsys.dfs.connection.api.service.api.ExtendedStoreConnection;
import de.adorsys.dfs.connection.api.service.impl.SimplePayloadImpl;
import de.adorsys.dfs.connection.api.service.impl.SimplePayloadStreamImpl;
import de.adorsys.dfs.connection.api.service.impl.SimpleStorageMetadataImpl;
import de.adorsys.dfs.connection.api.service.impl.StoreConnectionListHelper;
import de.adorsys.dfs.connection.api.types.ExtendedStoreConnectionType;
import de.adorsys.dfs.connection.api.types.ListRecursiveFlag;
import de.adorsys.dfs.connection.api.types.connection.MongoURI;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.bson.Document;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RealMongoDBExtendedStoreConnection
implements ExtendedStoreConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(RealMongoDBExtendedStoreConnection.class);
    private static final Logger SPECIAL_LOGGER = LoggerFactory.getLogger((String)"SPECIAL_LOGGER");
    private static final String STORAGE_METADATA_KEY = "StorageMetadata";
    private static final String FILENAME_TAG = "filename";
    private static final String BUCKET_ID_FILENAME = ".bcd";
    private MongoDatabase database;
    private DB databaseDeprecated;
    protected StorageMetadataFlattenerGSON gsonHelper = new StorageMetadataFlattenerGSON();

    public RealMongoDBExtendedStoreConnection(MongoURI mongoURI) {
        MongoClientURI mongoClientUri = null;
        try {
            mongoClientUri = new MongoClientURI(mongoURI.getValue());
        }
        catch (Exception e) {
            throw new BaseException("can not parse:\"" + mongoURI.getValue() + "\" " + "<mongoClientUri> (mongodb://[username:password@]host1[:port1][,host2[:port2],...[,hostN[:portN]]][/[database.collection][?options]]) - see http://mongodb.github.io/mongo-java-driver/3.6/javadoc/com/mongodb/MongoClientURI.html", (Throwable)e);
        }
        Frame frame = new Frame();
        frame.add("USE MONGO DB");
        frame.add("mongo db has be up and running");
        frame.add("uri: " + mongoURI.getValue());
        frame.add(" -> database:" + mongoClientUri.getDatabase());
        frame.add(" -> user:" + mongoClientUri.getUsername());
        mongoClientUri.getHosts().forEach(host -> frame.add(" -> host:" + host));
        frame.add(" -> ssl:" + mongoClientUri.getOptions().isSslEnabled());
        LOGGER.info(frame.toString());
        MongoClient mongoClient = new MongoClient(mongoClientUri);
        this.database = mongoClient.getDatabase(mongoClientUri.getDatabase());
        this.databaseDeprecated = mongoClient.getDB(mongoClientUri.getDatabase());
    }

    public void putBlob(BucketPath bucketPath, Payload payload) {
        this.putBlobStream(bucketPath, (PayloadStream)new SimplePayloadStreamImpl(payload.getStorageMetadata(), (InputStream)new ByteArrayInputStream(payload.getData())));
    }

    public Payload getBlob(BucketPath bucketPath) {
        return this.getBlob(bucketPath, null);
    }

    public Payload getBlob(BucketPath bucketPath, StorageMetadata storageMetadata) {
        try {
            PayloadStream blobStream = this.getBlobStream(bucketPath, storageMetadata);
            return new SimplePayloadImpl(blobStream.getStorageMetadata(), IOUtils.toByteArray((InputStream)blobStream.openStream()));
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    public void putBlobStream(BucketPath bucketPath, PayloadStream payloadStream) {
        LOGGER.debug("start putBlobStream for " + bucketPath);
        GridFSBucket bucket = this.getGridFSBucket(bucketPath);
        this.checkBucketExists(bucket);
        String filename = bucketPath.getObjectHandle().getName();
        GridFSUploadOptions uploadOptions = new GridFSUploadOptions();
        uploadOptions.metadata(new Document());
        SimpleStorageMetadataImpl storageMetadata = new SimpleStorageMetadataImpl(payloadStream.getStorageMetadata());
        storageMetadata.setType(StorageType.BLOB);
        storageMetadata.setName(BucketPathUtil.getAsString((BucketPath)bucketPath));
        uploadOptions.getMetadata().put(STORAGE_METADATA_KEY, (Object)this.gsonHelper.toJson((StorageMetadata)storageMetadata));
        InputStream is = payloadStream.openStream();
        ObjectId objectId = bucket.uploadFromStream(filename, is, uploadOptions);
        IOUtils.closeQuietly((InputStream)is);
        this.deleteAllExcept(bucket, filename, objectId);
        LOGGER.debug("finished putBlobStream for " + bucketPath);
    }

    public PayloadStream getBlobStream(BucketPath bucketPath) {
        return this.getBlobStream(bucketPath, null);
    }

    public PayloadStream getBlobStream(BucketPath bucketPath, StorageMetadata storageMetadata) {
        LOGGER.debug("start getBlobStream for " + bucketPath);
        if (storageMetadata == null) {
            storageMetadata = this.getStorageMetadata(bucketPath);
        }
        GridFSBucket bucket = this.getGridFSBucket(bucketPath);
        this.checkBucketExists(bucket);
        String filename = bucketPath.getObjectHandle().getName();
        GridFSDownloadOptions options = new GridFSDownloadOptions();
        GridFSDownloadStream fileStream = bucket.openDownloadStream(filename, options);
        SimplePayloadStreamImpl payloadStream = new SimplePayloadStreamImpl(storageMetadata, (InputStream)fileStream);
        LOGGER.debug("finished getBlobStream for " + bucketPath);
        return payloadStream;
    }

    public void putBlob(BucketPath bucketPath, byte[] bytes) {
        this.putBlob(bucketPath, (Payload)new SimplePayloadImpl((StorageMetadata)new SimpleStorageMetadataImpl(), bytes));
    }

    public StorageMetadata getStorageMetadata(BucketPath bucketPath) {
        SPECIAL_LOGGER.debug("readmetadata " + bucketPath);
        LOGGER.debug("readmetadata " + bucketPath);
        GridFSBucket bucket = this.getGridFSBucket(bucketPath);
        this.checkBucketExists(bucket);
        GridFS gridFS = new GridFS(this.databaseDeprecated, bucketPath.getObjectHandle().getContainer());
        GridFSDBFile one = gridFS.findOne(bucketPath.getObjectHandle().getName());
        String jsonString = (String)one.getMetaData().get(STORAGE_METADATA_KEY);
        return this.gsonHelper.fromJson(jsonString);
    }

    public boolean blobExists(BucketPath bucketPath) {
        LOGGER.debug("start blob Exists for " + bucketPath);
        GridFSBucket bucket = this.getGridFSBucket(bucketPath);
        if (!this.containerExists(bucket)) {
            return false;
        }
        String filename = bucketPath.getObjectHandle().getName();
        ArrayList ids = new ArrayList();
        bucket.find(Filters.eq((String)FILENAME_TAG, (Object)filename)).forEach(file -> ids.add(file.getObjectId()));
        LOGGER.debug("finished blob Exists for " + bucketPath);
        return !ids.isEmpty();
    }

    public void removeBlob(BucketPath bucketPath) {
        LOGGER.debug("start removeBlob for " + bucketPath);
        GridFSBucket bucket = this.getGridFSBucket(bucketPath);
        this.checkBucketExists(bucket);
        String filename = bucketPath.getObjectHandle().getName();
        ArrayList ids = new ArrayList();
        bucket.find(Filters.eq((String)FILENAME_TAG, (Object)filename)).forEach(file -> ids.add(file.getObjectId()));
        ids.forEach(id -> bucket.delete(id));
        LOGGER.debug("finished removeBlob for " + bucketPath);
    }

    public void removeBlobFolder(BucketDirectory bucketDirectory) {
        LOGGER.debug("start removeBlobFolder for " + bucketDirectory);
        if (bucketDirectory.getObjectHandle().getName() == null) {
            throw new StorageConnectionException("not a valid bucket directory " + bucketDirectory);
        }
        GridFSBucket bucket = this.getGridFSBucket(bucketDirectory);
        String directoryname = bucketDirectory.getObjectHandle().getName() + "/";
        String pattern = "^" + directoryname + ".*";
        GridFSFindIterable list = bucket.find(Filters.regex((String)FILENAME_TAG, (String)pattern, (String)"i"));
        list.forEach(file -> bucket.delete(file.getObjectId()));
        LOGGER.debug("finished removeBlobFolder for " + bucketDirectory);
    }

    public void createContainer(BucketDirectory bucketDirectory) {
        LOGGER.debug("createContainer:" + bucketDirectory);
        GridFSBucket bucket = GridFSBuckets.create((MongoDatabase)this.database, (String)bucketDirectory.getObjectHandle().getContainer());
        ByteArrayInputStream is = new ByteArrayInputStream(new Date().toString().getBytes());
        try {
            ObjectId objectId = bucket.uploadFromStream(BUCKET_ID_FILENAME, (InputStream)is);
            LOGGER.debug(" container file has been created .bcd with mongo id " + objectId.toString());
        }
        catch (MongoCommandException e) {
            if (e.getErrorMessage().contains("Too many open files")) {
                LOGGER.error("****************************************************");
                LOGGER.error("Due to the following \"Too many open files exception\"");
                LOGGER.error("PLEASE READ https://jira.adorsys.de/browse/DOC-22");
                LOGGER.error("****************************************************");
            }
            throw new BaseException("exception creating container for " + bucketDirectory, (Throwable)e);
        }
        IOUtils.closeQuietly((InputStream)is);
    }

    public boolean containerExists(BucketDirectory bucketDirectory) {
        GridFSBucket bucket = GridFSBuckets.create((MongoDatabase)this.database, (String)bucketDirectory.getObjectHandle().getContainer());
        return this.containerExists(bucket);
    }

    public void deleteContainer(BucketDirectory bucketDirectory) {
        BucketPathUtil.checkContainerName((String)bucketDirectory.getObjectHandle().getContainer());
        GridFSBuckets.create((MongoDatabase)this.database, (String)bucketDirectory.getObjectHandle().getContainer()).drop();
    }

    public List<StorageMetadata> list(BucketDirectory bucketDirectory, ListRecursiveFlag listRecursiveFlag) {
        LOGGER.debug("start list for " + bucketDirectory);
        GridFSBucket bucket = this.getGridFSBucket(bucketDirectory);
        ArrayList<StorageMetadata> list = new ArrayList<StorageMetadata>();
        if (!this.containerExists(bucket)) {
            LOGGER.debug("container " + bucket.getBucketName() + " existiert nicht, daher leere Liste");
            return list;
        }
        if (bucketDirectory.getObjectHandle().getName() != null && bucket.find(Filters.eq((String)FILENAME_TAG, (Object)bucketDirectory.getObjectHandle().getName())).iterator().hasNext()) {
            return list;
        }
        String directoryname = bucketDirectory.getObjectHandle().getName() != null ? bucketDirectory.getObjectHandle().getName() + "/" : "";
        ArrayList bucketPaths = new ArrayList();
        HashSet<BucketDirectory> dirs = new HashSet<BucketDirectory>();
        if (listRecursiveFlag.equals((Object)ListRecursiveFlag.TRUE)) {
            String pattern = "^" + directoryname + ".*";
            GridFSFindIterable gridFSFiles = bucket.find(Filters.regex((String)FILENAME_TAG, (String)pattern, (String)"i"));
            gridFSFiles.forEach(file -> bucketPaths.add(new BucketPath(bucketDirectory.getObjectHandle().getContainer(), file.getFilename())));
            dirs.addAll(StoreConnectionListHelper.findAllSubDirs((BucketDirectory)bucketDirectory, bucketPaths));
        } else {
            String pattern = "^" + directoryname + "[^/]*$";
            GridFSFindIterable gridFSFiles = bucket.find(Filters.regex((String)FILENAME_TAG, (String)pattern, (String)"i"));
            gridFSFiles.forEach(file -> bucketPaths.add(new BucketPath(bucketDirectory.getObjectHandle().getContainer(), file.getFilename())));
            dirs.addAll(this.findSubdirs(bucket, bucketDirectory));
        }
        bucketPaths.forEach(bucketPath -> {
            if (!bucketPath.getObjectHandle().getName().equals(BUCKET_ID_FILENAME)) {
                list.add(this.getStorageMetadata((BucketPath)bucketPath));
            }
        });
        dirs.add(bucketDirectory);
        dirs.forEach(dir -> {
            SimpleStorageMetadataImpl storageMetadata = new SimpleStorageMetadataImpl();
            storageMetadata.setType(StorageType.FOLDER);
            storageMetadata.setName(BucketPathUtil.getAsString((BucketDirectory)dir));
            list.add((StorageMetadata)storageMetadata);
        });
        LOGGER.debug("list(" + bucketDirectory + ")");
        list.forEach(c -> LOGGER.debug(" > " + c.getName() + " " + c.getType()));
        return list;
    }

    public List<BucketDirectory> listAllBuckets() {
        ArrayList<BucketDirectory> list = new ArrayList<BucketDirectory>();
        this.databaseDeprecated.getCollectionNames().forEach(el -> {
            if (el.endsWith(".files")) {
                String collectionName = el.substring(0, el.length() - ".files".length());
                list.add(new BucketDirectory(collectionName));
            }
        });
        return list;
    }

    public ExtendedStoreConnectionType getType() {
        return ExtendedStoreConnectionType.MONGO;
    }

    private GridFSBucket getGridFSBucket(BucketPath bucketPath) {
        return GridFSBuckets.create((MongoDatabase)this.database, (String)bucketPath.getObjectHandle().getContainer());
    }

    private GridFSBucket getGridFSBucket(BucketDirectory bucketDirectory) {
        return GridFSBuckets.create((MongoDatabase)this.database, (String)bucketDirectory.getObjectHandle().getContainer());
    }

    private void deleteAllExcept(GridFSBucket bucket, String filename, ObjectId objectID) {
        ArrayList idsToDelete = new ArrayList();
        bucket.find(Filters.eq((String)FILENAME_TAG, (Object)filename)).forEach(file -> idsToDelete.add(file.getObjectId()));
        LOGGER.debug("****  number of files to delete:" + idsToDelete.size());
        idsToDelete.forEach(id -> {
            if (!id.equals((Object)objectID)) {
                LOGGER.debug("****  delete:" + id);
                bucket.delete(id);
            }
        });
    }

    private Set<BucketDirectory> findSubdirs(GridFSBucket bucket, BucketDirectory bucketDirectory) {
        String prefix = bucketDirectory.getObjectHandle().getName() != null ? bucketDirectory.getObjectHandle().getName() + "/" : "";
        ArrayList allFiles = new ArrayList();
        String pattern = "^" + prefix + ".*";
        GridFSFindIterable gridFSFiles = bucket.find(Filters.regex((String)FILENAME_TAG, (String)pattern, (String)"i"));
        gridFSFiles.forEach(file -> allFiles.add(file.getFilename()));
        HashSet<BucketDirectory> dirsOnly = new HashSet<BucketDirectory>();
        allFiles.forEach(filename -> {
            String remainder;
            int pos;
            if (filename.length() >= prefix.length() && (pos = (remainder = filename.substring(prefix.length())).indexOf("/")) != -1) {
                String dirname = remainder.substring(0, pos);
                dirsOnly.add(bucketDirectory.appendDirectory(dirname));
            }
        });
        return dirsOnly;
    }

    private boolean containerExists(GridFSBucket bucket) {
        return bucket.find(Filters.eq((String)FILENAME_TAG, (Object)BUCKET_ID_FILENAME)).iterator().hasNext();
    }

    private void checkBucketExists(GridFSBucket bucket) {
        if (!this.containerExists(bucket)) {
            throw new ResourceNotFoundException("Container " + bucket.getBucketName() + " does not exist yet");
        }
    }
}

