/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.dfs.connection.impl.mongodb;

import de.adorsys.dfs.connection.api.exceptions.ParamParserException;
import de.adorsys.dfs.connection.api.types.connection.MongoURI;
import de.adorsys.dfs.connection.api.types.properties.MongoConnectionProperties;
import de.adorsys.dfs.connection.impl.mongodb.MongoConnectionPropertiesImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoParamParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoParamParser.class);
    private static final String DELIMITER = ",";
    public static final String EXPECTED_PARAMS = "<mongoClientUri> (mongodb://[username:password@]host1[:port1][,host2[:port2],...[,hostN[:portN]]][/[database.collection][?options]]) - see http://mongodb.github.io/mongo-java-driver/3.6/javadoc/com/mongodb/MongoClientURI.html";

    public static MongoConnectionProperties getProperties(String params) {
        LOGGER.debug("parse:" + params);
        try {
            MongoConnectionPropertiesImpl props = new MongoConnectionPropertiesImpl();
            if (params.length() > 0) {
                props.setMongoURI(new MongoURI(params));
            }
            return props;
        }
        catch (Exception e) {
            throw new ParamParserException(params, DELIMITER, EXPECTED_PARAMS);
        }
    }
}

