/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.dfs.connection.api.filesystem;

import de.adorsys.common.exceptions.BaseException;
import de.adorsys.common.exceptions.BaseExceptionHandler;
import de.adorsys.common.utils.Frame;
import de.adorsys.dfs.connection.api.complextypes.BucketDirectory;
import de.adorsys.dfs.connection.api.complextypes.BucketPath;
import de.adorsys.dfs.connection.api.domain.Payload;
import de.adorsys.dfs.connection.api.domain.PayloadStream;
import de.adorsys.dfs.connection.api.filesystem.BucketPathFileHelper;
import de.adorsys.dfs.connection.api.filesystem.FileHelper;
import de.adorsys.dfs.connection.api.filesystem.FilesystemConnectionPropertiesImpl;
import de.adorsys.dfs.connection.api.filesystem.exceptions.DeleteFileException;
import de.adorsys.dfs.connection.api.filesystem.exceptions.FileIsFolderException;
import de.adorsys.dfs.connection.api.service.api.DFSConnection;
import de.adorsys.dfs.connection.api.service.impl.SimplePayloadImpl;
import de.adorsys.dfs.connection.api.service.impl.SimplePayloadStreamImpl;
import de.adorsys.dfs.connection.api.types.ListRecursiveFlag;
import de.adorsys.dfs.connection.api.types.connection.FilesystemRootBucketName;
import de.adorsys.dfs.connection.api.types.properties.ConnectionProperties;
import de.adorsys.dfs.connection.api.types.properties.FilesystemConnectionProperties;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemDFSConnection
implements DFSConnection {
    private FilesystemConnectionPropertiesImpl connectionProperties;
    private static final Logger LOGGER = LoggerFactory.getLogger(FileSystemDFSConnection.class);
    protected final BucketDirectory baseDir;
    private FileHelper fileHelper;
    private boolean absolutePath = false;

    public FileSystemDFSConnection(FilesystemConnectionProperties properties) {
        this(properties.getFilesystemRootBucketName());
    }

    public FileSystemDFSConnection(FilesystemRootBucketName basedir) {
        try {
            this.connectionProperties = new FilesystemConnectionPropertiesImpl();
            this.connectionProperties.setFilesystemRootBucketName(basedir);
            this.baseDir = new BucketDirectory(basedir.getValue());
            this.absolutePath = basedir.getValue().startsWith("/");
            Frame frame = new Frame();
            frame.add("USE FILE SYSTEM");
            if (!this.absolutePath) {
                String currentDir = new File(".").getCanonicalPath();
                String absoluteDirectory = basedir.getValue();
                absoluteDirectory = currentDir + "/" + absoluteDirectory;
                frame.add("basedir     : " + basedir);
                frame.add("absolutedir : " + absoluteDirectory);
            } else {
                frame.add("absolutedir : " + basedir);
            }
            LOGGER.debug(frame.toString());
            this.fileHelper = new FileHelper(this.baseDir, this.absolutePath);
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    public boolean blobExists(BucketPath bucketPath) {
        LOGGER.debug("blobExists " + bucketPath);
        File file = BucketPathFileHelper.getAsFile(this.baseDir.append(bucketPath), this.absolutePath);
        if (file.isDirectory()) {
            throw new FileIsFolderException("file " + file);
        }
        if (file.isFile()) {
            LOGGER.debug("file does exist " + file);
            return true;
        }
        LOGGER.debug("file does not exist " + file);
        return false;
    }

    public List<BucketPath> list(BucketDirectory bucketDirectory, ListRecursiveFlag listRecursiveFlag) {
        LOGGER.debug("list " + bucketDirectory);
        ArrayList<BucketPath> result = new ArrayList<BucketPath>();
        File base = BucketPathFileHelper.getAsFile(this.baseDir.append(bucketDirectory), this.absolutePath);
        if (!base.isDirectory()) {
            return result;
        }
        Collection files = FileUtils.listFiles((File)base, null, (boolean)listRecursiveFlag.equals((Object)ListRecursiveFlag.TRUE));
        int lengthToSkip = BucketPathFileHelper.getAsFile(this.baseDir, this.absolutePath).getPath().length();
        for (File file : files) {
            String filenameWithExtension = file.getPath().substring(lengthToSkip);
            result.add(new BucketPath(filenameWithExtension));
        }
        return result;
    }

    public void deleteDatabase() {
        this.removeBlobFolder(new BucketDirectory("/"));
    }

    public ConnectionProperties getConnectionProperties() {
        return this.connectionProperties;
    }

    public void putBlob(BucketPath bucketPath, Payload payload) {
        LOGGER.debug("putBlob " + bucketPath);
        this.fileHelper.writePayload(bucketPath, new SimplePayloadImpl(payload));
    }

    public Payload getBlob(BucketPath bucketPath) {
        LOGGER.debug("getBlob " + bucketPath);
        return this.fileHelper.readPayload(bucketPath);
    }

    public void putBlobStream(BucketPath bucketPath, PayloadStream payloadStream) {
        LOGGER.debug("putBlobStream " + bucketPath);
        this.fileHelper.writePayloadStream(bucketPath, new SimplePayloadStreamImpl(payloadStream));
    }

    public PayloadStream getBlobStream(BucketPath bucketPath) {
        LOGGER.debug("getBlobStrea " + bucketPath);
        return this.fileHelper.readPayloadStream(bucketPath);
    }

    public void removeBlob(BucketPath bucketPath) {
        LOGGER.debug("removeBlob " + bucketPath);
        File file = BucketPathFileHelper.getAsFile(this.baseDir.append(bucketPath), this.absolutePath);
        if (!file.exists()) {
            return;
        }
        try {
            FileUtils.forceDelete((File)file);
        }
        catch (IOException e) {
            throw new DeleteFileException("can not delete " + file, e);
        }
    }

    public void removeBlobFolder(BucketDirectory bucketDirectory) {
        LOGGER.debug("removeBlobFolder " + bucketDirectory);
        File directory = BucketPathFileHelper.getAsFile(this.baseDir.append(bucketDirectory), this.absolutePath);
        LOGGER.debug("remove directory " + directory.getAbsolutePath());
        if (directory.getAbsolutePath().length() < 3) {
            throw new BaseException("just to make sure, root will never every be to be deleted");
        }
        if (!directory.exists()) {
            return;
        }
        try {
            FileUtils.forceDelete((File)directory);
        }
        catch (IOException e) {
            throw new DeleteFileException("can not delete " + directory, e);
        }
    }

    private static final class DirectoryFilenameFilter
    implements FilenameFilter {
        private DirectoryFilenameFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            try {
                return new File(dir.getCanonicalPath() + "/" + name).isDirectory();
            }
            catch (IOException e) {
                throw BaseExceptionHandler.handle((Throwable)e);
            }
        }
    }
}

