/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.dfs.connection.api.filesystem;

import de.adorsys.common.exceptions.BaseExceptionHandler;
import de.adorsys.dfs.connection.api.complextypes.BucketDirectory;
import de.adorsys.dfs.connection.api.complextypes.BucketPath;
import de.adorsys.dfs.connection.api.domain.Payload;
import de.adorsys.dfs.connection.api.domain.PayloadStream;
import de.adorsys.dfs.connection.api.exceptions.StorageConnectionException;
import de.adorsys.dfs.connection.api.filesystem.BucketPathFileHelper;
import de.adorsys.dfs.connection.api.service.impl.SimplePayloadImpl;
import de.adorsys.dfs.connection.api.service.impl.SimplePayloadStreamImpl;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FileHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileHelper.class);
    private boolean absolutePath = false;
    protected BucketDirectory baseDir;

    public FileHelper(BucketDirectory bucketDirectory, boolean absolutePath) {
        this.baseDir = bucketDirectory;
        this.absolutePath = absolutePath;
    }

    public void writePayload(BucketPath bucketPath, SimplePayloadImpl payload) {
        try {
            byte[] content = payload.getData();
            this.createDirectoryIfNecessary(bucketPath);
            File tempFile = BucketPathFileHelper.getAsFile(this.baseDir.append(bucketPath.add("." + UUID.randomUUID().toString())), this.absolutePath);
            if (tempFile.exists()) {
                throw new StorageConnectionException("Temporary File exists. This must not happen." + tempFile);
            }
            LOGGER.debug("write temporary file to " + tempFile);
            try (BufferedOutputStream zos = new BufferedOutputStream(new FileOutputStream(tempFile));){
                ((OutputStream)zos).write(content, 0, content.length);
                ((OutputStream)zos).close();
            }
            File origFile = BucketPathFileHelper.getAsFile(this.baseDir.append(bucketPath), this.absolutePath);
            Files.move(tempFile.toPath(), origFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    public void writePayloadStream(BucketPath bucketPath, SimplePayloadStreamImpl payloadStream) {
        try {
            this.createDirectoryIfNecessary(bucketPath);
            File tempFile = BucketPathFileHelper.getAsFile(this.baseDir.append(bucketPath.add("." + UUID.randomUUID().toString())), this.absolutePath);
            if (tempFile.exists()) {
                throw new StorageConnectionException("Temporary File exists. This must not happen." + tempFile);
            }
            LOGGER.debug("write temporary file to " + tempFile);
            try (BufferedOutputStream zos = new BufferedOutputStream(new FileOutputStream(tempFile));
                 InputStream is = payloadStream.openStream();){
                IOUtils.copy((InputStream)is, (OutputStream)zos);
            }
            File origFile = BucketPathFileHelper.getAsFile(this.baseDir.append(bucketPath), this.absolutePath);
            if (origFile.exists()) {
                LOGGER.debug("ACHTUNG, file existiert bereits, wird nun neu verlinkt " + bucketPath);
                FileUtils.forceDelete((File)origFile);
            }
            FileUtils.moveFile((File)tempFile, (File)origFile);
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Payload readPayload(BucketPath bucketPath) {
        try {
            File file = BucketPathFileHelper.getAsFile(this.baseDir.append(bucketPath), this.absolutePath);
            try (BufferedInputStream zis = new BufferedInputStream(new FileInputStream(file));){
                SimplePayloadImpl payload;
                byte[] data = IOUtils.toByteArray((InputStream)zis);
                ((InputStream)zis).close();
                SimplePayloadImpl simplePayloadImpl = payload = new SimplePayloadImpl(data);
                return simplePayloadImpl;
            }
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    public PayloadStream readPayloadStream(BucketPath bucketPath) {
        try {
            File file = BucketPathFileHelper.getAsFile(this.baseDir.append(bucketPath), this.absolutePath);
            BufferedInputStream zis = new BufferedInputStream(new FileInputStream(file));
            return new SimplePayloadStreamImpl((InputStream)zis);
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    private void createDirectoryIfNecessary(BucketPath bucketPath) {
        File dir = BucketPathFileHelper.getAsFile(this.baseDir.append(bucketPath).getBucketDirectory(), this.absolutePath);
        if (dir.exists()) {
            return;
        }
        boolean success = dir.mkdirs();
        if (!success) {
            throw new StorageConnectionException("cant create directory " + dir);
        }
    }
}

