/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.dfs.connection.api.filesystem;

import de.adorsys.common.exceptions.BaseException;
import de.adorsys.common.exceptions.BaseExceptionHandler;
import de.adorsys.common.utils.Frame;
import de.adorsys.dfs.connection.api.complextypes.BucketDirectory;
import de.adorsys.dfs.connection.api.complextypes.BucketPath;
import de.adorsys.dfs.connection.api.domain.Payload;
import de.adorsys.dfs.connection.api.domain.PayloadStream;
import de.adorsys.dfs.connection.api.exceptions.StorageConnectionException;
import de.adorsys.dfs.connection.api.filesystem.BucketPathFileHelper;
import de.adorsys.dfs.connection.api.filesystem.FileHelper;
import de.adorsys.dfs.connection.api.filesystem.exceptions.CreateFolderException;
import de.adorsys.dfs.connection.api.filesystem.exceptions.DeleteFileException;
import de.adorsys.dfs.connection.api.filesystem.exceptions.FileIsFolderException;
import de.adorsys.dfs.connection.api.filesystem.exceptions.FolderDeleteException;
import de.adorsys.dfs.connection.api.filesystem.exceptions.FolderIsAFileException;
import de.adorsys.dfs.connection.api.service.api.DFSConnection;
import de.adorsys.dfs.connection.api.service.impl.SimplePayloadImpl;
import de.adorsys.dfs.connection.api.service.impl.SimplePayloadStreamImpl;
import de.adorsys.dfs.connection.api.types.ExtendedStoreConnectionType;
import de.adorsys.dfs.connection.api.types.ListRecursiveFlag;
import de.adorsys.dfs.connection.api.types.connection.FilesystemRootBucketName;
import de.adorsys.dfs.connection.api.types.properties.FilesystemConnectionProperties;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemDFSConnection
implements DFSConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileSystemDFSConnection.class);
    protected final BucketDirectory baseDir;
    private FileHelper fileHelper;
    private boolean absolutePath = false;

    public FileSystemDFSConnection(FilesystemConnectionProperties properties) {
        this(properties.getFilesystemRootBucketName());
    }

    public FileSystemDFSConnection(FilesystemRootBucketName basedir) {
        try {
            this.baseDir = new BucketDirectory(basedir.getValue());
            this.absolutePath = basedir.getValue().startsWith("/");
            Frame frame = new Frame();
            frame.add("USE FILE SYSTEM");
            if (!this.absolutePath) {
                String currentDir = new File(".").getCanonicalPath();
                String absoluteDirectory = basedir.getValue();
                absoluteDirectory = currentDir + "/" + absoluteDirectory;
                frame.add("basedir     : " + basedir);
                frame.add("absolutedir : " + absoluteDirectory);
            } else {
                frame.add("absolutedir : " + basedir);
            }
            LOGGER.info(frame.toString());
            this.fileHelper = new FileHelper(this.baseDir, this.absolutePath);
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    public void createContainer(BucketDirectory bucketDirectory) {
        LOGGER.debug("createContainer " + bucketDirectory);
        String containerOnly = bucketDirectory.getObjectHandle().getContainer();
        File file = BucketPathFileHelper.getAsFile(this.baseDir.appendDirectory(containerOnly), this.absolutePath);
        if (file.isDirectory()) {
            LOGGER.debug("directory already exists:" + file);
            return;
        }
        boolean success = file.mkdirs();
        if (!success) {
            throw new CreateFolderException("Can not create directory " + file);
        }
        LOGGER.debug("created folder " + file);
    }

    public boolean containerExists(BucketDirectory bucketDirectory) {
        File file = BucketPathFileHelper.getAsFile(this.baseDir.appendDirectory(bucketDirectory.getObjectHandle().getContainer()), this.absolutePath);
        if (file.isDirectory()) {
            LOGGER.debug("directory exists:" + file);
            return true;
        }
        if (file.isFile()) {
            throw new FolderIsAFileException("folder is a file " + file);
        }
        LOGGER.debug("directory does not exists" + file);
        return false;
    }

    public void deleteContainer(BucketDirectory container) {
        LOGGER.debug("deleteContainer " + container);
        File file = BucketPathFileHelper.getAsFile(this.baseDir.appendDirectory(container.getObjectHandle().getContainer()), this.absolutePath);
        if (!this.containerExists(container)) {
            LOGGER.debug("directory does not exist. so nothing to delete:" + file);
            return;
        }
        try {
            FileUtils.deleteDirectory((File)file);
        }
        catch (IOException e) {
            throw new FolderDeleteException("can not delete " + file, e);
        }
    }

    public boolean blobExists(BucketPath bucketPath) {
        LOGGER.debug("blobExists " + bucketPath);
        File file = BucketPathFileHelper.getAsFile(this.baseDir.append(bucketPath), this.absolutePath);
        if (file.isDirectory()) {
            throw new FileIsFolderException("file " + file);
        }
        if (file.isFile()) {
            LOGGER.debug("file does exist " + file);
            return true;
        }
        LOGGER.debug("file does not exist " + file);
        return false;
    }

    public List<BucketPath> list(BucketDirectory bucketDirectory, ListRecursiveFlag listRecursiveFlag) {
        LOGGER.debug("list " + bucketDirectory);
        ArrayList<BucketPath> result = new ArrayList<BucketPath>();
        File base = BucketPathFileHelper.getAsFile(this.baseDir.append(bucketDirectory), this.absolutePath);
        if (!base.isDirectory()) {
            return result;
        }
        Collection files = FileUtils.listFiles((File)base, null, (boolean)listRecursiveFlag.equals((Object)ListRecursiveFlag.TRUE));
        int lengthToSkip = BucketPathFileHelper.getAsFile(this.baseDir, this.absolutePath).getPath().length();
        for (File file : files) {
            String filenameWithExtension = file.getPath().substring(lengthToSkip);
            result.add(new BucketPath(filenameWithExtension));
        }
        return result;
    }

    public List<BucketDirectory> listAllBuckets() {
        LOGGER.debug("listAllbuckeets");
        try {
            ArrayList<BucketDirectory> list = new ArrayList<BucketDirectory>();
            String[] dirs = BucketPathFileHelper.getAsFile(this.baseDir, this.absolutePath).list(new DirectoryFilenameFilter());
            if (dirs == null) {
                return list;
            }
            Arrays.stream(dirs).forEach(dir -> list.add(new BucketDirectory(dir)));
            return list;
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    public ExtendedStoreConnectionType getType() {
        return ExtendedStoreConnectionType.FILESYSTEM;
    }

    public void putBlob(BucketPath bucketPath, Payload payload) {
        LOGGER.debug("putBlob " + bucketPath);
        this.checkContainerExists(bucketPath);
        this.fileHelper.writePayload(bucketPath, new SimplePayloadImpl(payload));
    }

    public Payload getBlob(BucketPath bucketPath) {
        LOGGER.debug("getBlob " + bucketPath);
        this.checkContainerExists(bucketPath);
        return this.fileHelper.readPayload(bucketPath);
    }

    public void putBlobStream(BucketPath bucketPath, PayloadStream payloadStream) {
        LOGGER.debug("putBlobStream " + bucketPath);
        this.checkContainerExists(bucketPath);
        this.fileHelper.writePayloadStream(bucketPath, new SimplePayloadStreamImpl(payloadStream));
    }

    public PayloadStream getBlobStream(BucketPath bucketPath) {
        LOGGER.debug("getBlobStrea " + bucketPath);
        this.checkContainerExists(bucketPath);
        return this.fileHelper.readPayloadStream(bucketPath);
    }

    public void removeBlob(BucketPath bucketPath) {
        LOGGER.debug("removeBlob " + bucketPath);
        this.checkContainerExists(bucketPath);
        File file = BucketPathFileHelper.getAsFile(this.baseDir.append(bucketPath), this.absolutePath);
        if (!file.exists()) {
            return;
        }
        try {
            FileUtils.forceDelete((File)file);
        }
        catch (IOException e) {
            throw new DeleteFileException("can not delete " + file, e);
        }
    }

    public void removeBlobFolder(BucketDirectory bucketDirectory) {
        LOGGER.debug("removeBlobFolder " + bucketDirectory);
        this.checkContainerExists(bucketDirectory);
        if (bucketDirectory.getObjectHandle().getName() == null) {
            throw new StorageConnectionException("not a valid bucket directory " + bucketDirectory);
        }
        File directory = BucketPathFileHelper.getAsFile(this.baseDir.append(bucketDirectory), this.absolutePath);
        LOGGER.debug("remove directory " + directory.getAbsolutePath());
        if (!directory.exists()) {
            return;
        }
        try {
            FileUtils.forceDelete((File)directory);
        }
        catch (IOException e) {
            throw new DeleteFileException("can not delete " + directory, e);
        }
    }

    private void checkContainerExists(BucketPath bucketPath) {
        if (!this.containerExists(bucketPath.getBucketDirectory())) {
            throw new BaseException("Container " + bucketPath.getObjectHandle().getContainer() + " does not exist");
        }
    }

    private void checkContainerExists(BucketDirectory bucketDirectory) {
        if (!this.containerExists(bucketDirectory)) {
            throw new BaseException("Container " + bucketDirectory.getObjectHandle().getContainer() + " does not exist");
        }
    }

    private static final class DirectoryFilenameFilter
    implements FilenameFilter {
        private DirectoryFilenameFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            try {
                return new File(dir.getCanonicalPath() + "/" + name).isDirectory();
            }
            catch (IOException e) {
                throw BaseExceptionHandler.handle((Throwable)e);
            }
        }
    }
}

