/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.dfs.connection.impl.factory;

import de.adorsys.common.exceptions.BaseExceptionHandler;
import de.adorsys.dfs.connection.api.filesystem.FileSystemParamParser;
import de.adorsys.dfs.connection.api.types.properties.AmazonS3ConnectionProperties;
import de.adorsys.dfs.connection.api.types.properties.ConnectionProperties;
import de.adorsys.dfs.connection.api.types.properties.FilesystemConnectionProperties;
import de.adorsys.dfs.connection.impl.amazons3.AmazonS3ParamParser;
import java.util.ArrayList;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadArguments {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReadArguments.class);
    private static final String SYSTEM_PROPERTY_PREFIX = "-D";
    public static final String AMAZONS3 = "SC-AMAZONS3";
    public static final String FILESYSTEM = "SC-FILESYSTEM";
    public static final String AMAZONS3_ARG = "-DSC-AMAZONS3=";
    public static final String FILESYSTEM_ARG = "-DSC-FILESYSTEM=";

    public ArgsAndProperties readArguments(String[] args) {
        Arrays.stream(args).forEach(arg -> LOGGER.debug("readArguments arg:" + arg));
        ArrayList<String> remainingArgs = new ArrayList<String>();
        FilesystemConnectionProperties properties = null;
        for (String arg2 : args) {
            if (arg2.startsWith(AMAZONS3_ARG)) {
                properties = AmazonS3ParamParser.getProperties((String)arg2.substring(AMAZONS3_ARG.length()));
                continue;
            }
            if (arg2.startsWith(FILESYSTEM_ARG)) {
                properties = FileSystemParamParser.getProperties((String)arg2.substring(FILESYSTEM_ARG.length()));
                continue;
            }
            remainingArgs.add(arg2);
        }
        if (properties == null) {
            properties = FileSystemParamParser.getProperties((String)"");
        }
        String[] remainingArgArray = new String[remainingArgs.size()];
        remainingArgArray = remainingArgs.toArray(remainingArgArray);
        return new ArgsAndProperties((ConnectionProperties)properties, remainingArgArray);
    }

    public ConnectionProperties readEnvironment() {
        try {
            LOGGER.debug("readEnvironment");
            AmazonS3ConnectionProperties properties = null;
            if (System.getProperty(AMAZONS3) != null) {
                properties = AmazonS3ParamParser.getProperties((String)System.getProperty(AMAZONS3));
            }
            if (System.getProperty(FILESYSTEM) != null) {
                properties = FileSystemParamParser.getProperties((String)System.getProperty(FILESYSTEM));
            }
            if (properties == null) {
                properties = FileSystemParamParser.getProperties((String)"");
            }
            return properties;
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    public static class ArgsAndProperties {
        public ConnectionProperties properties;
        public String[] remainingArgs;

        public ArgsAndProperties(ConnectionProperties properties, String[] remainingArgs) {
            this.properties = properties;
            this.remainingArgs = remainingArgs;
        }
    }
}

