/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.dfs.connection.impl.factory;

import de.adorsys.common.exceptions.BaseException;
import de.adorsys.dfs.connection.api.filesystem.FileSystemDFSConnection;
import de.adorsys.dfs.connection.api.service.api.DFSConnection;
import de.adorsys.dfs.connection.api.types.properties.AmazonS3ConnectionProperties;
import de.adorsys.dfs.connection.api.types.properties.ConnectionProperties;
import de.adorsys.dfs.connection.api.types.properties.FilesystemConnectionProperties;
import de.adorsys.dfs.connection.impl.amazons3.AmazonS3DFSConnection;
import de.adorsys.dfs.connection.impl.factory.ReadArguments;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DFSConnectionFactory {
    private static final Logger log = LoggerFactory.getLogger(DFSConnectionFactory.class);
    private final Logger LOGGER = LoggerFactory.getLogger(DFSConnectionFactory.class);
    private ConnectionProperties properties = null;

    public DFSConnectionFactory() {
        log.debug("create new DFSConnectionFactory");
    }

    public static DFSConnection get() {
        return new DFSConnectionFactory().getDFSConnection();
    }

    public static DFSConnection get(ConnectionProperties properties) {
        return new DFSConnectionFactory().getDFSConnection(properties);
    }

    public DFSConnection getDFSConnection(ConnectionProperties properties) {
        log.debug("call getDFSConnection");
        if (properties instanceof AmazonS3ConnectionProperties) {
            return new AmazonS3DFSConnection((AmazonS3ConnectionProperties)properties);
        }
        if (properties instanceof FilesystemConnectionProperties) {
            return new FileSystemDFSConnection((FilesystemConnectionProperties)properties);
        }
        throw new BaseException("Properties of unknown type: " + properties.getClass().getName());
    }

    public DFSConnection getDFSConnection() {
        if (this.properties == null) {
            this.properties = new ReadArguments().readEnvironment();
        }
        return this.getDFSConnection(this.properties);
    }

    public String[] readArguments(String[] args) {
        ReadArguments.ArgsAndProperties argsAndProperties = new ReadArguments().readArguments(args);
        this.properties = argsAndProperties.properties;
        return argsAndProperties.remainingArgs;
    }
}

