/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.dfs.connection.impl.amazons3;

import java.net.URL;
import java.util.StringTokenizer;
import org.adorsys.dfs.connection.api.exceptions.ParamParserException;
import org.adorsys.dfs.connection.api.types.connection.AmazonS3AccessKey;
import org.adorsys.dfs.connection.api.types.connection.AmazonS3Region;
import org.adorsys.dfs.connection.api.types.connection.AmazonS3RootBucketName;
import org.adorsys.dfs.connection.api.types.connection.AmazonS3SecretKey;
import org.adorsys.dfs.connection.api.types.properties.AmazonS3ConnectionProperties;
import org.adorsys.dfs.connection.impl.amazons3.AmazonS3ConnectionProperitesImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmazonS3ParamParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(AmazonS3ParamParser.class);
    private static final String DELIMITER = ",";
    private static final String EXPECTED_PARAMS = "<url>,<accesskey>,<secretkey>[,<region>][,<rootbucket>]";

    public static AmazonS3ConnectionProperties getProperties(String params) {
        LOGGER.debug("parse:" + params);
        try {
            AmazonS3ConnectionProperitesImpl properites = new AmazonS3ConnectionProperitesImpl();
            StringTokenizer st = new StringTokenizer(params, DELIMITER);
            properites.setUrl(new URL(st.nextToken()));
            properites.setAmazonS3AccessKey(new AmazonS3AccessKey(st.nextToken()));
            properites.setAmazonS3SecretKey(new AmazonS3SecretKey(st.nextToken()));
            if (st.hasMoreTokens()) {
                properites.setAmazonS3Region(new AmazonS3Region(st.nextToken()));
            }
            if (st.hasMoreTokens()) {
                properites.setAmazonS3RootBucketName(new AmazonS3RootBucketName(st.nextToken()));
            }
            return properites;
        }
        catch (Exception e) {
            throw new ParamParserException(params, DELIMITER, EXPECTED_PARAMS);
        }
    }
}

