/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.dfs.connection.impl.amazons3;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.Protocol;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.DeleteObjectsRequest;
import com.amazonaws.services.s3.model.DeleteObjectsResult;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import de.adorsys.common.exceptions.BaseException;
import de.adorsys.common.exceptions.BaseExceptionHandler;
import de.adorsys.common.utils.Frame;
import de.adorsys.dfs.connection.api.complextypes.BucketDirectory;
import de.adorsys.dfs.connection.api.complextypes.BucketPath;
import de.adorsys.dfs.connection.api.complextypes.BucketPathUtil;
import de.adorsys.dfs.connection.api.domain.Payload;
import de.adorsys.dfs.connection.api.domain.PayloadStream;
import de.adorsys.dfs.connection.api.exceptions.StorageConnectionException;
import de.adorsys.dfs.connection.api.service.api.DFSConnection;
import de.adorsys.dfs.connection.api.service.impl.SimplePayloadImpl;
import de.adorsys.dfs.connection.api.service.impl.SimplePayloadStreamImpl;
import de.adorsys.dfs.connection.api.types.ExtendedStoreConnectionType;
import de.adorsys.dfs.connection.api.types.ListRecursiveFlag;
import de.adorsys.dfs.connection.api.types.connection.AmazonS3AccessKey;
import de.adorsys.dfs.connection.api.types.connection.AmazonS3Region;
import de.adorsys.dfs.connection.api.types.connection.AmazonS3RootBucketName;
import de.adorsys.dfs.connection.api.types.connection.AmazonS3SecretKey;
import de.adorsys.dfs.connection.api.types.properties.AmazonS3ConnectionProperties;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmazonS3DFSConnection
implements DFSConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(AmazonS3DFSConnection.class);
    private static final Logger SPECIAL_LOGGER = LoggerFactory.getLogger((String)"SPECIAL_LOGGER");
    private AmazonS3 connection = null;
    private static final String AMAZONS3_TMP_FILE_PREFIX = "AMAZONS3_TMP_FILE_";
    private static final String AMAZONS3_TMP_FILE_SUFFIX = "";
    private static final String STORAGE_METADATA_KEY = "StorageMetadata";
    private static final int AMAZON_S3_META_LIMIT = 2048;
    private BucketDirectory amazonS3RootBucket;
    private BucketDirectory amazonS3RootContainersBucket;
    private AmazonS3Region amazonS3Region;

    public AmazonS3DFSConnection(AmazonS3ConnectionProperties properties) {
        this(properties.getUrl(), properties.getAmazonS3AccessKey(), properties.getAmazonS3SecretKey(), properties.getAmazonS3Region(), properties.getAmazonS3RootBucketName());
    }

    public AmazonS3DFSConnection(URL url, final AmazonS3AccessKey accessKey, final AmazonS3SecretKey secretKey, AmazonS3Region anAmazonS3Region, AmazonS3RootBucketName anAmazonS3RootBucketName) {
        this.amazonS3Region = anAmazonS3Region;
        this.amazonS3RootBucket = new BucketDirectory(anAmazonS3RootBucketName.getValue());
        this.amazonS3RootContainersBucket = new BucketDirectory(this.amazonS3RootBucket.getObjectHandle().getContainer() + ".containers");
        Frame frame = new Frame();
        frame.add("USE AMAZON S3 COMPLIANT SYSTEM");
        frame.add("(has be up and running)");
        frame.add("url: " + url.toString());
        frame.add("accessKey:   " + accessKey);
        frame.add("secretKey:   " + secretKey);
        frame.add("region:      " + this.amazonS3Region);
        frame.add("root bucket: " + this.amazonS3RootBucket);
        LOGGER.debug(frame.toString());
        AWSCredentialsProvider credentialsProvider = new AWSCredentialsProvider(){

            public AWSCredentials getCredentials() {
                return new BasicAWSCredentials(accessKey.getValue(), secretKey.getValue());
            }

            public void refresh() {
            }
        };
        AwsClientBuilder.EndpointConfiguration endpoint = new AwsClientBuilder.EndpointConfiguration(url.toString(), this.amazonS3Region.getValue());
        ClientConfiguration clientConfig = new ClientConfiguration();
        clientConfig.setProtocol(Protocol.HTTP);
        clientConfig.disableSocketProxy();
        this.connection = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials(credentialsProvider)).withEndpointConfiguration(endpoint)).withClientConfiguration(clientConfig)).withPayloadSigningEnabled(Boolean.valueOf(false))).enablePathStyleAccess()).build();
        if (!this.connection.doesBucketExistV2(this.amazonS3RootBucket.getObjectHandle().getContainer())) {
            this.connection.createBucket(this.amazonS3RootBucket.getObjectHandle().getContainer());
        }
        if (!this.connection.doesBucketExistV2(this.amazonS3RootContainersBucket.getObjectHandle().getContainer())) {
            this.connection.createBucket(this.amazonS3RootContainersBucket.getObjectHandle().getContainer());
        }
    }

    public void putBlob(BucketPath bucketPath, Payload payload) {
        LOGGER.debug("putBlob " + bucketPath);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(payload.getData());
        SimplePayloadStreamImpl payloadStream = new SimplePayloadStreamImpl((InputStream)inputStream);
        this.putBlobStreamWithMemory(bucketPath, (PayloadStream)payloadStream, payload.getData().length);
    }

    public Payload getBlob(BucketPath bucketPath) {
        try {
            PayloadStream payloadStream = this.getBlobStream(bucketPath);
            byte[] content = IOUtils.toByteArray((InputStream)payloadStream.openStream());
            SimplePayloadImpl payload = new SimplePayloadImpl(content);
            return payload;
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    public void putBlobStream(BucketPath bucketPath, PayloadStream payloadStream) {
        this.putBlobStreamWithTempFile(bucketPath, payloadStream);
    }

    public PayloadStream getBlobStream(BucketPath abucketPath) {
        LOGGER.debug("getBlobStream " + abucketPath);
        BucketPath bucketPath = this.amazonS3RootBucket.append(abucketPath);
        GetObjectRequest getObjectRequest = new GetObjectRequest(bucketPath.getObjectHandle().getContainer(), bucketPath.getObjectHandle().getName());
        S3Object object = this.connection.getObject(getObjectRequest);
        S3ObjectInputStream objectContent = object.getObjectContent();
        SimplePayloadStreamImpl payloadStream = new SimplePayloadStreamImpl((InputStream)objectContent);
        LOGGER.debug("read ok for " + bucketPath);
        return payloadStream;
    }

    public boolean blobExists(BucketPath abucketPath) {
        LOGGER.debug("blobExists " + abucketPath);
        BucketPath bucketPath = this.amazonS3RootBucket.append(abucketPath);
        try {
            this.connection.getObjectMetadata(bucketPath.getObjectHandle().getContainer(), bucketPath.getObjectHandle().getName());
            LOGGER.debug("blob exists " + abucketPath + " TRUE");
            return true;
        }
        catch (AmazonS3Exception e) {
            if (e.getMessage().contains("404 Not Found")) {
                LOGGER.debug("blob exists " + abucketPath + " FALSE");
                return false;
            }
            throw BaseExceptionHandler.handle((Throwable)e);
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    public void removeBlob(BucketPath abucketPath) {
        LOGGER.debug("removeBlob " + abucketPath);
        BucketPath bucketPath = this.amazonS3RootBucket.append(abucketPath);
        this.connection.deleteObject(bucketPath.getObjectHandle().getContainer(), bucketPath.getObjectHandle().getName());
    }

    public void removeBlobFolder(BucketDirectory bucketDirectory) {
        LOGGER.debug("removeBlobFolder " + bucketDirectory);
        if (bucketDirectory.getObjectHandle().getName() == null) {
            throw new StorageConnectionException("not a valid bucket directory " + bucketDirectory);
        }
        this.internalRemoveMultiple(bucketDirectory);
    }

    public boolean containerExists(BucketDirectory bucketDirectory) {
        BucketPath bucketPath = this.amazonS3RootContainersBucket.appendName(bucketDirectory.getObjectHandle().getContainer());
        try {
            this.connection.getObjectMetadata(bucketPath.getObjectHandle().getContainer(), bucketPath.getObjectHandle().getName());
            LOGGER.debug("containerExists " + bucketDirectory + " TRUE");
            return true;
        }
        catch (AmazonS3Exception e) {
            if (e.getMessage().contains("404 Not Found")) {
                LOGGER.debug("containerExists " + bucketDirectory + " FALSE (EXCEPTION)");
                return false;
            }
            throw BaseExceptionHandler.handle((Throwable)e);
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    public void createContainer(BucketDirectory bucketDirectory) {
        LOGGER.debug("createContainer " + bucketDirectory);
        if (!this.containerExists(bucketDirectory)) {
            BucketPath bucketPath = this.amazonS3RootContainersBucket.appendName(bucketDirectory.getObjectHandle().getContainer());
            byte[] content = "x".getBytes();
            LOGGER.debug("write " + bucketPath);
            ObjectMetadata objectMetadata = new ObjectMetadata();
            objectMetadata.setContentLength((long)content.length);
            ByteArrayInputStream bis = new ByteArrayInputStream(content);
            PutObjectRequest putObjectRequest = new PutObjectRequest(bucketPath.getObjectHandle().getContainer(), bucketPath.getObjectHandle().getName(), (InputStream)bis, objectMetadata);
            PutObjectResult putObjectResult = this.connection.putObject(putObjectRequest);
        }
    }

    public void deleteContainer(BucketDirectory bucketDirectory) {
        LOGGER.debug("deleteContainer " + bucketDirectory);
        this.internalRemoveMultiple(new BucketDirectory(bucketDirectory.getObjectHandle().getContainer()));
    }

    public List<BucketPath> list(BucketDirectory abucketDirectory, ListRecursiveFlag listRecursiveFlag) {
        LOGGER.debug("list " + abucketDirectory);
        List<BucketPath> returnList = new ArrayList<BucketPath>();
        if (!this.containerExists(abucketDirectory)) {
            LOGGER.debug("return empty list for " + abucketDirectory);
            return returnList;
        }
        if (this.blobExists(new BucketPath(BucketPathUtil.getAsString((BucketDirectory)abucketDirectory)))) {
            return new ArrayList<BucketPath>();
        }
        BucketDirectory bucketDirectory = this.amazonS3RootBucket.append(abucketDirectory);
        String container = bucketDirectory.getObjectHandle().getContainer();
        String prefix = bucketDirectory.getObjectHandle().getName();
        prefix = prefix == null ? "/" : "/" + prefix;
        LOGGER.debug("search in " + container + " with prefix " + prefix + " " + listRecursiveFlag);
        String searchKey = prefix.substring(1);
        ObjectListing ol = this.connection.listObjects(container, searchKey);
        ArrayList<String> keys = new ArrayList<String>();
        ol.getObjectSummaries().forEach(el -> keys.add("/" + el.getKey()));
        returnList = this.filter(container, prefix, keys, listRecursiveFlag);
        return returnList;
    }

    public List<BucketDirectory> listAllBuckets() {
        LOGGER.debug("listAllBuckets");
        ArrayList<BucketDirectory> buckets = new ArrayList<BucketDirectory>();
        ObjectListing ol = this.connection.listObjects(this.amazonS3RootContainersBucket.getObjectHandle().getContainer());
        ol.getObjectSummaries().forEach(bucket -> buckets.add(new BucketDirectory(bucket.getKey())));
        return buckets;
    }

    public ExtendedStoreConnectionType getType() {
        return ExtendedStoreConnectionType.AMAZONS3;
    }

    public void cleanDatabase() {
        LOGGER.warn("DELETE DATABASE");
        for (BucketDirectory bucketDirectory : this.listAllBuckets()) {
            this.deleteContainer(bucketDirectory);
        }
    }

    public void showDatabase() {
        try {
            ObjectListing ol = this.connection.listObjects(this.amazonS3RootBucket.getObjectHandle().getContainer());
            ArrayList keys = new ArrayList();
            for (S3ObjectSummary key : ol.getObjectSummaries()) {
                LOGGER.debug(key.getKey());
            }
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    List<BucketPath> filter(String container, String prefix, List<String> keys, ListRecursiveFlag recursive) {
        ArrayList<BucketPath> result = new ArrayList<BucketPath>();
        HashSet dirs = new HashSet();
        int numberOfDelimitersOfPrefix = StringUtils.countMatches((CharSequence)prefix, (CharSequence)"/");
        if (prefix.length() > "/".length()) {
            ++numberOfDelimitersOfPrefix;
        }
        int numberOfDelimitersExpected = numberOfDelimitersOfPrefix;
        keys.forEach(key -> {
            int fromIndex;
            if (recursive.equals((Object)ListRecursiveFlag.TRUE)) {
                result.add(new BucketPath(key));
            } else {
                int numberOfDelimitersOfKey = StringUtils.countMatches((CharSequence)key, (CharSequence)"/");
                if (numberOfDelimitersOfKey == numberOfDelimitersExpected) {
                    result.add(new BucketPath(key));
                }
            }
            if (recursive.equals((Object)ListRecursiveFlag.TRUE)) {
                fromIndex = prefix.length();
                while (fromIndex != -1) {
                    if ((fromIndex = key.indexOf("/", fromIndex + 1)) == -1) continue;
                    String dir = key.substring(0, fromIndex);
                    if (dir.length() == 0) {
                        dir = "/";
                    }
                    dirs.add(dir);
                }
            } else {
                fromIndex = prefix.length();
                int counter = 0;
                while (fromIndex != -1 && counter < 1) {
                    if ((fromIndex = key.indexOf("/", fromIndex + 1)) == -1) continue;
                    ++counter;
                    String dir = key.substring(0, fromIndex);
                    if (dir.length() == 0) {
                        dir = "/";
                    }
                    dirs.add(dir);
                }
            }
        });
        this.showResult(result);
        return result;
    }

    private void putBlobStreamWithMemory(BucketPath abucketPath, PayloadStream payloadStream, int size) {
        try {
            LOGGER.debug("putBlobStreamWithMemory " + abucketPath + " with known length " + size);
            ObjectMetadata objectMetadata = new ObjectMetadata();
            objectMetadata.setContentLength((long)size);
            BucketPath bucketPath = this.amazonS3RootBucket.append(abucketPath);
            PutObjectRequest putObjectRequest = new PutObjectRequest(bucketPath.getObjectHandle().getContainer(), bucketPath.getObjectHandle().getName(), payloadStream.openStream(), objectMetadata);
            PutObjectResult putObjectResult = this.connection.putObject(putObjectRequest);
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    private void putBlobStreamWithTempFile(BucketPath abucketPath, PayloadStream payloadStream) {
        try {
            LOGGER.debug("putBlobStreamWithTempFile " + abucketPath + " to tmpfile with unknown size");
            File targetFile = File.createTempFile(AMAZONS3_TMP_FILE_PREFIX, AMAZONS3_TMP_FILE_SUFFIX);
            try (InputStream is = payloadStream.openStream();){
                Files.copy(is, targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            LOGGER.debug(abucketPath + " with tmpfile " + targetFile.getAbsolutePath() + " written with " + targetFile.length() + " bytes -> will now be copied to ceph");
            var5_6 = null;
            try (FileInputStream fis = new FileInputStream(targetFile);){
                ObjectMetadata objectMetadata = new ObjectMetadata();
                objectMetadata.setContentLength(targetFile.length());
                BucketPath bucketPath = this.amazonS3RootBucket.append(abucketPath);
                PutObjectRequest putObjectRequest = new PutObjectRequest(bucketPath.getObjectHandle().getContainer(), bucketPath.getObjectHandle().getName(), (InputStream)fis, objectMetadata);
                PutObjectResult putObjectResult = this.connection.putObject(putObjectRequest);
                LOGGER.debug("stored " + bucketPath + " to ceph with size " + targetFile.length());
            }
            catch (Throwable throwable) {
                var5_6 = throwable;
                throw throwable;
            }
            targetFile.delete();
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    private void internalRemoveMultiple(BucketDirectory abucketDirectory) {
        LOGGER.debug("internalRemoveMultiple " + abucketDirectory);
        if (!this.containerExists(abucketDirectory)) {
            return;
        }
        BucketDirectory bucketDirectory = this.amazonS3RootBucket.append(abucketDirectory);
        String container = bucketDirectory.getObjectHandle().getContainer();
        String prefix = bucketDirectory.getObjectHandle().getName();
        if (prefix == null) {
            prefix = AMAZONS3_TMP_FILE_SUFFIX;
        }
        LOGGER.debug("listObjects(" + container + "," + prefix + ")");
        ObjectListing ol = this.connection.listObjects(container, prefix);
        if (ol.getObjectSummaries().isEmpty()) {
            LOGGER.debug("no files found in " + container + " with prefix " + prefix);
        }
        ArrayList<DeleteObjectsRequest.KeyVersion> keys = new ArrayList<DeleteObjectsRequest.KeyVersion>();
        for (S3ObjectSummary key : ol.getObjectSummaries()) {
            keys.add(new DeleteObjectsRequest.KeyVersion(key.getKey()));
            if (keys.size() != 100) continue;
            DeleteObjectsRequest deleteObjectsRequest = new DeleteObjectsRequest(container);
            deleteObjectsRequest.setKeys(keys);
            LOGGER.debug("DELETE CHUNK CONTENTS OF BUCKET " + container + " with " + keys.size() + " elements");
            DeleteObjectsResult deleteObjectsResult = this.connection.deleteObjects(deleteObjectsRequest);
            LOGGER.debug("SERVER CONFIRMED DELETION OF " + deleteObjectsResult.getDeletedObjects().size() + " elements");
            ObjectListing ol2 = this.connection.listObjects(container);
            LOGGER.debug("SERVER has remaining " + ol2.getObjectSummaries().size() + " elements");
            if (ol2.getObjectSummaries().size() != ol.getObjectSummaries().size()) continue;
            throw new BaseException("Fatal error. Server confirmied deleltion of " + keys.size() + " elements, but still " + ol.getObjectSummaries().size() + " elementents in " + container);
        }
        if (!keys.isEmpty()) {
            DeleteObjectsRequest deleteObjectsRequest = new DeleteObjectsRequest(container);
            deleteObjectsRequest.setKeys(keys);
            LOGGER.debug("DELETE CONTENTS OF BUCKET " + container + " with " + keys.size() + " elements");
            DeleteObjectsResult deleteObjectsResult = this.connection.deleteObjects(deleteObjectsRequest);
            LOGGER.debug("SERVER CONFIRMED DELETION OF " + deleteObjectsResult.getDeletedObjects().size() + " elements");
        }
        if (abucketDirectory.getObjectHandle().getName() == null) {
            BucketPath containerFile = this.amazonS3RootContainersBucket.appendName(abucketDirectory.getObjectHandle().getContainer());
            this.connection.deleteObject(containerFile.getObjectHandle().getContainer(), containerFile.getObjectHandle().getName());
        }
    }

    private void showResult(List<BucketPath> result) {
        LOGGER.debug("nachher:");
        result.forEach(el -> LOGGER.debug(el.toString()));
    }

    private void showKeys(List<String> keys) {
        LOGGER.debug("vorher");
        keys.forEach(el -> LOGGER.debug(el));
    }
}

