/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.dfs.connection.api.complextypes;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BucketPathUtil {
    private static final String WINDOWS_BUCKET_PATH_SEPARATOR = "\\\\";
    private static final Logger LOGGER = LoggerFactory.getLogger(BucketPathUtil.class);

    public static List<String> split(String fullBucketPath) {
        ArrayList<String> list = new ArrayList<String>();
        if (fullBucketPath == null) {
            return list;
        }
        fullBucketPath = fullBucketPath.replaceAll(WINDOWS_BUCKET_PATH_SEPARATOR, "/");
        StringTokenizer st = new StringTokenizer(fullBucketPath, "/");
        while (st.hasMoreElements()) {
            String token = st.nextToken();
            if (!BucketPathUtil.notOnlyWhitespace(token)) continue;
            list.add(token);
        }
        return list;
    }

    private static boolean notOnlyWhitespace(String value) {
        return value.replaceAll(" ", "").length() > 0;
    }
}

