/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.dfs.connection.api.complextypes;

import de.adorsys.common.exceptions.BaseException;
import de.adorsys.dfs.connection.api.complextypes.BucketDirectory;
import de.adorsys.dfs.connection.api.complextypes.BucketPathUtil;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BucketPath {
    public static final String BUCKET_SEPARATOR = "/";
    private static final Logger LOGGER = LoggerFactory.getLogger(BucketPath.class);
    String name = null;

    public BucketPath(String path) {
        List<String> split = BucketPathUtil.split(path);
        if (!split.isEmpty()) {
            if (!split.isEmpty()) {
                this.name = split.stream().map(b -> b).collect(Collectors.joining(BUCKET_SEPARATOR));
            }
        } else {
            throw new BaseException("BucketPatb must not be empty:" + path);
        }
    }

    public BucketPath(BucketPath bucketPath) {
        this.name = bucketPath.name;
    }

    public BucketPath append(BucketPath bucketPath) {
        return new BucketPath(this.name + BUCKET_SEPARATOR + bucketPath.name);
    }

    public BucketPath append(String path) {
        return this.append(new BucketPath(path));
    }

    public BucketPath add(String suffix) {
        return new BucketPath(this.name + suffix);
    }

    public String getValue() {
        return this.name;
    }

    public String getContainer() {
        return BucketPathUtil.split(this.name).get(0);
    }

    public String getName() {
        List<String> split = BucketPathUtil.split(this.name);
        split.remove(0);
        if (!split.isEmpty() && !split.isEmpty()) {
            return split.stream().map(b -> b).collect(Collectors.joining(BUCKET_SEPARATOR));
        }
        return "";
    }

    public String toString() {
        return "BucketPath{" + this.name + '}';
    }

    public BucketDirectory getBucketDirectory() {
        int index = this.name.lastIndexOf(BUCKET_SEPARATOR);
        if (index == -1) {
            return new BucketDirectory(BUCKET_SEPARATOR);
        }
        return new BucketDirectory(this.name.substring(0, index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BucketPath that = (BucketPath)o;
        return Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }
}

