/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.dfs.connection.api.complextypes;

import de.adorsys.common.exceptions.BaseException;
import de.adorsys.dfs.connection.api.complextypes.BucketPath;
import de.adorsys.dfs.connection.api.complextypes.BucketPathUtil;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class BucketDirectory {
    private String name = null;

    public BucketDirectory(String path) {
        List<String> split = BucketPathUtil.split(path);
        if (!split.isEmpty()) {
            if (!split.isEmpty()) {
                this.name = split.stream().map(b -> b).collect(Collectors.joining("/"));
            }
        } else {
            this.name = "/";
        }
    }

    public BucketDirectory(BucketPath bucketPath) {
        this.name = bucketPath.name;
    }

    public BucketDirectory append(BucketDirectory directory) {
        return new BucketDirectory(this.name + "/" + directory.name);
    }

    public BucketPath append(BucketPath bucketPath) {
        return new BucketPath(this.name + "/" + bucketPath.name);
    }

    public BucketDirectory appendDirectory(String directory) {
        return new BucketDirectory(this.name + "/" + directory);
    }

    public BucketPath appendName(String name) {
        return this.append(new BucketPath(name));
    }

    public String getValue() {
        return this.name;
    }

    public String getContainer() {
        if (this.isRoot()) {
            throw new BaseException("container can not be " + this.name);
        }
        return BucketPathUtil.split(this.name).get(0);
    }

    public boolean isRoot() {
        return this.name.equals("/");
    }

    public String getName() {
        List<String> split = BucketPathUtil.split(this.name);
        split.remove(0);
        if (!split.isEmpty() && !split.isEmpty()) {
            return split.stream().map(b -> b).collect(Collectors.joining("/"));
        }
        return "";
    }

    public String toString() {
        return "BucketDirectory{" + this.name + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BucketDirectory that = (BucketDirectory)o;
        return Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }
}

