/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.teststorage;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.Protocol;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.BucketVersioningConfiguration;
import com.amazonaws.services.s3.model.SetBucketVersioningConfigurationRequest;
import com.amazonaws.util.StringUtils;
import com.google.common.base.Strings;
import com.google.common.base.Suppliers;
import de.adorsys.datasafe.storage.api.StorageService;
import de.adorsys.datasafe.storage.impl.fs.FileSystemStorageService;
import de.adorsys.datasafe.storage.impl.s3.S3StorageService;
import de.adorsys.datasafe.types.api.resource.Uri;
import de.adorsys.datasafe.types.api.shared.BaseMockitoTest;
import de.adorsys.datasafe.types.api.utils.ExecutorServiceUtil;
import java.io.File;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import lombok.Generated;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.io.TempDir;
import org.junit.jupiter.params.provider.ValueSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.shaded.org.apache.commons.io.FileUtils;

public abstract class WithStorageProvider
extends BaseMockitoTest {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WithStorageProvider.class);
    public static final String SKIP_CEPH = "SKIP_CEPH";
    public static final String CEPH_REGION = "US";
    private static String bucketPath = UUID.randomUUID().toString();
    private static final ExecutorService EXECUTOR_SERVICE = "true".equals(WithStorageProvider.readPropOrEnv("USE_EXECUTOR_POOL")) ? ExecutorServiceUtil.submitterExecutesOnStarvationExecutingService() : ExecutorServiceUtil.submitterExecutesOnStarvationExecutingService((int)4, (int)4);
    private static String minioAccessKeyID = "admin";
    private static String minioSecretAccessKey = "password";
    private static String minioRegion = "eu-central-1";
    private static String minioUrl = "http://localhost";
    private static String minioMappedUrl;
    private static String cephAccessKeyID;
    private static String cephSecretAccessKey;
    private static String cephRegion;
    private static String cephUrl;
    private static String cephMappedUrl;
    private static String amazonAccessKeyID;
    private static String amazonSecretAccessKey;
    private static String amazonRegion;
    private static String amazonUrl;
    private static String amazonMappedUrl;
    protected static List<String> buckets;
    protected static String primaryBucket;
    private static GenericContainer minioContainer;
    private static GenericContainer cephContainer;
    private static Path tempDir;
    private static AmazonS3 minio;
    private static AmazonS3 ceph;
    private static AmazonS3 amazonS3;
    private static Supplier<Void> cephStorage;
    private static Supplier<Void> minioStorage;
    private static Supplier<Void> amazonStorage;

    @BeforeAll
    static void init(@TempDir Path tempDir) {
        log.info("Executing init");
        log.info("");
        WithStorageProvider.tempDir = tempDir;
        minioStorage = Suppliers.memoize(() -> {
            WithStorageProvider.startMinio();
            return null;
        });
        cephStorage = Suppliers.memoize(() -> {
            WithStorageProvider.startCeph();
            return null;
        });
        amazonStorage = Suppliers.memoize(() -> {
            WithStorageProvider.initS3();
            return null;
        });
    }

    @AfterEach
    void cleanup() {
        log.info("Executing cleanup");
        if (null != tempDir && tempDir.toFile().exists()) {
            FileUtils.cleanDirectory((File)tempDir.toFile());
        }
        if (null != minio) {
            buckets.forEach(it -> this.removeObjectFromS3(minio, (String)it, bucketPath));
        }
        if (null != ceph) {
            buckets.forEach(it -> this.removeObjectFromS3(ceph, (String)it, bucketPath));
        }
        if (null != amazonS3) {
            buckets.forEach(it -> this.removeObjectFromS3(amazonS3, (String)it, bucketPath));
        }
    }

    @AfterAll
    static void shutdown() {
        log.info("Stopping containers");
        if (null != minioContainer) {
            minioContainer.stop();
            minioContainer = null;
            minio = null;
        }
        if (null != cephContainer) {
            cephContainer.stop();
            cephContainer = null;
            ceph = null;
        }
        amazonS3 = null;
    }

    @ValueSource
    protected static Stream<StorageDescriptor> allLocalDefaultStorages() {
        return Stream.of(WithStorageProvider.fs(), WithStorageProvider.minio()).filter(Objects::nonNull);
    }

    @ValueSource
    protected static Stream<StorageDescriptor> allLocalStorages() {
        return Stream.of(WithStorageProvider.fs(), WithStorageProvider.minio(), WithStorageProvider.cephVersioned()).filter(Objects::nonNull);
    }

    @ValueSource
    protected static Stream<StorageDescriptor> allDefaultStorages() {
        return Stream.of(WithStorageProvider.fs(), WithStorageProvider.minio(), WithStorageProvider.s3()).filter(Objects::nonNull);
    }

    @ValueSource
    protected static Stream<StorageDescriptor> allStorages() {
        return Stream.of(WithStorageProvider.fs(), WithStorageProvider.minio(), WithStorageProvider.cephVersioned(), WithStorageProvider.s3()).filter(Objects::nonNull);
    }

    protected static StorageDescriptor fs() {
        return new StorageDescriptor(StorageDescriptorName.FILESYSTEM, () -> new FileSystemStorageService(new Uri(tempDir.toUri())), new Uri(tempDir.toUri()), null, null, null, tempDir.toString());
    }

    protected static StorageDescriptor minio() {
        return new StorageDescriptor(StorageDescriptorName.MINIO, () -> {
            minioStorage.get();
            return new S3StorageService(minio, primaryBucket, EXECUTOR_SERVICE);
        }, new Uri("s3://" + primaryBucket + "/" + bucketPath + "/"), minioAccessKeyID, minioSecretAccessKey, minioRegion, primaryBucket + "/" + bucketPath);
    }

    protected static StorageDescriptor cephVersioned() {
        if (WithStorageProvider.skipCeph()) {
            return null;
        }
        return new StorageDescriptor(StorageDescriptorName.CEPH, () -> {
            cephStorage.get();
            return new S3StorageService(ceph, primaryBucket, EXECUTOR_SERVICE);
        }, new Uri("s3://" + primaryBucket + "/" + bucketPath + "/"), cephAccessKeyID, cephSecretAccessKey, cephRegion, primaryBucket + "/" + bucketPath);
    }

    private static boolean skipCeph() {
        String value = System.getProperty(SKIP_CEPH);
        if (value == null) {
            return false;
        }
        return !value.equalsIgnoreCase("false");
    }

    protected static Function<String, StorageService> storageServiceByBucket() {
        if (null == amazonS3) {
            return bucketName -> new S3StorageService(minio, bucketName, EXECUTOR_SERVICE);
        }
        return bucketName -> new S3StorageService(amazonS3, bucketName, EXECUTOR_SERVICE);
    }

    protected static StorageDescriptor s3() {
        if (null == amazonAccessKeyID) {
            return null;
        }
        return new StorageDescriptor(StorageDescriptorName.AMAZON, () -> {
            amazonStorage.get();
            return new S3StorageService(amazonS3, primaryBucket, EXECUTOR_SERVICE);
        }, new Uri("s3://" + primaryBucket + "/" + bucketPath + "/"), amazonAccessKeyID, amazonSecretAccessKey, amazonRegion, primaryBucket + "/" + bucketPath);
    }

    private void removeObjectFromS3(AmazonS3 amazonS3, String bucket, String prefix) {
        amazonS3.listObjects(bucket, prefix).getObjectSummaries().forEach(it -> {
            log.debug("Remove {}", (Object)it.getKey());
            amazonS3.deleteObject(bucket, it.getKey());
        });
    }

    private static void initS3() {
        log.info("Initializing S3");
        if (Strings.isNullOrEmpty((String)amazonAccessKeyID)) {
            return;
        }
        AmazonS3ClientBuilder amazonS3ClientBuilder = (AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(amazonAccessKeyID, amazonSecretAccessKey)));
        if (buckets.size() > 1) {
            log.info("Using {} buckets:{}", (Object)buckets.size(), buckets);
        }
        if (StringUtils.isNullOrEmpty((String)amazonUrl)) {
            amazonS3ClientBuilder = (AmazonS3ClientBuilder)amazonS3ClientBuilder.withRegion(amazonRegion);
            amazonMappedUrl = "s3://" + primaryBucket + "/" + bucketPath + "/";
        } else {
            amazonS3ClientBuilder = (AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)amazonS3ClientBuilder.withClientConfiguration(new ClientConfiguration().withProtocol(Protocol.HTTP))).withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(amazonUrl, CEPH_REGION))).enablePathStyleAccess();
            amazonMappedUrl = "http://" + primaryBucket + "." + amazonUrl;
        }
        amazonS3 = (AmazonS3)amazonS3ClientBuilder.build();
        log.info("Amazon mapped URL:" + amazonMappedUrl);
    }

    private static void startMinio() {
        log.info("Starting MINIO");
        minioContainer = new GenericContainer("minio/minio").withExposedPorts(new Integer[]{9000}).withEnv("MINIO_ACCESS_KEY", minioAccessKeyID).withEnv("MINIO_SECRET_KEY", minioSecretAccessKey).withCommand("server /data").waitingFor(Wait.defaultWaitStrategy());
        minioContainer.start();
        Integer mappedPort = minioContainer.getMappedPort(9000);
        minioMappedUrl = minioUrl + ":" + mappedPort;
        log.info("Minio mapped URL:" + minioMappedUrl);
        minio = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(minioMappedUrl, minioRegion))).withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(minioAccessKeyID, minioSecretAccessKey)))).enablePathStyleAccess()).build();
        buckets.forEach(arg_0 -> ((AmazonS3)minio).createBucket(arg_0));
    }

    private static void startCeph() {
        log.info("Starting CEPH");
        cephContainer = new GenericContainer("ceph/daemon").withExposedPorts(new Integer[]{8000}).withEnv("RGW_FRONTEND_PORT", "8000").withEnv("SREE_PORT", "5000").withEnv("DEBUG", "verbose").withEnv("CEPH_DEMO_UID", "nano").withEnv("MON_IP", "127.0.0.1").withEnv("CEPH_PUBLIC_NETWORK", "0.0.0.0/0").withEnv("CEPH_DAEMON", "demo").withEnv("DEMO_DAEMONS", "mon,mgr,osd,rgw").withEnv("CEPH_DEMO_ACCESS_KEY", cephAccessKeyID).withEnv("CEPH_DEMO_SECRET_KEY", cephSecretAccessKey).withCommand("mkdir -p /etc/ceph && mkdir -p /var/lib/ceph && /entrypoint.sh").waitingFor(Wait.defaultWaitStrategy().withStartupTimeout(Duration.ofSeconds(60L)));
        cephContainer.start();
        Integer mappedPort = cephContainer.getMappedPort(8000);
        cephMappedUrl = cephUrl + ":" + mappedPort;
        log.info("Ceph mapped URL:" + cephMappedUrl);
        ceph = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(cephMappedUrl, cephRegion))).withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(cephAccessKeyID, cephSecretAccessKey)))).enablePathStyleAccess()).build();
        ceph.createBucket(buckets.get(0));
        ceph.setBucketVersioningConfiguration(new SetBucketVersioningConfigurationRequest(primaryBucket, new BucketVersioningConfiguration("Enabled")));
    }

    protected static String readPropOrEnv(String name, String defaultValue) {
        String fromEnv = System.getProperty(name, System.getenv(name));
        return null != fromEnv ? fromEnv : defaultValue;
    }

    private static String readPropOrEnv(String name) {
        return WithStorageProvider.readPropOrEnv(name, null);
    }

    static {
        cephAccessKeyID = "admin";
        cephSecretAccessKey = "password";
        cephRegion = "eu-central-1";
        cephUrl = "http://0.0.0.0";
        amazonAccessKeyID = WithStorageProvider.readPropOrEnv("AWS_ACCESS_KEY");
        amazonSecretAccessKey = WithStorageProvider.readPropOrEnv("AWS_SECRET_KEY");
        amazonRegion = WithStorageProvider.readPropOrEnv("AWS_REGION", "eu-central-1");
        amazonUrl = WithStorageProvider.readPropOrEnv("AWS_URL");
        buckets = Arrays.asList(WithStorageProvider.readPropOrEnv("AWS_BUCKET", "adorsys-docusafe").split(","));
        primaryBucket = buckets.get(0);
    }

    public static enum StorageDescriptorName {
        FILESYSTEM,
        MINIO,
        CEPH,
        AMAZON;

    }

    public static class StorageDescriptor {
        private final StorageDescriptorName name;
        private final Supplier<StorageService> storageService;
        private final Uri location;
        private final String accessKey;
        private final String secretKey;
        private final String region;
        private final String rootBucket;

        public String getMappedUrl() {
            switch (this.name) {
                case MINIO: {
                    return minioMappedUrl;
                }
                case CEPH: {
                    return cephMappedUrl;
                }
                case AMAZON: {
                    return amazonMappedUrl;
                }
                case FILESYSTEM: {
                    return null;
                }
            }
            throw new RuntimeException("missing switch for " + (Object)((Object)this.name));
        }

        @Generated
        public StorageDescriptorName getName() {
            return this.name;
        }

        @Generated
        public Supplier<StorageService> getStorageService() {
            return this.storageService;
        }

        @Generated
        public Uri getLocation() {
            return this.location;
        }

        @Generated
        public String getAccessKey() {
            return this.accessKey;
        }

        @Generated
        public String getSecretKey() {
            return this.secretKey;
        }

        @Generated
        public String getRegion() {
            return this.region;
        }

        @Generated
        public String getRootBucket() {
            return this.rootBucket;
        }

        @Generated
        public String toString() {
            return "WithStorageProvider.StorageDescriptor(name=" + (Object)((Object)this.getName()) + ")";
        }

        @Generated
        public StorageDescriptor(StorageDescriptorName name, Supplier<StorageService> storageService, Uri location, String accessKey, String secretKey, String region, String rootBucket) {
            this.name = name;
            this.storageService = storageService;
            this.location = location;
            this.accessKey = accessKey;
            this.secretKey = secretKey;
            this.region = region;
            this.rootBucket = rootBucket;
        }
    }
}

