/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.storage.impl.s3;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.AbortMultipartUploadRequest;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.CompleteMultipartUploadResult;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadResult;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PartETag;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.amazonaws.services.s3.model.UploadPartResult;
import de.adorsys.datasafe.storage.impl.s3.ChunkUploadRequest;
import de.adorsys.datasafe.storage.impl.s3.UploadChunkResultCallable;
import de.adorsys.datasafe.types.api.callback.PhysicalVersionCallback;
import de.adorsys.datasafe.types.api.callback.ResourceWriteCallback;
import de.adorsys.datasafe.types.api.utils.CustomizableByteArrayOutputStream;
import de.adorsys.datasafe.types.api.utils.Obfuscate;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultipartUploadS3StorageOutputStream
extends OutputStream {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MultipartUploadS3StorageOutputStream.class);
    @Generated
    private final Object $lock = new Object[0];
    private String bucketName;
    private String objectName;
    private AmazonS3 amazonS3;
    static final int BUFFER_SIZE = 0x500000;
    private final CompletionService<UploadPartResult> completionService;
    private CustomizableByteArrayOutputStream currentOutputStream = this.newOutputStream();
    private InitiateMultipartUploadResult multiPartUploadResult;
    private int partCounter = 1;
    private final List<? extends ResourceWriteCallback> callbacks;

    MultipartUploadS3StorageOutputStream(String bucketName, String objectKey, AmazonS3 amazonS3, ExecutorService executorService, List<? extends ResourceWriteCallback> callbacks) {
        this.bucketName = bucketName;
        this.objectName = objectKey;
        this.amazonS3 = amazonS3;
        this.completionService = new ExecutorCompletionService<UploadPartResult>(executorService);
        this.callbacks = callbacks;
        log.debug("Write to bucket: {} with name: {}", (Object)Obfuscate.secure((String)bucketName), (Object)Obfuscate.secure((String)this.objectName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] bytes, int off, int len) {
        Object object = this.$lock;
        synchronized (object) {
            int bytesToWrite;
            int remainingSizeToWrite = len;
            int inputPosition = off;
            do {
                int availableCapacity = 0x500000 - this.currentOutputStream.size();
                bytesToWrite = Math.min(availableCapacity, remainingSizeToWrite);
                this.currentOutputStream.write(bytes, inputPosition, bytesToWrite);
                inputPosition += bytesToWrite;
                this.initiateMultipartRequestAndCommitPartIfNeeded();
            } while ((remainingSizeToWrite -= bytesToWrite) > 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int b) {
        Object object = this.$lock;
        synchronized (object) {
            this.currentOutputStream.write(b);
            this.initiateMultipartRequestAndCommitPartIfNeeded();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.$lock;
        synchronized (object) {
            if (this.currentOutputStream == null) {
                return;
            }
            if (this.isMultiPartUpload()) {
                this.finishMultiPartUpload();
            } else {
                this.finishSimpleUpload();
            }
        }
    }

    private void initiateMultipartRequestAndCommitPartIfNeeded() {
        if (this.currentOutputStream.size() != 0x500000) {
            return;
        }
        this.initiateMultiPartIfNeeded();
        byte[] content = this.currentOutputStream.getBufferOrCopy();
        int size = this.currentOutputStream.size();
        this.currentOutputStream = this.newOutputStream();
        this.completionService.submit(new UploadChunkResultCallable(ChunkUploadRequest.builder().amazonS3(this.amazonS3).content(content).contentSize(size).bucketName(this.bucketName).objectName(this.objectName).uploadId(this.multiPartUploadResult.getUploadId()).chunkNumberCounter(this.partCounter).lastChunk(false).build()));
        ++this.partCounter;
    }

    private boolean isMultiPartUpload() {
        return this.multiPartUploadResult != null;
    }

    private void finishSimpleUpload() {
        ObjectMetadata objectMetadata = new ObjectMetadata();
        int size = this.currentOutputStream.size();
        objectMetadata.setContentLength((long)size);
        byte[] content = this.currentOutputStream.getBufferOrCopy();
        this.currentOutputStream = null;
        PutObjectResult upload = this.amazonS3.putObject(this.bucketName, this.objectName, (InputStream)new ByteArrayInputStream(content, 0, size), objectMetadata);
        this.notifyCommittedVersionIfPresent(upload.getVersionId());
        log.debug("Finished simple upload");
    }

    private void finishMultiPartUpload() throws IOException {
        this.sendLastChunkOfMultipartIfNeeded();
        try {
            List<PartETag> partETags = this.getMultiPartsUploadResults();
            log.debug("Send multipart request to S3");
            CompleteMultipartUploadResult upload = this.amazonS3.completeMultipartUpload(new CompleteMultipartUploadRequest(this.multiPartUploadResult.getBucketName(), this.multiPartUploadResult.getKey(), this.multiPartUploadResult.getUploadId(), partETags));
            this.notifyCommittedVersionIfPresent(upload.getVersionId());
            log.debug("Finished multi part upload");
        }
        catch (ExecutionException e) {
            this.abortMultiPartUpload();
            log.error(e.getMessage(), (Throwable)e);
            throw new IOException("Multi part upload failed ", e.getCause());
        }
        catch (InterruptedException e) {
            log.error(e.getMessage(), (Throwable)e);
            this.abortMultiPartUpload();
            Thread.currentThread().interrupt();
        }
        finally {
            this.currentOutputStream = null;
        }
    }

    private void sendLastChunkOfMultipartIfNeeded() {
        if (this.currentOutputStream.size() == 0) {
            --this.partCounter;
            return;
        }
        byte[] content = this.currentOutputStream.getBufferOrCopy();
        int size = this.currentOutputStream.size();
        this.currentOutputStream = null;
        this.completionService.submit(new UploadChunkResultCallable(ChunkUploadRequest.builder().amazonS3(this.amazonS3).content(content).contentSize(size).bucketName(this.bucketName).objectName(this.objectName).uploadId(this.multiPartUploadResult.getUploadId()).chunkNumberCounter(this.partCounter).lastChunk(true).build()));
    }

    private void notifyCommittedVersionIfPresent(String version) {
        if (null == version) {
            return;
        }
        this.callbacks.stream().filter(it -> it instanceof PhysicalVersionCallback).forEach(it -> ((PhysicalVersionCallback)it).handleVersionAssigned(version));
    }

    private void initiateMultiPartIfNeeded() {
        if (this.multiPartUploadResult == null) {
            log.debug("Initiate multi part");
            this.multiPartUploadResult = this.amazonS3.initiateMultipartUpload(new InitiateMultipartUploadRequest(this.bucketName, this.objectName));
        }
    }

    private void abortMultiPartUpload() {
        log.debug("Abort multi part");
        if (this.isMultiPartUpload()) {
            this.amazonS3.abortMultipartUpload(new AbortMultipartUploadRequest(this.multiPartUploadResult.getBucketName(), this.multiPartUploadResult.getKey(), this.multiPartUploadResult.getUploadId()));
        }
    }

    private List<PartETag> getMultiPartsUploadResults() throws ExecutionException, InterruptedException {
        ArrayList<PartETag> result = new ArrayList<PartETag>(this.partCounter);
        for (int i = 0; i < this.partCounter; ++i) {
            UploadPartResult partResult = this.completionService.take().get();
            result.add(partResult.getPartETag());
            log.debug("Get upload part #{} from {}", (Object)i, (Object)this.partCounter);
        }
        return result;
    }

    private CustomizableByteArrayOutputStream newOutputStream() {
        return new CustomizableByteArrayOutputStream(32, 0x500000, 0.5);
    }
}

