/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.storage.impl.s3;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.UploadPartRequest;
import com.amazonaws.services.s3.model.UploadPartResult;
import de.adorsys.datasafe.storage.impl.s3.ChunkUploadRequest;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.concurrent.Callable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploadChunkResultCallable
implements Callable<UploadPartResult> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UploadChunkResultCallable.class);
    private final AmazonS3 amazonS3;
    private final int contentLength;
    private final int partNumber;
    private final boolean last;
    private final String bucketName;
    private final String fileName;
    private final String chunkId;
    private byte[] content;

    UploadChunkResultCallable(ChunkUploadRequest request) {
        this.amazonS3 = request.getAmazonS3();
        this.content = request.getContent();
        this.contentLength = request.getContentSize();
        this.partNumber = request.getChunkNumberCounter();
        this.last = request.isLastChunk();
        this.bucketName = request.getBucketName();
        this.fileName = request.getObjectName();
        this.chunkId = request.getUploadId();
        log.debug("Chunk upload request: {}", (Object)request.toString());
    }

    @Override
    public UploadPartResult call() {
        log.trace("Upload chunk result call with part: {}", (Object)this.partNumber);
        try {
            UploadPartResult uploadPartResult = this.amazonS3.uploadPart(new UploadPartRequest().withBucketName(this.bucketName).withKey(this.fileName).withUploadId(this.chunkId).withInputStream((InputStream)new ByteArrayInputStream(this.content)).withPartNumber(this.partNumber).withLastPart(this.last).withPartSize((long)this.contentLength));
            return uploadPartResult;
        }
        finally {
            this.content = null;
        }
    }
}

