/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.storage.impl.s3;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.iterable.S3Objects;
import com.amazonaws.services.s3.iterable.S3Versions;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import de.adorsys.datasafe.storage.api.StorageService;
import de.adorsys.datasafe.storage.impl.s3.MultipartUploadS3StorageOutputStream;
import de.adorsys.datasafe.types.api.callback.ResourceWriteCallback;
import de.adorsys.datasafe.types.api.resource.AbsoluteLocation;
import de.adorsys.datasafe.types.api.resource.BasePrivateResource;
import de.adorsys.datasafe.types.api.resource.BaseResolvedResource;
import de.adorsys.datasafe.types.api.resource.PrivateResource;
import de.adorsys.datasafe.types.api.resource.ResolvedResource;
import de.adorsys.datasafe.types.api.resource.ResourceLocation;
import de.adorsys.datasafe.types.api.resource.StorageVersion;
import de.adorsys.datasafe.types.api.resource.Uri;
import de.adorsys.datasafe.types.api.resource.VersionedResourceLocation;
import de.adorsys.datasafe.types.api.resource.WithCallback;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3StorageService
implements StorageService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(S3StorageService.class);
    private final AmazonS3 s3;
    private final String bucketName;
    private final ExecutorService executorService;

    @Inject
    public S3StorageService(AmazonS3 s3, String bucketName, ExecutorService executorService) {
        this.s3 = s3;
        this.bucketName = bucketName;
        this.executorService = executorService;
    }

    public Stream<AbsoluteLocation<ResolvedResource>> list(AbsoluteLocation location) {
        log.debug("List at {}", (Object)location.location());
        String prefix = location.location().getRawPath().replaceFirst("^/", "");
        S3Objects s3ObjectSummaries = S3Objects.withPrefix((AmazonS3)this.s3, (String)this.bucketName, (String)prefix);
        Stream<S3ObjectSummary> objectStream = StreamSupport.stream(s3ObjectSummaries.spliterator(), false);
        return objectStream.map(os -> new AbsoluteLocation((ResourceLocation)new BaseResolvedResource(this.createPath(location, (S3ObjectSummary)os, prefix.length()), os.getLastModified().toInstant())));
    }

    public InputStream read(AbsoluteLocation location) {
        log.debug("Read from {}", (Object)location);
        return (InputStream)this.executeAndReturn(location, key -> this.s3.getObject(this.bucketName, key).getObjectContent(), (key, version) -> this.s3.getObject(new GetObjectRequest(this.bucketName, key, version.getVersionId())).getObjectContent());
    }

    public OutputStream write(WithCallback<AbsoluteLocation, ? extends ResourceWriteCallback> locationWithCallback) {
        log.debug("Write data by path: {}", (Object)((AbsoluteLocation)locationWithCallback.getWrapped()).location());
        return new MultipartUploadS3StorageOutputStream(this.bucketName, ((AbsoluteLocation)locationWithCallback.getWrapped()).getResource(), this.s3, this.executorService, locationWithCallback.getCallbacks());
    }

    public void remove(AbsoluteLocation location) {
        log.debug("Remove from {}", (Object)location);
        this.execute(location, key -> this.doRemove(this.bucketName, (String)key), (key, version) -> this.s3.deleteVersion(this.bucketName, key, version.getVersionId()));
    }

    public boolean objectExists(AbsoluteLocation location) {
        boolean pathExists = this.executeAndReturn(location, path -> this.s3.doesObjectExist(this.bucketName, path), (path, version) -> StreamSupport.stream(S3Versions.withPrefix((AmazonS3)this.s3, (String)this.bucketName, (String)path).spliterator(), false).anyMatch(it -> it.getVersionId().equals(version.getVersionId())));
        log.debug("Path {} exists {}", (Object)location, (Object)pathExists);
        return pathExists;
    }

    private void doRemove(String bucket, String key) {
        if (key.endsWith("/")) {
            S3Objects.withPrefix((AmazonS3)this.s3, (String)bucket, (String)key).forEach(it -> this.s3.deleteObject(bucket, it.getKey()));
            return;
        }
        this.s3.deleteObject(bucket, key);
    }

    private PrivateResource createPath(AbsoluteLocation root, S3ObjectSummary os, int prefixLen) {
        String relUrl = os.getKey().substring(prefixLen).replaceFirst("^/", "");
        if ("".equals(relUrl)) {
            return BasePrivateResource.forPrivate((Uri)root.location());
        }
        return (PrivateResource)BasePrivateResource.forPrivate((URI)URI.create(relUrl)).resolveFrom((ResourceLocation)root);
    }

    private void execute(AbsoluteLocation location, Consumer<String> ifNoVersion, BiConsumer<String, StorageVersion> ifVersion) {
        this.executeAndReturn(location, path -> {
            ifNoVersion.accept((String)path);
            return null;
        }, (path, version) -> {
            ifVersion.accept((String)path, (StorageVersion)version);
            return null;
        });
    }

    private <T> T executeAndReturn(AbsoluteLocation location, Function<String, T> ifNoVersion, BiFunction<String, StorageVersion, T> ifVersion) {
        String key = location.getResource().location().getRawPath().replaceFirst("^/", "");
        Optional<StorageVersion> version = this.extractVersion(location);
        if (!version.isPresent()) {
            return ifNoVersion.apply(key);
        }
        return ifVersion.apply(key, version.get());
    }

    private Optional<StorageVersion> extractVersion(AbsoluteLocation location) {
        if (!(location.getResource() instanceof VersionedResourceLocation)) {
            return Optional.empty();
        }
        VersionedResourceLocation withVersion = (VersionedResourceLocation)location.getResource();
        if (!(withVersion.getVersion() instanceof StorageVersion)) {
            return Optional.empty();
        }
        return Optional.of((StorageVersion)withVersion.getVersion());
    }
}

