/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.storage.impl.s3;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ListObjectsV2Request;
import com.amazonaws.services.s3.model.ListObjectsV2Result;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import de.adorsys.datasafe.storage.api.StorageService;
import de.adorsys.datasafe.types.api.resource.AbsoluteLocation;
import de.adorsys.datasafe.types.api.resource.BasePrivateResource;
import de.adorsys.datasafe.types.api.resource.BaseResolvedResource;
import de.adorsys.datasafe.types.api.resource.PrivateResource;
import de.adorsys.datasafe.types.api.resource.ResolvedResource;
import de.adorsys.datasafe.types.api.resource.ResourceLocation;
import de.adorsys.datasafe.types.api.utils.Log;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.List;
import java.util.stream.Stream;
import javax.inject.Inject;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3StorageService
implements StorageService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(S3StorageService.class);
    private final AmazonS3 s3;
    private final String bucketName;

    @Inject
    public S3StorageService(AmazonS3 s3, String bucketName) {
        this.s3 = s3;
        this.bucketName = bucketName;
    }

    public Stream<AbsoluteLocation<ResolvedResource>> list(AbsoluteLocation location) {
        log.debug("List at {}", (Object)location);
        ListObjectsV2Request listObjectsV2Request = new ListObjectsV2Request();
        listObjectsV2Request.setBucketName(this.bucketName);
        String prefix = location.location().getPath().replaceFirst("^/", "");
        int len = prefix.length();
        listObjectsV2Request.setPrefix(prefix);
        ListObjectsV2Result listObjectsV2Result = this.s3.listObjectsV2(listObjectsV2Request);
        List objectSummaries = listObjectsV2Result.getObjectSummaries();
        return objectSummaries.stream().map(os -> new AbsoluteLocation((ResourceLocation)new BaseResolvedResource(this.createResource(location, (S3ObjectSummary)os, len), os.getLastModified().toInstant())));
    }

    public InputStream read(AbsoluteLocation location) {
        String key = location.location().getPath().replaceFirst("^/", "");
        log.debug("Read from {}", (Object)Log.secure((Object)key));
        GetObjectRequest getObjectRequest = new GetObjectRequest(this.bucketName, key);
        S3Object fullObject = this.s3.getObject(getObjectRequest);
        return fullObject.getObjectContent();
    }

    public OutputStream write(AbsoluteLocation location) {
        return new PutBlobOnClose(this.s3, this.bucketName, (ResourceLocation)location);
    }

    public void remove(AbsoluteLocation location) {
        String path = location.location().getPath();
        String key = path.replaceFirst("^/", "").replaceFirst("/$", "");
        log.debug("Remove path {}", (Object)Log.secure((Object)key));
        this.s3.deleteObject(this.bucketName, key);
    }

    public boolean objectExists(AbsoluteLocation location) {
        String path = location.location().getPath();
        String key = path.replaceFirst("^/", "").replaceFirst("/$", "");
        boolean pathExists = this.s3.doesObjectExist(this.bucketName, key);
        log.debug("Path {} exists {}", (Object)Log.secure((Object)key), (Object)pathExists);
        return pathExists;
    }

    private PrivateResource createResource(AbsoluteLocation root, S3ObjectSummary os, int prefixLen) {
        String relUrl = os.getKey().substring(prefixLen).replaceFirst("^/", "");
        if ("".equals(relUrl)) {
            return BasePrivateResource.forPrivate((URI)root.location());
        }
        return (PrivateResource)BasePrivateResource.forPrivate((String)relUrl).resolve((ResourceLocation)root);
    }

    private static final class PutBlobOnClose
    extends ByteArrayOutputStream {
        @Generated
        private static final Logger log = LoggerFactory.getLogger(PutBlobOnClose.class);
        private final AmazonS3 s3;
        private final String bucketName;
        private final ResourceLocation resource;

        @Override
        public void close() throws IOException {
            ObjectMetadata metadata = new ObjectMetadata();
            byte[] data = super.toByteArray();
            metadata.setContentLength((long)data.length);
            ByteArrayInputStream is = new ByteArrayInputStream(data);
            String key = this.resource.location().getPath().replaceFirst("^/", "");
            log.debug("Write to {}", (Object)Log.secure((Object)key));
            this.s3.putObject(this.bucketName, key, (InputStream)is, metadata);
            super.close();
        }

        @Generated
        public PutBlobOnClose(AmazonS3 s3, String bucketName, ResourceLocation resource) {
            this.s3 = s3;
            this.bucketName = bucketName;
            this.resource = resource;
        }
    }
}

