/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.storage.impl.s3;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.iterable.S3Objects;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import de.adorsys.datasafe.storage.api.StorageService;
import de.adorsys.datasafe.storage.impl.s3.MultipartUploadS3StorageOutputStream;
import de.adorsys.datasafe.types.api.resource.AbsoluteLocation;
import de.adorsys.datasafe.types.api.resource.BasePrivateResource;
import de.adorsys.datasafe.types.api.resource.BaseResolvedResource;
import de.adorsys.datasafe.types.api.resource.PrivateResource;
import de.adorsys.datasafe.types.api.resource.ResolvedResource;
import de.adorsys.datasafe.types.api.resource.ResourceLocation;
import de.adorsys.datasafe.types.api.resource.Uri;
import de.adorsys.datasafe.types.api.utils.Obfuscate;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.ExecutorService;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3StorageService
implements StorageService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(S3StorageService.class);
    private final AmazonS3 s3;
    private final String bucketName;
    private final ExecutorService executorService;

    @Inject
    public S3StorageService(AmazonS3 s3, String bucketName, ExecutorService executorService) {
        this.s3 = s3;
        this.bucketName = bucketName;
        this.executorService = executorService;
    }

    public Stream<AbsoluteLocation<ResolvedResource>> list(AbsoluteLocation location) {
        log.debug("List at {}", (Object)Obfuscate.secure((ResourceLocation)location));
        String prefix = location.location().getPath().replaceFirst("^/", "");
        S3Objects s3ObjectSummaries = S3Objects.withPrefix((AmazonS3)this.s3, (String)this.bucketName, (String)prefix);
        Stream<S3ObjectSummary> objectStream = StreamSupport.stream(s3ObjectSummaries.spliterator(), false);
        return objectStream.map(os -> new AbsoluteLocation((ResourceLocation)new BaseResolvedResource(this.createResource(location, (S3ObjectSummary)os, prefix.length()), os.getLastModified().toInstant())));
    }

    public InputStream read(AbsoluteLocation location) {
        String key = location.location().getPath().replaceFirst("^/", "");
        log.debug("Read from {}", (Object)Obfuscate.secure((Object)key));
        GetObjectRequest getObjectRequest = new GetObjectRequest(this.bucketName, key);
        S3Object fullObject = this.s3.getObject(getObjectRequest);
        return fullObject.getObjectContent();
    }

    public OutputStream write(AbsoluteLocation location) {
        log.debug("Write data by path: {}", (Object)Obfuscate.secure((Uri)location.location()));
        return new MultipartUploadS3StorageOutputStream(this.bucketName, location.getResource(), this.s3, this.executorService);
    }

    public void remove(AbsoluteLocation location) {
        String path = location.location().getPath();
        String key = path.replaceFirst("^/", "").replaceFirst("/$", "");
        log.debug("Remove path {}", (Object)Obfuscate.secure((Object)key));
        this.s3.deleteObject(this.bucketName, key);
    }

    public boolean objectExists(AbsoluteLocation location) {
        String path = location.location().getPath();
        String key = path.replaceFirst("^/", "").replaceFirst("/$", "");
        boolean pathExists = this.s3.doesObjectExist(this.bucketName, key);
        log.debug("Path {} exists {}", (Object)Obfuscate.secure((Object)key), (Object)pathExists);
        return pathExists;
    }

    private PrivateResource createResource(AbsoluteLocation root, S3ObjectSummary os, int prefixLen) {
        String relUrl = os.getKey().substring(prefixLen).replaceFirst("^/", "");
        if ("".equals(relUrl)) {
            return BasePrivateResource.forPrivate((Uri)root.location());
        }
        return (PrivateResource)BasePrivateResource.forPrivate((String)relUrl).resolveFrom((ResourceLocation)root);
    }
}

