/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.storage.impl.fs;

import com.google.common.io.MoreFiles;
import de.adorsys.datasafe.storage.api.StorageService;
import de.adorsys.datasafe.types.api.resource.AbsoluteLocation;
import de.adorsys.datasafe.types.api.resource.BasePrivateResource;
import de.adorsys.datasafe.types.api.resource.BaseResolvedResource;
import de.adorsys.datasafe.types.api.resource.PrivateResource;
import de.adorsys.datasafe.types.api.resource.ResolvedResource;
import de.adorsys.datasafe.types.api.resource.ResourceLocation;
import de.adorsys.datasafe.types.api.utils.Log;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.time.Instant;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemStorageService
implements StorageService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FileSystemStorageService.class);
    private final URI dir;

    public Stream<AbsoluteLocation<ResolvedResource>> list(AbsoluteLocation path) {
        log.debug("List file request: {}", (Object)path);
        Path filePath = this.resolve(path.location(), false);
        log.debug("List file: {}", (Object)Log.secure((Path)filePath));
        if (!filePath.toFile().exists()) {
            return Stream.empty();
        }
        return Files.walk(filePath, new FileVisitOption[0]).filter(it -> !it.startsWith(".")).filter(it -> !it.toFile().isDirectory()).map(it -> new AbsoluteLocation((ResourceLocation)new BaseResolvedResource((PrivateResource)new BasePrivateResource(it.toUri()), Instant.ofEpochMilli(it.toFile().lastModified()))));
    }

    public InputStream read(AbsoluteLocation path) {
        log.debug("Read file request: {}", (Object)path);
        Path filePath = this.resolve(path.location(), false);
        log.debug("Read file: {}", (Object)Log.secure((Path)filePath));
        return MoreFiles.asByteSource((Path)filePath, (OpenOption[])new OpenOption[]{StandardOpenOption.READ}).openStream();
    }

    public OutputStream write(AbsoluteLocation path) {
        log.debug("Write file request: {}", (Object)Log.secure((URI)path.location()));
        Path filePath = this.resolve(path.location(), true);
        log.debug("Write file: {}", (Object)Log.secure((Path)filePath));
        return MoreFiles.asByteSink((Path)filePath, (OpenOption[])new OpenOption[]{StandardOpenOption.CREATE}).openStream();
    }

    public void remove(AbsoluteLocation location) {
        if (!this.objectExists(location)) {
            log.debug("nothing to delete {}", (Object)location);
            return;
        }
        Path path = this.resolve(location.location(), false);
        boolean isFile = !path.toFile().isDirectory();
        Files.delete(this.resolve(location.location(), false));
        log.debug("deleted {} at: {}", (Object)(isFile ? "file" : "directory"), (Object)location);
    }

    public boolean objectExists(AbsoluteLocation location) {
        boolean exists = Files.exists(this.resolve(location.location(), false), new LinkOption[0]);
        log.debug("exists {} directory at: {}", (Object)exists, (Object)Log.secure((ResourceLocation)location));
        return exists;
    }

    protected Path resolve(URI uri, boolean mkDirs) {
        Path path = Paths.get(this.dir.resolve(uri));
        if (!path.getParent().toFile().exists() && mkDirs) {
            log.debug("Creating directories for: {}", (Object)Log.secure((Path)path));
            path.getParent().toFile().mkdirs();
        }
        return Paths.get(this.dir.resolve(uri));
    }

    @Generated
    public FileSystemStorageService(URI dir) {
        this.dir = dir;
    }
}

