/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.storage.impl.db;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import de.adorsys.datasafe.storage.impl.db.DatabaseCredentials;
import de.adorsys.datasafe.storage.impl.db.DbUriExtractor;
import de.adorsys.datasafe.storage.impl.db.DefaultDbUriExtractor;
import de.adorsys.datasafe.types.api.resource.AbsoluteLocation;
import java.net.URI;
import java.sql.Connection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import liquibase.Contexts;
import liquibase.LabelExpression;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.support.JdbcDaoSupport;

public class DatabaseConnectionRegistry {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DatabaseConnectionRegistry.class);
    private final DbUriExtractor uriExtractor;
    private final Map<String, JdbcDaoSupport> dataSourceCache;
    private final Map<String, DatabaseCredentials> providedCredentials;

    public DatabaseConnectionRegistry() {
        this.uriExtractor = new DefaultDbUriExtractor();
        this.dataSourceCache = new ConcurrentHashMap<String, JdbcDaoSupport>();
        this.providedCredentials = Collections.emptyMap();
    }

    public DatabaseConnectionRegistry(Map<String, DatabaseCredentials> providedCredentials) {
        this.uriExtractor = new DefaultDbUriExtractor();
        this.dataSourceCache = new ConcurrentHashMap<String, JdbcDaoSupport>();
        this.providedCredentials = providedCredentials;
    }

    public DatabaseConnectionRegistry(DbUriExtractor uriExtractor, Map<String, DatabaseCredentials> providedCredentials) {
        this.dataSourceCache = new ConcurrentHashMap<String, JdbcDaoSupport>();
        this.providedCredentials = providedCredentials;
        this.uriExtractor = uriExtractor;
    }

    public JdbcTemplate jdbcTemplate(AbsoluteLocation location) {
        return this.dataSourceCache.computeIfAbsent(this.connectionKey(location), key -> this.acquireDaoSupport(location, this.getCredentials(location))).getJdbcTemplate();
    }

    protected void updateDbSchema(DataSource dataSource) {
        try (Connection dbConn = dataSource.getConnection();){
            JdbcConnection connection = new JdbcConnection(dbConn);
            Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)connection);
            Liquibase liquibase = new Liquibase("changelog/changelog.xml", (ResourceAccessor)new ClassLoaderResourceAccessor(), database);
            liquibase.update(new Contexts(), new LabelExpression());
        }
    }

    protected JdbcDaoSupport acquireDaoSupport(AbsoluteLocation location, DatabaseCredentials credentials) {
        JdbcDaoSupport daoSupport = new JdbcDaoSupport(){};
        HikariDataSource dataSource = DatabaseConnectionRegistry.getHikariDataSource(this.uriExtractor.extract(location), credentials.getUsername(), credentials.getPassword());
        daoSupport.setDataSource((DataSource)dataSource);
        this.updateDbSchema((DataSource)dataSource);
        return daoSupport;
    }

    protected DatabaseCredentials getCredentials(AbsoluteLocation location) {
        URI uri = location.location().asURI();
        String userInfo = uri.getUserInfo();
        if (null != userInfo && !"".equals(userInfo)) {
            return new DatabaseCredentials(location);
        }
        return (DatabaseCredentials)this.providedCredentials.entrySet().stream().filter(it -> uri.toASCIIString().startsWith((String)it.getKey())).findFirst().orElseThrow(() -> new IllegalArgumentException("There is no associated database for this credentials")).getValue();
    }

    private String connectionKey(AbsoluteLocation location) {
        URI target = location.location().asURI();
        return target.getScheme() + target.getHost();
    }

    private static HikariDataSource getHikariDataSource(String url, String user, String password) {
        log.debug("Setup config for DB url: {0}", (Object)url);
        HikariConfig config = new HikariConfig();
        config.setJdbcUrl(url);
        config.setConnectionTestQuery("SELECT 1");
        config.addDataSourceProperty("user", (Object)user);
        config.addDataSourceProperty("password", (Object)password);
        return new HikariDataSource(config);
    }
}

