/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.storage.impl.db;

import de.adorsys.datasafe.types.api.resource.AbsoluteLocation;
import java.net.URI;
import lombok.Generated;

public class DatabaseCredentials {
    private final String username;
    private final String password;

    public DatabaseCredentials(AbsoluteLocation location) {
        URI uri = location.location().asURI();
        if (uri.getPath() == null) {
            throw new IllegalArgumentException("Wrong url format");
        }
        String[] userInfo = location.location().asURI().getUserInfo().split(":");
        this.username = userInfo[0];
        this.password = userInfo[1];
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DatabaseCredentials)) {
            return false;
        }
        DatabaseCredentials other = (DatabaseCredentials)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        return !(this$password == null ? other$password != null : !this$password.equals(other$password));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DatabaseCredentials;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DatabaseCredentials(username=" + this.getUsername() + ", password=" + this.getPassword() + ")";
    }

    @Generated
    public DatabaseCredentials(String username, String password) {
        this.username = username;
        this.password = password;
    }
}

