/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.storage.impl.db;

import de.adorsys.datasafe.storage.api.StorageService;
import de.adorsys.datasafe.storage.impl.db.DatabaseConnectionRegistry;
import de.adorsys.datasafe.types.api.callback.ResourceWriteCallback;
import de.adorsys.datasafe.types.api.resource.AbsoluteLocation;
import de.adorsys.datasafe.types.api.resource.BasePrivateResource;
import de.adorsys.datasafe.types.api.resource.BaseResolvedResource;
import de.adorsys.datasafe.types.api.resource.PrivateResource;
import de.adorsys.datasafe.types.api.resource.ResolvedResource;
import de.adorsys.datasafe.types.api.resource.ResourceLocation;
import de.adorsys.datasafe.types.api.resource.Uri;
import de.adorsys.datasafe.types.api.resource.WithCallback;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URI;
import java.sql.PreparedStatement;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;

public class DatabaseStorageService
implements StorageService {
    private final Set<String> allowedTables;
    private final DatabaseConnectionRegistry conn;

    public boolean objectExists(AbsoluteLocation location) {
        ParsedLocation parsed = new ParsedLocation(location, this.allowedTables);
        String sql = "SELECT COUNT(*) FROM " + parsed.getTableName() + " WHERE key = ?";
        return 0 != (Integer)this.conn.jdbcTemplate(location).queryForObject(sql, Integer.class, new Object[]{parsed.getPathWithUser()});
    }

    public Stream<AbsoluteLocation<ResolvedResource>> list(AbsoluteLocation location) {
        ParsedLocation parsed = new ParsedLocation(location, this.allowedTables);
        String sql = "SELECT key,last_modified FROM " + parsed.getTableName() + " WHERE key LIKE '" + parsed.getPathWithUser() + "%'";
        List keys = this.conn.jdbcTemplate(location).queryForList(sql);
        return keys.stream().map(it -> new AbsoluteLocation((ResourceLocation)new BaseResolvedResource(this.createPath(location, (String)it.get("key")), ((Date)it.get("last_modified")).toInstant())));
    }

    public InputStream read(AbsoluteLocation location) {
        ParsedLocation parsed = new ParsedLocation(location, this.allowedTables);
        String sql = "SELECT value FROM " + parsed.getTableName() + " WHERE key = ?";
        RowMapper rowMapper = (rs, i) -> rs.getClob("value").getAsciiStream();
        List values = this.conn.jdbcTemplate(location).query(sql, new Object[]{parsed.getPathWithUser()}, rowMapper);
        if (values.size() == 1) {
            return (InputStream)values.get(0);
        }
        throw new IllegalArgumentException("No item found");
    }

    public void remove(AbsoluteLocation location) {
        ParsedLocation parsed = new ParsedLocation(location, this.allowedTables);
        String sql = "DELETE FROM " + parsed.getTableName() + " WHERE key = ?";
        this.conn.jdbcTemplate(location).update(sql, new Object[]{parsed.getPathWithUser()});
    }

    public OutputStream write(WithCallback<AbsoluteLocation, ? extends ResourceWriteCallback> locationWithCallback) {
        ParsedLocation parsed = new ParsedLocation((AbsoluteLocation)locationWithCallback.getWrapped(), this.allowedTables);
        return new PutBlobOnClose(this.conn.jdbcTemplate((AbsoluteLocation)locationWithCallback.getWrapped()), parsed.getPathWithUser(), parsed.getTableName());
    }

    private PrivateResource createPath(AbsoluteLocation root, String key) {
        String fullUri = root.location().withoutAuthority().toASCIIString();
        int keyIndex = fullUri.indexOf(key);
        AbsoluteLocation resourceRoot = BasePrivateResource.forAbsolutePrivate((Uri)new Uri(root.location().withoutAuthority()));
        if (keyIndex >= 0) {
            resourceRoot = BasePrivateResource.forAbsolutePrivate((Uri)new Uri(fullUri.substring(0, keyIndex)));
        }
        return (PrivateResource)BasePrivateResource.forPrivate((String)key).resolveFrom((ResourceLocation)resourceRoot);
    }

    @Generated
    public DatabaseStorageService(Set<String> allowedTables, DatabaseConnectionRegistry conn) {
        this.allowedTables = allowedTables;
        this.conn = conn;
    }

    private static final class ParsedLocation {
        private final Set<String> allowedTables;
        private final String tableName;
        private final String path;
        private final String pathWithUser;

        ParsedLocation(AbsoluteLocation location, Set<String> allowedTables) {
            this.allowedTables = allowedTables;
            this.tableName = this.extractTable(location);
            this.path = location.location().getPath();
            this.pathWithUser = this.path.substring(this.path.indexOf(this.tableName) + this.tableName.length() + 1);
        }

        private String extractTable(AbsoluteLocation location) {
            URI uri = location.location().asURI();
            if (uri.getPath() == null) {
                throw new IllegalArgumentException("Wrong url format");
            }
            String[] uriParts = uri.getPath().split("/");
            if (!this.allowedTables.contains(uriParts[2])) {
                throw new IllegalArgumentException("Wrong db table name");
            }
            return uriParts[2];
        }

        @Generated
        public Set<String> getAllowedTables() {
            return this.allowedTables;
        }

        @Generated
        public String getTableName() {
            return this.tableName;
        }

        @Generated
        public String getPath() {
            return this.path;
        }

        @Generated
        public String getPathWithUser() {
            return this.pathWithUser;
        }
    }

    private static final class PutBlobOnClose
    extends ByteArrayOutputStream {
        @Generated
        private static final Logger log = LoggerFactory.getLogger(PutBlobOnClose.class);
        private final JdbcTemplate jdbcTemplate;
        private final String pathWithUser;
        private final String tableName;

        @Override
        public void close() throws IOException {
            String sql = "INSERT INTO " + this.tableName + " (key, value) VALUES(?, ?)";
            GeneratedKeyHolder holder = new GeneratedKeyHolder();
            this.jdbcTemplate.update(this.writeData(sql), (KeyHolder)holder);
            super.close();
        }

        private PreparedStatementCreator writeData(String sql) {
            return connection -> {
                PreparedStatement ps = connection.prepareStatement(sql, 1);
                ps.setString(1, this.pathWithUser);
                byte[] data = super.toByteArray();
                InputStreamReader reader = new InputStreamReader(new ByteArrayInputStream(data));
                ps.setClob(2, reader);
                return ps;
            };
        }

        @Generated
        public PutBlobOnClose(JdbcTemplate jdbcTemplate, String pathWithUser, String tableName) {
            this.jdbcTemplate = jdbcTemplate;
            this.pathWithUser = pathWithUser;
            this.tableName = tableName;
        }
    }
}

