/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.storage.api;

import de.adorsys.datasafe.storage.api.BaseDelegatingStorage;
import de.adorsys.datasafe.storage.api.StorageService;
import de.adorsys.datasafe.types.api.resource.AbsoluteLocation;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import lombok.Generated;

public class UriBasedAuthStorageService
extends BaseDelegatingStorage {
    private final Map<AccessId, StorageService> clientByItsAccessKey = new ConcurrentHashMap<AccessId, StorageService>();
    private final Function<URI, String> bucketExtractor;
    private final Function<URI, String> regionExtractor;
    private final Function<URI, String> endpointExtractor;
    private final Function<AccessId, StorageService> storageServiceBuilder;

    public UriBasedAuthStorageService(Function<AccessId, StorageService> storageServiceBuilder) {
        this.storageServiceBuilder = storageServiceBuilder;
        Function<URI, String[]> segmentator = location -> location.getPath().replaceAll("^/", "").split("/");
        this.regionExtractor = location -> ((String[])segmentator.apply((URI)location))[0];
        this.bucketExtractor = location -> ((String[])segmentator.apply((URI)location))[1];
        this.endpointExtractor = location -> location.getScheme() + "://" + location.getHost() + this.portValue((URI)location) + "/";
    }

    public UriBasedAuthStorageService(Function<AccessId, StorageService> storageServiceBuilder, Function<URI, String[]> segmentator) {
        this.storageServiceBuilder = storageServiceBuilder;
        this.regionExtractor = location -> ((String[])segmentator.apply((URI)location))[0];
        this.bucketExtractor = location -> ((String[])segmentator.apply((URI)location))[1];
        this.endpointExtractor = location -> location.getScheme() + "://" + location.getHost() + this.portValue((URI)location) + "/";
    }

    @Override
    protected StorageService service(AbsoluteLocation location) {
        String[] authority = location.location().asURI().getAuthority().split("@")[0].split(":");
        URI uri = location.getResource().location().withoutAuthority();
        AccessId accessId = new AccessId(authority[0], authority[1], this.regionExtractor.apply(uri), this.bucketExtractor.apply(uri), this.endpointExtractor.apply(uri), uri, URI.create(uri.getScheme() + "://" + uri.getHost() + this.portValue(uri)));
        return this.clientByItsAccessKey.computeIfAbsent(accessId, this.storageServiceBuilder);
    }

    private String portValue(URI uri) {
        return uri.getPort() != -1 ? ":" + uri.getPort() : "";
    }

    @Generated
    public UriBasedAuthStorageService(Function<URI, String> bucketExtractor, Function<URI, String> regionExtractor, Function<URI, String> endpointExtractor, Function<AccessId, StorageService> storageServiceBuilder) {
        this.bucketExtractor = bucketExtractor;
        this.regionExtractor = regionExtractor;
        this.endpointExtractor = endpointExtractor;
        this.storageServiceBuilder = storageServiceBuilder;
    }

    public static class AccessId {
        private final String accessKey;
        private final String secretKey;
        private final String region;
        private final String bucketName;
        private final String endpoint;
        private final URI withoutCreds;
        private final URI onlyHostPart;

        @Generated
        public String getAccessKey() {
            return this.accessKey;
        }

        @Generated
        public String getSecretKey() {
            return this.secretKey;
        }

        @Generated
        public String getRegion() {
            return this.region;
        }

        @Generated
        public String getBucketName() {
            return this.bucketName;
        }

        @Generated
        public String getEndpoint() {
            return this.endpoint;
        }

        @Generated
        public URI getWithoutCreds() {
            return this.withoutCreds;
        }

        @Generated
        public URI getOnlyHostPart() {
            return this.onlyHostPart;
        }

        @Generated
        public AccessId(String accessKey, String secretKey, String region, String bucketName, String endpoint, URI withoutCreds, URI onlyHostPart) {
            this.accessKey = accessKey;
            this.secretKey = secretKey;
            this.region = region;
            this.bucketName = bucketName;
            this.endpoint = endpoint;
            this.withoutCreds = withoutCreds;
            this.onlyHostPart = onlyHostPart;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AccessId)) {
                return false;
            }
            AccessId other = (AccessId)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$accessKey = this.getAccessKey();
            String other$accessKey = other.getAccessKey();
            if (this$accessKey == null ? other$accessKey != null : !this$accessKey.equals(other$accessKey)) {
                return false;
            }
            String this$secretKey = this.getSecretKey();
            String other$secretKey = other.getSecretKey();
            if (this$secretKey == null ? other$secretKey != null : !this$secretKey.equals(other$secretKey)) {
                return false;
            }
            String this$bucketName = this.getBucketName();
            String other$bucketName = other.getBucketName();
            if (this$bucketName == null ? other$bucketName != null : !this$bucketName.equals(other$bucketName)) {
                return false;
            }
            String this$endpoint = this.getEndpoint();
            String other$endpoint = other.getEndpoint();
            return !(this$endpoint == null ? other$endpoint != null : !this$endpoint.equals(other$endpoint));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AccessId;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $accessKey = this.getAccessKey();
            result = result * 59 + ($accessKey == null ? 43 : $accessKey.hashCode());
            String $secretKey = this.getSecretKey();
            result = result * 59 + ($secretKey == null ? 43 : $secretKey.hashCode());
            String $bucketName = this.getBucketName();
            result = result * 59 + ($bucketName == null ? 43 : $bucketName.hashCode());
            String $endpoint = this.getEndpoint();
            result = result * 59 + ($endpoint == null ? 43 : $endpoint.hashCode());
            return result;
        }
    }
}

