/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.storage.api;

import de.adorsys.datasafe.storage.api.BaseDelegatingStorage;
import de.adorsys.datasafe.storage.api.StorageService;
import de.adorsys.datasafe.types.api.resource.AbsoluteLocation;
import java.util.Map;

public class SchemeDelegatingStorage
extends BaseDelegatingStorage {
    private final Map<String, StorageService> storageByScheme;

    public SchemeDelegatingStorage(Map<String, StorageService> storageByProtocol) {
        this.storageByScheme = storageByProtocol;
    }

    @Override
    protected StorageService service(AbsoluteLocation location) {
        String protocol = location.location().asURI().getScheme();
        StorageService service = this.storageByScheme.get(protocol);
        if (null == service) {
            throw new IllegalArgumentException("No storage service for this protocol: " + protocol);
        }
        return service;
    }
}

