/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.storage.api;

import de.adorsys.datasafe.storage.api.BaseDelegatingStorage;
import de.adorsys.datasafe.storage.api.StorageService;
import de.adorsys.datasafe.types.api.resource.AbsoluteLocation;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UserBasedDelegatingStorage
extends BaseDelegatingStorage {
    private final Map<String, StorageService> clientByBucket = new ConcurrentHashMap<String, StorageService>();
    private final List<String> amazonBuckets;
    private final Function<String, StorageService> storageServiceBuilder;

    public UserBasedDelegatingStorage(Function<String, StorageService> storageServiceBuilder, List<String> amazonBuckets) {
        this.storageServiceBuilder = storageServiceBuilder;
        this.amazonBuckets = amazonBuckets;
    }

    @Override
    protected StorageService service(AbsoluteLocation location) {
        String bucketName = this.getBucketNameFromLocation(location);
        return this.clientByBucket.computeIfAbsent(bucketName, this.storageServiceBuilder);
    }

    @Override
    public Optional<Integer> flushChunkSize(AbsoluteLocation location) {
        String bucketName = this.getBucketNameFromLocation(location);
        return this.clientByBucket.computeIfAbsent(bucketName, this.storageServiceBuilder).flushChunkSize(location);
    }

    private String getBucketNameFromLocation(AbsoluteLocation location) {
        Pattern userPattern = Pattern.compile(".+/user-(\\d+).*");
        Matcher matcher = userPattern.matcher(location.location().asString());
        matcher.matches();
        int userNum = Integer.parseInt(matcher.group(1));
        return this.amazonBuckets.get(userNum % this.amazonBuckets.size());
    }
}

