/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.storage.api;

import de.adorsys.datasafe.storage.api.BaseDelegatingStorage;
import de.adorsys.datasafe.storage.api.StorageService;
import de.adorsys.datasafe.types.api.resource.AbsoluteLocation;
import java.util.Map;
import java.util.regex.Pattern;

public class RegexDelegatingStorage
extends BaseDelegatingStorage {
    private final Map<Pattern, StorageService> storageByPattern;

    public RegexDelegatingStorage(Map<Pattern, StorageService> storageByPattern) {
        this.storageByPattern = storageByPattern;
    }

    @Override
    protected StorageService service(AbsoluteLocation location) {
        String uri = location.location().asString();
        return this.storageByPattern.entrySet().stream().filter(it -> ((Pattern)it.getKey()).matcher(uri).matches()).map(Map.Entry::getValue).findFirst().orElseThrow(() -> new IllegalArgumentException("Storage backing URI " + uri + " not found"));
    }
}

