/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.storage.api;

import de.adorsys.datasafe.storage.api.StorageService;
import de.adorsys.datasafe.types.api.callback.ResourceWriteCallback;
import de.adorsys.datasafe.types.api.resource.AbsoluteLocation;
import de.adorsys.datasafe.types.api.resource.ResolvedResource;
import de.adorsys.datasafe.types.api.resource.WithCallback;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.stream.Stream;

public class SchemeDelegatingStorage
implements StorageService {
    private final Map<String, StorageService> storageByScheme;

    public SchemeDelegatingStorage(Map<String, StorageService> storageByProtocol) {
        this.storageByScheme = storageByProtocol;
    }

    @Override
    public boolean objectExists(AbsoluteLocation location) {
        return this.service(location).objectExists(location);
    }

    @Override
    public Stream<AbsoluteLocation<ResolvedResource>> list(AbsoluteLocation location) {
        return this.service(location).list(location);
    }

    @Override
    public InputStream read(AbsoluteLocation location) {
        return this.service(location).read(location);
    }

    @Override
    public void remove(AbsoluteLocation location) {
        this.service(location).remove(location);
    }

    @Override
    public OutputStream write(WithCallback<AbsoluteLocation, ? extends ResourceWriteCallback> locationWithCallback) {
        return this.service((AbsoluteLocation)locationWithCallback.getWrapped()).write(locationWithCallback);
    }

    private StorageService service(AbsoluteLocation location) {
        String protocol = location.location().asURI().getScheme();
        StorageService service = this.storageByScheme.get(protocol);
        if (null == service) {
            throw new IllegalArgumentException("No storage service for this protocol: " + protocol);
        }
        return service;
    }
}

