/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.simple.adapter.spring.factory;

import de.adorsys.datasafe.encrypiton.api.types.encryption.MutableEncryptionConfig;
import de.adorsys.datasafe.simple.adapter.api.SimpleDatasafeService;
import de.adorsys.datasafe.simple.adapter.api.exceptions.SimpleAdapterException;
import de.adorsys.datasafe.simple.adapter.api.types.AmazonS3DFSCredentials;
import de.adorsys.datasafe.simple.adapter.api.types.DFSCredentials;
import de.adorsys.datasafe.simple.adapter.api.types.FilesystemDFSCredentials;
import de.adorsys.datasafe.simple.adapter.impl.SimpleDatasafeServiceImpl;
import de.adorsys.datasafe.simple.adapter.spring.properties.SpringDatasafeEncryptionProperties;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;

public class SpringSimpleDatasafeServiceFactory {
    @Autowired
    DFSCredentials wiredDfsCredentials;
    @Autowired
    SpringDatasafeEncryptionProperties encryptionProperties;
    DFSCredentials dfsCredentials;
    boolean useWiredCredentials = true;

    @PostConstruct
    public void postConstruct() {
        if (this.useWiredCredentials) {
            if (this.wiredDfsCredentials == null) {
                throw new RuntimeException("wiredDfsCredentials are nulL, so injection did not work");
            }
            this.dfsCredentials = this.wiredDfsCredentials;
        }
    }

    public SpringSimpleDatasafeServiceFactory() {
        this.useWiredCredentials = true;
    }

    public SpringSimpleDatasafeServiceFactory(DFSCredentials credentials) {
        if (credentials == null) {
            throw new RuntimeException("dfs credentials passed in must not be null");
        }
        this.dfsCredentials = credentials;
        this.useWiredCredentials = false;
    }

    public SimpleDatasafeService getSimpleDataSafeServiceWithSubdir(String subdirBelowRoot) {
        if (this.dfsCredentials instanceof AmazonS3DFSCredentials) {
            AmazonS3DFSCredentials amazonS3DFSCredentials = (AmazonS3DFSCredentials)this.dfsCredentials;
            return new SimpleDatasafeServiceImpl((DFSCredentials)amazonS3DFSCredentials.toBuilder().rootBucket(amazonS3DFSCredentials.getRootBucket() + "/" + subdirBelowRoot).build(), null != this.encryptionProperties ? this.encryptionProperties.getEncryption() : new MutableEncryptionConfig());
        }
        if (this.dfsCredentials instanceof FilesystemDFSCredentials) {
            FilesystemDFSCredentials filesystemDFSCredentials = (FilesystemDFSCredentials)this.dfsCredentials;
            return new SimpleDatasafeServiceImpl((DFSCredentials)filesystemDFSCredentials.toBuilder().root(filesystemDFSCredentials.getRoot() + "/" + subdirBelowRoot).build(), null != this.encryptionProperties ? this.encryptionProperties.getEncryption() : new MutableEncryptionConfig());
        }
        throw new SimpleAdapterException("missing switch for DFSCredentials" + this.dfsCredentials);
    }
}

