/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.simple.adapter.spring;

import de.adorsys.datasafe.simple.adapter.api.exceptions.SimpleAdapterException;
import de.adorsys.datasafe.simple.adapter.api.types.AmazonS3DFSCredentials;
import de.adorsys.datasafe.simple.adapter.api.types.DFSCredentials;
import de.adorsys.datasafe.simple.adapter.api.types.FilesystemDFSCredentials;
import de.adorsys.datasafe.simple.adapter.spring.properties.SpringAmazonS3DFSCredentialsProperties;
import de.adorsys.datasafe.simple.adapter.spring.properties.SpringDFSCredentialProperties;
import de.adorsys.datasafe.simple.adapter.spring.properties.SpringFilesystemDFSCredentialsProperties;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpringPropertiesToDFSCredentialsUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SpringPropertiesToDFSCredentialsUtil.class);

    public static DFSCredentials dfsCredentials(SpringDFSCredentialProperties properties) {
        Object props;
        FilesystemDFSCredentials dfsCredentials = null;
        if (properties.getAmazons3() != null) {
            props = properties.getAmazons3();
            dfsCredentials = AmazonS3DFSCredentials.builder().rootBucket(((SpringAmazonS3DFSCredentialsProperties)props).getRootbucket()).accessKey(((SpringAmazonS3DFSCredentialsProperties)props).getAccesskey()).secretKey(((SpringAmazonS3DFSCredentialsProperties)props).getSecretkey()).region(((SpringAmazonS3DFSCredentialsProperties)props).getRegion()).url(((SpringAmazonS3DFSCredentialsProperties)props).getUrl()).noHttps(((SpringAmazonS3DFSCredentialsProperties)props).isNohttps()).threadPoolSize(((SpringAmazonS3DFSCredentialsProperties)props).getThreadpoolsize()).requestTimeout(((SpringAmazonS3DFSCredentialsProperties)props).getRequesttimeout()).maxConnections(((SpringAmazonS3DFSCredentialsProperties)props).getMaxconnections()).build();
        }
        if (properties.getFilesystem() != null) {
            props = properties.getFilesystem();
            dfsCredentials = FilesystemDFSCredentials.builder().root(((SpringFilesystemDFSCredentialsProperties)props).getRootbucket()).build();
        }
        if (dfsCredentials == null) {
            throw new SimpleAdapterException("Spring properties are not set correctly. Please use at least one of those:\n\ndatasafe:\n  storeconnection:\n    filesystem:\n      rootbucket: (mandatory)\n\ndatasafe:\n  storeconnection:\n    amazons3:\n      url: (mandatory)\n      accesskey: (mandatory)\n      secretkey: (mandatory)\n      region: (optional)\n      rootbucket: (optional)\n      nohttps: (optional, default false - use https to reach s3 endpoint)\n      threadpoolsize: (optional, default 5, how many workers should send chunk requests)\n      maxconnections: (optional, if unset default of amazon is taken)\n      requesttimeout: (optional, if unset default of amazon is taken)\n");
        }
        return dfsCredentials;
    }
}

