package de.adorsys.datasafe.simple.adapter.spring.factory;

import de.adorsys.datasafe.simple.adapter.api.SimpleDatasafeService;
import de.adorsys.datasafe.simple.adapter.api.exceptions.SimpleAdapterException;
import de.adorsys.datasafe.simple.adapter.api.types.AmazonS3DFSCredentials;
import de.adorsys.datasafe.simple.adapter.api.types.DFSCredentials;
import de.adorsys.datasafe.simple.adapter.api.types.FilesystemDFSCredentials;
import de.adorsys.datasafe.simple.adapter.impl.SimpleDatasafeServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import javax.annotation.PostConstruct;

public class SpringSimpleDatasafeServiceFactory {

    @Autowired
    DFSCredentials wiredDfsCredentials;

    DFSCredentials dfsCredentials;

    boolean useWiredCredentials = true;
    @PostConstruct
    public void postConstruct() {
        if (useWiredCredentials) {
            if (wiredDfsCredentials == null) {
                throw new RuntimeException("wiredDfsCredentials are nulL, so injection did not work");
            }
            dfsCredentials = wiredDfsCredentials;
        }
    }

    public SpringSimpleDatasafeServiceFactory() {
        useWiredCredentials = true;
    }

    public SpringSimpleDatasafeServiceFactory(DFSCredentials credentials) {
        if (credentials == null) {
            throw new RuntimeException("dfs credentials passed in must not be null");
        }
        dfsCredentials = credentials;
        useWiredCredentials = false;
    }

    public SimpleDatasafeService getSimpleDataSafeServiceWithSubdir(String subdirBelowRoot) {
        if (dfsCredentials instanceof AmazonS3DFSCredentials) {
            AmazonS3DFSCredentials amazonS3DFSCredentials = (AmazonS3DFSCredentials) dfsCredentials;
            return new SimpleDatasafeServiceImpl(amazonS3DFSCredentials.toBuilder().rootBucket(amazonS3DFSCredentials.getRootBucket() + "/" + subdirBelowRoot).build());
        }
        if (dfsCredentials instanceof FilesystemDFSCredentials) {
            FilesystemDFSCredentials filesystemDFSCredentials = (FilesystemDFSCredentials) dfsCredentials;
            return new SimpleDatasafeServiceImpl(filesystemDFSCredentials.toBuilder().root(filesystemDFSCredentials.getRoot() + "/" + subdirBelowRoot).build());
        }
        throw new SimpleAdapterException("missing switch for DFSCredentials" + dfsCredentials);
    }
}
