/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.simple.adapter.impl;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.Protocol;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.google.common.base.CharMatcher;
import com.google.common.io.ByteStreams;
import de.adorsys.datasafe.business.impl.service.DefaultDatasafeServices;
import de.adorsys.datasafe.directory.api.config.DFSConfig;
import de.adorsys.datasafe.directory.impl.profile.config.DefaultDFSConfig;
import de.adorsys.datasafe.encrypiton.api.types.UserID;
import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.encrypiton.api.types.encryption.MutableEncryptionConfig;
import de.adorsys.datasafe.encrypiton.impl.pathencryption.PathEncryptionImplRuntimeDelegatable;
import de.adorsys.datasafe.inbox.api.InboxService;
import de.adorsys.datasafe.privatestore.api.PasswordClearingInputStream;
import de.adorsys.datasafe.privatestore.api.PasswordClearingOutputStream;
import de.adorsys.datasafe.simple.adapter.api.SimpleDatasafeService;
import de.adorsys.datasafe.simple.adapter.api.exceptions.SimpleAdapterException;
import de.adorsys.datasafe.simple.adapter.api.types.AmazonS3DFSCredentials;
import de.adorsys.datasafe.simple.adapter.api.types.DFSCredentials;
import de.adorsys.datasafe.simple.adapter.api.types.DFSCredentialsFactory;
import de.adorsys.datasafe.simple.adapter.api.types.DSDocument;
import de.adorsys.datasafe.simple.adapter.api.types.DSDocumentStream;
import de.adorsys.datasafe.simple.adapter.api.types.DocumentContent;
import de.adorsys.datasafe.simple.adapter.api.types.DocumentDirectoryFQN;
import de.adorsys.datasafe.simple.adapter.api.types.DocumentFQN;
import de.adorsys.datasafe.simple.adapter.api.types.FilesystemDFSCredentials;
import de.adorsys.datasafe.simple.adapter.api.types.ListRecursiveFlag;
import de.adorsys.datasafe.simple.adapter.impl.DaggerSwitchableDatasafeServices;
import de.adorsys.datasafe.simple.adapter.impl.LogStringFrame;
import de.adorsys.datasafe.simple.adapter.impl.SwitchableDatasafeServices;
import de.adorsys.datasafe.simple.adapter.impl.config.PathEncryptionConfig;
import de.adorsys.datasafe.simple.adapter.impl.pathencryption.NoPathEncryptionImpl;
import de.adorsys.datasafe.storage.api.StorageService;
import de.adorsys.datasafe.storage.impl.fs.FileSystemStorageService;
import de.adorsys.datasafe.storage.impl.s3.S3StorageService;
import de.adorsys.datasafe.types.api.actions.ListRequest;
import de.adorsys.datasafe.types.api.actions.ReadRequest;
import de.adorsys.datasafe.types.api.actions.RemoveRequest;
import de.adorsys.datasafe.types.api.actions.WriteRequest;
import de.adorsys.datasafe.types.api.context.BaseOverridesRegistry;
import de.adorsys.datasafe.types.api.context.overrides.OverridesRegistry;
import de.adorsys.datasafe.types.api.resource.AbsoluteLocation;
import de.adorsys.datasafe.types.api.resource.AbsoluteLocationWithCapability;
import de.adorsys.datasafe.types.api.resource.BasePrivateResource;
import de.adorsys.datasafe.types.api.resource.PrivateResource;
import de.adorsys.datasafe.types.api.resource.ResolvedResource;
import de.adorsys.datasafe.types.api.resource.ResourceLocation;
import de.adorsys.datasafe.types.api.resource.StorageCapability;
import de.adorsys.datasafe.types.api.types.ReadKeyPassword;
import de.adorsys.datasafe.types.api.types.ReadStorePassword;
import de.adorsys.datasafe.types.api.utils.ExecutorServiceUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.FileSystems;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleDatasafeServiceImpl
implements SimpleDatasafeService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SimpleDatasafeServiceImpl.class);
    private static final String AMAZON_URL = "https://.*s3.amazonaws.com";
    private static final ReadStorePassword universalReadStorePassword = new ReadStorePassword("secret");
    private static final String S3_PREFIX = "s3://";
    private SystemRootAndStorageService rootAndStorage;
    private DefaultDatasafeServices customlyBuiltDatasafeServices;

    public SimpleDatasafeServiceImpl(PathEncryptionConfig pathEncryptionConfig) {
        this(DFSCredentialsFactory.getFromEnvironmnet(), new MutableEncryptionConfig(), pathEncryptionConfig);
    }

    public SimpleDatasafeServiceImpl() {
        this(DFSCredentialsFactory.getFromEnvironmnet(), new MutableEncryptionConfig(), new PathEncryptionConfig(true));
    }

    public SimpleDatasafeServiceImpl(DFSCredentials dfsCredentials, MutableEncryptionConfig config, PathEncryptionConfig pathEncryptionConfig) {
        if (dfsCredentials instanceof FilesystemDFSCredentials) {
            this.rootAndStorage = SimpleDatasafeServiceImpl.useFileSystem((FilesystemDFSCredentials)dfsCredentials, pathEncryptionConfig);
        }
        if (dfsCredentials instanceof AmazonS3DFSCredentials) {
            this.rootAndStorage = SimpleDatasafeServiceImpl.useAmazonS3((AmazonS3DFSCredentials)dfsCredentials, pathEncryptionConfig);
        }
        SwitchableDatasafeServices.Builder switchableDatasafeService = DaggerSwitchableDatasafeServices.builder().config((DFSConfig)new DefaultDFSConfig(this.rootAndStorage.getSystemRoot(), universalReadStorePassword)).encryption(config.toEncryptionConfig()).storage(this.getStorageService());
        if (!pathEncryptionConfig.getWithPathEncryption().booleanValue()) {
            BaseOverridesRegistry baseOverridesRegistry = new BaseOverridesRegistry();
            PathEncryptionImplRuntimeDelegatable.overrideWith((OverridesRegistry)baseOverridesRegistry, args -> new NoPathEncryptionImpl(args.getSymmetricPathEncryptionService(), args.getPrivateKeyService()));
            switchableDatasafeService.overridesRegistry((OverridesRegistry)baseOverridesRegistry);
        }
        this.customlyBuiltDatasafeServices = switchableDatasafeService.build();
    }

    public StorageService getStorageService() {
        return this.rootAndStorage.getStorageService();
    }

    public void createUser(UserIDAuth userIDAuth) {
        if (this.userExists(userIDAuth.getUserID())) {
            throw new SimpleAdapterException("user \"" + userIDAuth.getUserID().getValue() + "\" already exists");
        }
        this.customlyBuiltDatasafeServices.userProfile().registerUsingDefaults(userIDAuth);
    }

    public void changeKeystorePassword(UserIDAuth userIDAuth, ReadKeyPassword newPassword) {
        this.customlyBuiltDatasafeServices.userProfile().updateReadKeyPassword(userIDAuth, newPassword);
    }

    public void destroyUser(UserIDAuth userIDAuth) {
        this.customlyBuiltDatasafeServices.userProfile().deregister(userIDAuth);
    }

    public boolean userExists(UserID userID) {
        return this.customlyBuiltDatasafeServices.userProfile().userExists(userID);
    }

    public void storeDocument(UserIDAuth userIDAuth, DSDocument dsDocument) {
        try (PasswordClearingOutputStream os = this.customlyBuiltDatasafeServices.privateService().write(WriteRequest.forDefaultPrivate((Object)userIDAuth, (String)dsDocument.getDocumentFQN().getDatasafePath()));){
            os.write(dsDocument.getDocumentContent().getValue());
        }
    }

    public DSDocument readDocument(UserIDAuth userIDAuth, DocumentFQN documentFQN) {
        DocumentContent documentContent;
        try (PasswordClearingInputStream is = this.customlyBuiltDatasafeServices.privateService().read(ReadRequest.forDefaultPrivate((Object)userIDAuth, (String)documentFQN.getDatasafePath()));){
            documentContent = new DocumentContent(ByteStreams.toByteArray((InputStream)is));
        }
        return new DSDocument(documentFQN, documentContent);
    }

    public void storeDocumentStream(UserIDAuth userIDAuth, DSDocumentStream dsDocumentStream) {
        try (PasswordClearingOutputStream os = this.customlyBuiltDatasafeServices.privateService().write(WriteRequest.forDefaultPrivate((Object)userIDAuth, (String)dsDocumentStream.getDocumentFQN().getDatasafePath()));){
            ByteStreams.copy((InputStream)dsDocumentStream.getDocumentStream(), (OutputStream)os);
        }
    }

    public OutputStream storeDocumentStream(UserIDAuth userIDAuth, DocumentFQN documentFQN) {
        return this.customlyBuiltDatasafeServices.privateService().write(WriteRequest.forDefaultPrivate((Object)userIDAuth, (String)documentFQN.getDatasafePath()));
    }

    public DSDocumentStream readDocumentStream(UserIDAuth userIDAuth, DocumentFQN documentFQN) {
        return new DSDocumentStream(documentFQN, (InputStream)this.customlyBuiltDatasafeServices.privateService().read(ReadRequest.forDefaultPrivate((Object)userIDAuth, (String)documentFQN.getDatasafePath())));
    }

    public void deleteDocument(UserIDAuth userIDAuth, DocumentFQN documentFQN) {
        PrivateResource resource = BasePrivateResource.forPrivate((String)documentFQN.getDatasafePath());
        RemoveRequest request = RemoveRequest.forPrivate((Object)userIDAuth, (PrivateResource)resource);
        this.customlyBuiltDatasafeServices.privateService().remove(request);
    }

    public boolean documentExists(UserIDAuth userIDAuth, DocumentFQN documentFQN) {
        return this.customlyBuiltDatasafeServices.privateService().list(ListRequest.forDefaultPrivate((Object)userIDAuth, (String)documentFQN.getDatasafePath())).count() == 1L;
    }

    public void deleteFolder(UserIDAuth userIDAuth, DocumentDirectoryFQN documentDirectoryFQN) {
        this.list(userIDAuth, documentDirectoryFQN, ListRecursiveFlag.TRUE).forEach(file -> {
            PrivateResource resource = BasePrivateResource.forPrivate((String)file.getDatasafePath());
            RemoveRequest request = RemoveRequest.forPrivate((Object)userIDAuth, (PrivateResource)resource);
            this.customlyBuiltDatasafeServices.privateService().remove(request);
        });
    }

    public List<DocumentFQN> list(UserIDAuth userIDAuth, DocumentDirectoryFQN documentDirectoryFQN, ListRecursiveFlag recursiveFlag) {
        List<DocumentFQN> l = this.customlyBuiltDatasafeServices.privateService().list(ListRequest.forDefaultPrivate((Object)userIDAuth, (String)documentDirectoryFQN.getDatasafePath())).map(it -> new DocumentFQN(((ResolvedResource)it.getResource()).asPrivate().decryptedPath().asString())).collect(Collectors.toList());
        if (recursiveFlag.equals((Object)ListRecursiveFlag.TRUE)) {
            return l;
        }
        int numberOfSlashesExpected = 1 + CharMatcher.is((char)'/').countIn((CharSequence)documentDirectoryFQN.getDatasafePath());
        return l.stream().filter(el -> CharMatcher.is((char)'/').countIn((CharSequence)el.getDatasafePath()) == numberOfSlashesExpected).collect(Collectors.toList());
    }

    public InboxService getInboxService() {
        return this.customlyBuiltDatasafeServices.inboxService();
    }

    public void cleanupDb() {
        this.rootAndStorage.getStorageService().list((AbsoluteLocation)new AbsoluteLocationWithCapability((ResourceLocation)BasePrivateResource.forPrivate((URI)this.rootAndStorage.getSystemRoot()), StorageCapability.LIST_RETURNS_DIR)).forEach(arg_0 -> ((StorageService)this.rootAndStorage.getStorageService()).remove(arg_0));
    }

    private static SystemRootAndStorageService useAmazonS3(AmazonS3DFSCredentials dfsCredentials, PathEncryptionConfig pathEncryptionConfig) {
        AmazonS3 amazons3;
        int requestTimeout;
        AmazonS3DFSCredentials amazonS3DFSCredentials = dfsCredentials;
        LogStringFrame lsf = new LogStringFrame();
        lsf.add("AMAZON S3");
        lsf.add("root bucket        : " + amazonS3DFSCredentials.getRootBucket());
        lsf.add("url                : " + amazonS3DFSCredentials.getUrl());
        lsf.add("region             : " + amazonS3DFSCredentials.getRegion());
        lsf.add("path encryption    : " + pathEncryptionConfig.getWithPathEncryption());
        lsf.add("no https           : " + amazonS3DFSCredentials.isNoHttps());
        lsf.add("threadpool size    : " + amazonS3DFSCredentials.getThreadPoolSize());
        int maxConnections = amazonS3DFSCredentials.getMaxConnections();
        if (maxConnections > 0) {
            lsf.add("max connections    : " + maxConnections);
        }
        if ((requestTimeout = amazonS3DFSCredentials.getRequestTimeout()) > 0) {
            lsf.add("request timeout    : " + requestTimeout);
        }
        log.info(lsf.toString());
        AmazonS3ClientBuilder amazonS3ClientBuilder = (AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(amazonS3DFSCredentials.getAccessKey(), amazonS3DFSCredentials.getSecretKey())));
        boolean useEndpoint = !amazonS3DFSCredentials.getUrl().matches(AMAZON_URL) && !amazonS3DFSCredentials.getUrl().startsWith(S3_PREFIX);
        lsf = new LogStringFrame();
        if (useEndpoint) {
            lsf.add("not real amazon, so use pathStyleAccess");
            AwsClientBuilder.EndpointConfiguration endpoint = new AwsClientBuilder.EndpointConfiguration(amazonS3DFSCredentials.getUrl(), amazonS3DFSCredentials.getRegion());
            ((AmazonS3ClientBuilder)amazonS3ClientBuilder.withEndpointConfiguration(endpoint)).enablePathStyleAccess();
        } else {
            lsf.add("real amazon, so use bucketStyleAccess");
            amazonS3ClientBuilder.withRegion(amazonS3DFSCredentials.getRegion());
        }
        log.info("{}", (Object)lsf.toString());
        if (amazonS3DFSCredentials.isNoHttps() || maxConnections > 0 || requestTimeout > 0) {
            ClientConfiguration clientConfig = new ClientConfiguration();
            if (amazonS3DFSCredentials.isNoHttps()) {
                log.info("Creating S3 client without https");
                clientConfig.setProtocol(Protocol.HTTP);
                clientConfig.disableSocketProxy();
            }
            if (maxConnections > 0) {
                log.info("Creating S3 client with max connections:{}", (Object)maxConnections);
                clientConfig.setMaxConnections(maxConnections);
            }
            if (requestTimeout > 0) {
                log.info("Creating S3 client with connection timeout:{}", (Object)requestTimeout);
                clientConfig.setRequestTimeout(requestTimeout);
            }
            amazonS3ClientBuilder.withClientConfiguration(clientConfig);
        }
        if (!(amazons3 = (AmazonS3)amazonS3ClientBuilder.build()).doesBucketExistV2(amazonS3DFSCredentials.getContainer())) {
            amazons3.createBucket(amazonS3DFSCredentials.getContainer());
        }
        S3StorageService storageService = new S3StorageService(amazons3, amazonS3DFSCredentials.getContainer(), ExecutorServiceUtil.submitterExecutesOnStarvationExecutingService((int)amazonS3DFSCredentials.getThreadPoolSize(), (int)amazonS3DFSCredentials.getQueueSize()));
        URI systemRoot = URI.create(S3_PREFIX + amazonS3DFSCredentials.getRootBucket());
        log.info("build DFS to S3 with root " + amazonS3DFSCredentials.getRootBucket() + " and url " + amazonS3DFSCredentials.getUrl());
        return new SystemRootAndStorageService(systemRoot, (StorageService)storageService);
    }

    private static SystemRootAndStorageService useFileSystem(FilesystemDFSCredentials dfsCredentials, PathEncryptionConfig pathEncryptionConfig) {
        FilesystemDFSCredentials filesystemDFSCredentials = dfsCredentials;
        LogStringFrame lsf = new LogStringFrame();
        lsf.add("FILESYSTEM");
        lsf.add("root bucket     : " + filesystemDFSCredentials.getRoot());
        lsf.add("path encryption : " + pathEncryptionConfig.getWithPathEncryption());
        log.info(lsf.toString());
        URI systemRoot = FileSystems.getDefault().getPath(filesystemDFSCredentials.getRoot(), new String[0]).toAbsolutePath().toUri();
        FileSystemStorageService storageService = new FileSystemStorageService(FileSystems.getDefault().getPath(filesystemDFSCredentials.getRoot(), new String[0]));
        log.info("build DFS to FILESYSTEM with root " + filesystemDFSCredentials.getRoot());
        return new SystemRootAndStorageService(systemRoot, (StorageService)storageService);
    }

    private static class SystemRootAndStorageService {
        private final URI systemRoot;
        private final StorageService storageService;

        @Generated
        public SystemRootAndStorageService(URI systemRoot, StorageService storageService) {
            this.systemRoot = systemRoot;
            this.storageService = storageService;
        }

        @Generated
        public URI getSystemRoot() {
            return this.systemRoot;
        }

        @Generated
        public StorageService getStorageService() {
            return this.storageService;
        }
    }
}

