/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.simple.adapter.impl;

import de.adorsys.datasafe.encrypiton.api.types.UserID;
import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.simple.adapter.api.types.AmazonS3DFSCredentials;
import de.adorsys.datasafe.simple.adapter.api.types.DFSCredentials;
import de.adorsys.datasafe.simple.adapter.api.types.DFSCredentialsFactory;
import de.adorsys.datasafe.simple.adapter.api.types.DSDocument;
import de.adorsys.datasafe.simple.adapter.api.types.DocumentContent;
import de.adorsys.datasafe.simple.adapter.api.types.DocumentFQN;
import de.adorsys.datasafe.simple.adapter.api.types.FilesystemDFSCredentials;
import de.adorsys.datasafe.simple.adapter.impl.SimpleDatasafeServiceImpl;
import de.adorsys.datasafe.simple.adapter.impl.config.PathEncryptionConfig;
import de.adorsys.datasafe.types.api.resource.AbsoluteLocation;
import de.adorsys.datasafe.types.api.resource.BasePrivateResource;
import de.adorsys.datasafe.types.api.resource.PrivateResource;
import de.adorsys.datasafe.types.api.resource.ResourceLocation;
import de.adorsys.datasafe.types.api.shared.BaseMockitoTest;
import de.adorsys.datasafe.types.api.utils.ReadKeyPasswordTestFactory;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.Generated;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.shaded.org.apache.commons.io.IOUtils;

class SimpleAdapterFeatureTest
extends BaseMockitoTest {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SimpleAdapterFeatureTest.class);
    private UserIDAuth userIDAuth = new UserIDAuth(new UserID("peter"), ReadKeyPasswordTestFactory.getForString((String)"password"));
    private String content = "content of document";
    private String path = "a/b/c.txt";
    private DSDocument document = new DSDocument(new DocumentFQN(this.path), new DocumentContent(this.content.getBytes()));

    SimpleAdapterFeatureTest() {
    }

    @BeforeEach
    @AfterEach
    void afterEach() {
        System.setProperty("SC-NO-CMSENCRYPTION-AT-ALL", Boolean.FALSE.toString());
    }

    @Test
    void testWithEncryption() {
        SimpleDatasafeServiceImpl simpleDatasafeService = new SimpleDatasafeServiceImpl();
        simpleDatasafeService.createUser(this.userIDAuth);
        simpleDatasafeService.storeDocument(this.userIDAuth, this.document);
        AbsoluteLocation<PrivateResource> rootLocation = this.getPrivateResourceAbsoluteLocation();
        try (Stream stream = simpleDatasafeService.getStorageService().list(rootLocation);){
            Assertions.assertEquals((long)0L, (long)stream.filter(el -> el.location().toASCIIString().contains(this.path)).count());
        }
        simpleDatasafeService.destroyUser(this.userIDAuth);
    }

    @Test
    void testWithoutPathEncryption() {
        SimpleDatasafeServiceImpl simpleDatasafeService = new SimpleDatasafeServiceImpl(new PathEncryptionConfig(Boolean.valueOf(false)));
        simpleDatasafeService.createUser(this.userIDAuth);
        simpleDatasafeService.storeDocument(this.userIDAuth, this.document);
        AbsoluteLocation<PrivateResource> rootLocation = this.getPrivateResourceAbsoluteLocation();
        try (Stream<AbsoluteLocation> absoluteLocationStream = simpleDatasafeService.getStorageService().list(rootLocation).filter(el -> el.location().toASCIIString().contains(this.path));){
            Assertions.assertEquals((long)1L, (long)absoluteLocationStream.count());
        }
        absoluteLocationStream = simpleDatasafeService.getStorageService().list(rootLocation).filter(el -> el.location().toASCIIString().contains(this.path));
        try {
            Optional<AbsoluteLocation> first = absoluteLocationStream.findFirst();
            try (InputStream read = simpleDatasafeService.getStorageService().read(first.get());){
                StringWriter writer = new StringWriter();
                IOUtils.copy((InputStream)read, (Writer)writer, (Charset)StandardCharsets.UTF_8);
                Assert.assertFalse((boolean)writer.toString().equals(this.content));
            }
        }
        finally {
            if (absoluteLocationStream != null) {
                absoluteLocationStream.close();
            }
        }
        simpleDatasafeService.destroyUser(this.userIDAuth);
    }

    @Test
    void testWithoutEncryption() {
        System.setProperty("SC-NO-CMSENCRYPTION-AT-ALL", Boolean.TRUE.toString());
        SimpleDatasafeServiceImpl simpleDatasafeService = new SimpleDatasafeServiceImpl(new PathEncryptionConfig(Boolean.valueOf(false)));
        simpleDatasafeService.createUser(this.userIDAuth);
        simpleDatasafeService.storeDocument(this.userIDAuth, this.document);
        AbsoluteLocation<PrivateResource> rootLocation = this.getPrivateResourceAbsoluteLocation();
        try (Stream<AbsoluteLocation> absoluteLocationStream = simpleDatasafeService.getStorageService().list(rootLocation).filter(el -> el.location().toASCIIString().contains(this.path));){
            Assertions.assertEquals((long)1L, (long)absoluteLocationStream.count());
        }
        absoluteLocationStream = simpleDatasafeService.getStorageService().list(rootLocation).filter(el -> el.location().toASCIIString().contains(this.path));
        try {
            Optional<AbsoluteLocation> first = absoluteLocationStream.findFirst();
            try (InputStream read = simpleDatasafeService.getStorageService().read(first.get());){
                StringWriter writer = new StringWriter();
                IOUtils.copy((InputStream)read, (Writer)writer, (Charset)StandardCharsets.UTF_8);
                Assert.assertTrue((boolean)writer.toString().equals(this.content));
            }
        }
        finally {
            if (absoluteLocationStream != null) {
                absoluteLocationStream.close();
            }
        }
        simpleDatasafeService.destroyUser(this.userIDAuth);
    }

    @Nullable
    private AbsoluteLocation<PrivateResource> getPrivateResourceAbsoluteLocation() {
        DFSCredentials credentials = DFSCredentialsFactory.getFromEnvironmnet();
        AbsoluteLocation rootLocation = null;
        if (credentials instanceof FilesystemDFSCredentials) {
            String root = ((FilesystemDFSCredentials)credentials).getRoot();
            Path listpath = FileSystems.getDefault().getPath(root, new String[0]);
            rootLocation = new AbsoluteLocation((ResourceLocation)BasePrivateResource.forPrivate((URI)listpath.toUri()));
        }
        if (credentials instanceof AmazonS3DFSCredentials) {
            String string = ((AmazonS3DFSCredentials)credentials).getRootBucket();
        }
        return rootLocation;
    }
}

