/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.simple.adapter.impl;

import de.adorsys.datasafe.encrypiton.api.types.UserID;
import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.encrypiton.api.types.encryption.MutableEncryptionConfig;
import de.adorsys.datasafe.simple.adapter.api.SimpleDatasafeService;
import de.adorsys.datasafe.simple.adapter.api.types.DFSCredentials;
import de.adorsys.datasafe.simple.adapter.api.types.DSDocument;
import de.adorsys.datasafe.simple.adapter.api.types.DocumentContent;
import de.adorsys.datasafe.simple.adapter.api.types.DocumentFQN;
import de.adorsys.datasafe.simple.adapter.impl.InitFromStorageProvider;
import de.adorsys.datasafe.simple.adapter.impl.SimpleDatasafeServiceImpl;
import de.adorsys.datasafe.simple.adapter.impl.config.PathEncryptionConfig;
import de.adorsys.datasafe.storage.api.StorageService;
import de.adorsys.datasafe.teststorage.WithStorageProvider;
import de.adorsys.datasafe.types.api.resource.BasePrivateResource;
import de.adorsys.datasafe.types.api.resource.Uri;
import de.adorsys.datasafe.types.api.utils.ReadKeyPasswordTestFactory;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class DFSRelativeToRootProfileTest
extends WithStorageProvider {
    private SimpleDatasafeService simpleDatasafeService;
    private UserIDAuth userIDAuth;
    private PathEncryptionConfig pathEncryptionConfig = new PathEncryptionConfig(Boolean.valueOf(true));

    DFSRelativeToRootProfileTest() {
    }

    void createDatasafeAdapter(WithStorageProvider.StorageDescriptor descriptor) {
        DFSCredentials credentials = InitFromStorageProvider.dfsFromDescriptor(descriptor);
        this.simpleDatasafeService = null != credentials ? new SimpleDatasafeServiceImpl(credentials, new MutableEncryptionConfig(), this.pathEncryptionConfig) : new SimpleDatasafeServiceImpl();
        this.userIDAuth = new UserIDAuth(new UserID("peter"), ReadKeyPasswordTestFactory.getForString((String)"password"));
        this.simpleDatasafeService.createUser(this.userIDAuth);
    }

    @ParameterizedTest
    @MethodSource(value={"allDefaultStorages"})
    void createWriteAndDeleteUserCleansAllNeeded(WithStorageProvider.StorageDescriptor descriptor) {
        this.createDatasafeAdapter(descriptor);
        DSDocument document = new DSDocument(new DocumentFQN("c.txt"), new DocumentContent("Hello".getBytes()));
        this.simpleDatasafeService.storeDocument(this.userIDAuth, document);
        this.simpleDatasafeService.destroyUser(this.userIDAuth);
        try (Stream ls = ((StorageService)descriptor.getStorageService().get()).list(BasePrivateResource.forAbsolutePrivate((Uri)descriptor.getLocation()));){
            Assertions.assertThat((Stream)ls).isEmpty();
        }
    }
}

