/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.simple.adapter.impl;

import de.adorsys.datasafe.simple.adapter.api.types.AmazonS3DFSCredentials;
import de.adorsys.datasafe.simple.adapter.api.types.DFSCredentials;
import de.adorsys.datasafe.simple.adapter.api.types.DFSCredentialsFactory;
import de.adorsys.datasafe.simple.adapter.api.types.FilesystemDFSCredentials;
import java.util.Properties;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class DFSCredentialsFactoryTest {
    String amazonBeforeTest;
    String fsBeforeTest;

    @BeforeEach
    public void before() {
        String amazonBeforeTest = System.getProperty("SC-AMAZONS3");
        String fsBeforeTest = System.getProperty("SC-FILESYSTEM");
        Properties sysProps = System.getProperties();
        sysProps.remove("SC-AMAZONS3");
        sysProps.remove("SC-FILESYSTEM");
    }

    @AfterEach
    public void after() {
        if (this.amazonBeforeTest == null) {
            System.getProperties().remove("SC-AMAZONS3");
        } else {
            System.setProperty("SC-AMAZONS3", this.amazonBeforeTest);
        }
        if (this.fsBeforeTest == null) {
            System.getProperties().remove("SC-FILESYSTEM");
        } else {
            System.setProperty("SC-FILESYSTEM", this.fsBeforeTest);
        }
    }

    @Test
    public void forFileSystem() {
        DFSCredentials dfsCredentials = DFSCredentialsFactory.getFromEnvironmnet();
        Assertions.assertTrue((boolean)(dfsCredentials instanceof FilesystemDFSCredentials));
        String defaultPath = "affe/1/2/3";
        System.setProperty("SC-FILESYSTEM", defaultPath);
        dfsCredentials = DFSCredentialsFactory.getFromEnvironmnet();
        Assertions.assertTrue((boolean)(dfsCredentials instanceof FilesystemDFSCredentials));
        FilesystemDFSCredentials filesystemDFSCredentials = (FilesystemDFSCredentials)dfsCredentials;
        Assertions.assertTrue((boolean)filesystemDFSCredentials.getRoot().toString().endsWith(defaultPath));
    }

    @Test
    public void forAmazon() {
        String uri = "http://go.here";
        String accessKey = "accesskey";
        String secretKey = "secretKey";
        String region = "region";
        String bucket = "/root/bucket/a";
        System.setProperty("SC-AMAZONS3", uri + "," + accessKey + "," + secretKey + "," + region + "," + bucket);
        DFSCredentials dfsCredentials = DFSCredentialsFactory.getFromEnvironmnet();
        Assertions.assertTrue((boolean)(dfsCredentials instanceof AmazonS3DFSCredentials));
        AmazonS3DFSCredentials amazonS3DFSCredentials = (AmazonS3DFSCredentials)dfsCredentials;
        Assertions.assertEquals((Object)accessKey, (Object)amazonS3DFSCredentials.getAccessKey());
        Assertions.assertEquals((Object)secretKey, (Object)amazonS3DFSCredentials.getSecretKey());
        Assertions.assertEquals((Object)bucket, (Object)amazonS3DFSCredentials.getRootBucket());
        Assertions.assertEquals((Object)region, (Object)amazonS3DFSCredentials.getRegion());
        Assertions.assertEquals((Object)uri, (Object)amazonS3DFSCredentials.getUrl());
    }
}

