/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.simple.adapter.impl;

import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.encrypiton.api.types.encryption.MutableEncryptionConfig;
import de.adorsys.datasafe.simple.adapter.api.SimpleDatasafeService;
import de.adorsys.datasafe.simple.adapter.api.types.DFSCredentials;
import de.adorsys.datasafe.simple.adapter.api.types.DSDocument;
import de.adorsys.datasafe.simple.adapter.api.types.DocumentContent;
import de.adorsys.datasafe.simple.adapter.api.types.DocumentFQN;
import de.adorsys.datasafe.simple.adapter.impl.InitFromStorageProvider;
import de.adorsys.datasafe.simple.adapter.impl.SimpleDatasafeServiceImpl;
import de.adorsys.datasafe.storage.api.StorageService;
import de.adorsys.datasafe.teststorage.WithStorageProvider;
import de.adorsys.datasafe.types.api.resource.BasePrivateResource;
import de.adorsys.datasafe.types.api.resource.Uri;
import de.adorsys.datasafe.types.api.utils.ReadKeyPasswordTestFactory;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class CleanupDbTest
extends WithStorageProvider {
    private SimpleDatasafeService simpleDatasafeService;
    private DFSCredentials dfsCredentials;

    CleanupDbTest() {
    }

    private void createSimpleService(WithStorageProvider.StorageDescriptor descriptor) {
        this.dfsCredentials = InitFromStorageProvider.dfsFromDescriptor(descriptor);
        this.simpleDatasafeService = this.dfsCredentials != null ? new SimpleDatasafeServiceImpl(this.dfsCredentials, new MutableEncryptionConfig()) : new SimpleDatasafeServiceImpl();
    }

    @ParameterizedTest
    @MethodSource(value={"allDefaultStorages"})
    void cleanupDb(WithStorageProvider.StorageDescriptor descriptor) {
        this.createSimpleService(descriptor);
        String content = "content of document";
        String path = "a/b/c.txt";
        UserIDAuth user1 = new UserIDAuth("uzr", ReadKeyPasswordTestFactory.getForString((String)"user"));
        UserIDAuth user2 = new UserIDAuth("other", ReadKeyPasswordTestFactory.getForString((String)"user"));
        this.simpleDatasafeService.createUser(user1);
        this.simpleDatasafeService.createUser(user2);
        this.simpleDatasafeService.storeDocument(user1, new DSDocument(new DocumentFQN(path), new DocumentContent(content.getBytes())));
        this.simpleDatasafeService.storeDocument(user2, new DSDocument(new DocumentFQN(path), new DocumentContent(content.getBytes())));
        try (Stream ls = ((StorageService)descriptor.getStorageService().get()).list(BasePrivateResource.forAbsolutePrivate((Uri)descriptor.getLocation()));){
            Assertions.assertThat((Stream)ls).hasSize(6);
        }
        this.simpleDatasafeService.cleanupDb();
        ls = ((StorageService)descriptor.getStorageService().get()).list(BasePrivateResource.forAbsolutePrivate((Uri)descriptor.getLocation()));
        var7_7 = null;
        try {
            Assertions.assertThat((Stream)ls).isEmpty();
        }
        catch (Throwable throwable) {
            var7_7 = throwable;
            throw throwable;
        }
        finally {
            if (ls != null) {
                if (var7_7 != null) {
                    try {
                        ls.close();
                    }
                    catch (Throwable throwable) {
                        var7_7.addSuppressed(throwable);
                    }
                } else {
                    ls.close();
                }
            }
        }
    }
}

