package de.adorsys.datasafe.simple.adapter.impl;

import dagger.internal.DelegateFactory;
import dagger.internal.DoubleCheck;
import dagger.internal.InstanceFactory;
import dagger.internal.Preconditions;
import de.adorsys.datasafe.business.impl.directory.DefaultKeystoreCacheModule_KeyStoreCacheFactory;
import de.adorsys.datasafe.business.impl.keystore.DefaultKeyStoreModule_JugglerFactory;
import de.adorsys.datasafe.business.impl.keystore.DefaultKeyStoreModule_KeyStoreConfigFactory;
import de.adorsys.datasafe.directory.api.config.DFSConfig;
import de.adorsys.datasafe.directory.api.profile.operations.ProfileOperations;
import de.adorsys.datasafe.directory.impl.profile.dfs.BucketAccessServiceImplRuntimeDelegatable;
import de.adorsys.datasafe.directory.impl.profile.dfs.BucketAccessServiceImplRuntimeDelegatable_Factory;
import de.adorsys.datasafe.directory.impl.profile.keys.DFSPrivateKeyServiceImplRuntimeDelegatable;
import de.adorsys.datasafe.directory.impl.profile.keys.DFSPublicKeyServiceImplRuntimeDelegatable;
import de.adorsys.datasafe.directory.impl.profile.keys.DocumentKeyStoreOperationsImplRuntimeDelegatable;
import de.adorsys.datasafe.directory.impl.profile.keys.GenericKeystoreOperations;
import de.adorsys.datasafe.directory.impl.profile.keys.GenericKeystoreOperations_Factory;
import de.adorsys.datasafe.directory.impl.profile.keys.KeyStoreCache;
import de.adorsys.datasafe.directory.impl.profile.keys.StorageKeyStoreOperationsImplRuntimeDelegatable;
import de.adorsys.datasafe.directory.impl.profile.keys.StorageKeyStoreOperationsImplRuntimeDelegatable_Factory;
import de.adorsys.datasafe.directory.impl.profile.operations.DFSBasedProfileStorageImplRuntimeDelegatable;
import de.adorsys.datasafe.directory.impl.profile.operations.actions.ProfileStorageCredentialsServiceImplRuntimeDelegatable;
import de.adorsys.datasafe.directory.impl.profile.resource.ResourceResolverImplRuntimeDelegatable;
import de.adorsys.datasafe.directory.impl.profile.serde.GsonSerde;
import de.adorsys.datasafe.directory.impl.profile.serde.GsonSerde_Factory;
import de.adorsys.datasafe.encrypiton.api.types.encryption.CmsEncryptionConfig;
import de.adorsys.datasafe.encrypiton.api.types.encryption.EncryptionConfig;
import de.adorsys.datasafe.encrypiton.api.types.encryption.KeyCreationConfig;
import de.adorsys.datasafe.encrypiton.impl.cmsencryption.ASNCmsEncryptionConfig;
import de.adorsys.datasafe.encrypiton.impl.document.CMSDocumentReadServiceRuntimeDelegatable;
import de.adorsys.datasafe.encrypiton.impl.document.CMSDocumentWriteServiceRuntimeDelegatable;
import de.adorsys.datasafe.encrypiton.impl.keystore.KeyStoreServiceImplRuntimeDelegatable;
import de.adorsys.datasafe.encrypiton.impl.keystore.KeyStoreServiceImplRuntimeDelegatable_Factory;
import de.adorsys.datasafe.encrypiton.impl.keystore.PublicKeySerdeImplRuntimeDelegatable;
import de.adorsys.datasafe.encrypiton.impl.keystore.PublicKeySerdeImplRuntimeDelegatable_Factory;
import de.adorsys.datasafe.encrypiton.impl.pathencryption.IntegrityPreservingUriEncryptionRuntimeDelegatable;
import de.adorsys.datasafe.encrypiton.impl.pathencryption.PathSegmentEncryptorDecryptorRuntimeDelegatable;
import de.adorsys.datasafe.inbox.api.InboxService;
import de.adorsys.datasafe.inbox.impl.InboxServiceImplRuntimeDelegatable;
import de.adorsys.datasafe.inbox.impl.actions.ListInboxImplRuntimeDelegatable;
import de.adorsys.datasafe.inbox.impl.actions.ReadFromInboxImplRuntimeDelegatable;
import de.adorsys.datasafe.inbox.impl.actions.RemoveFromInboxImplRuntimeDelegatable;
import de.adorsys.datasafe.inbox.impl.actions.WriteToInboxImplRuntimeDelegatable;
import de.adorsys.datasafe.privatestore.api.PrivateSpaceService;
import de.adorsys.datasafe.privatestore.impl.PrivateSpaceServiceImplRuntimeDelegatable;
import de.adorsys.datasafe.privatestore.impl.actions.EncryptedResourceResolverImplRuntimeDelegatable;
import de.adorsys.datasafe.privatestore.impl.actions.ListPrivateImplRuntimeDelegatable;
import de.adorsys.datasafe.privatestore.impl.actions.ReadFromPrivateImplRuntimeDelegatable;
import de.adorsys.datasafe.privatestore.impl.actions.RemoveFromPrivateImplRuntimeDelegatable;
import de.adorsys.datasafe.privatestore.impl.actions.WriteToPrivateImplRuntimeDelegatable;
import de.adorsys.datasafe.simple.adapter.impl.cmsencryption.SwitchableCMSEncryptionModule_CmsEncryptionConfigFactory;
import de.adorsys.datasafe.simple.adapter.impl.cmsencryption.SwitchableCmsEncryptionImpl;
import de.adorsys.datasafe.simple.adapter.impl.pathencryption.SwitchablePathEncryptionImpl;
import de.adorsys.datasafe.simple.adapter.impl.pathencryption.SwitchablePathEncryptionModule_SivModeFactory;
import de.adorsys.datasafe.simple.adapter.impl.profile.DFSRelativeProfileRegistrationServiceImpl;
import de.adorsys.datasafe.simple.adapter.impl.profile.DFSRelativeProfileRemovalServiceImpl;
import de.adorsys.datasafe.simple.adapter.impl.profile.DFSRelativeProfileRetrievalServiceImpl;
import de.adorsys.datasafe.simple.adapter.impl.profile.DFSRelativeProfileRetrievalServiceImpl_Factory;
import de.adorsys.datasafe.simple.adapter.impl.profile.DFSRelativeProfileUpdatingServiceImpl;
import de.adorsys.datasafe.simple.adapter.impl.profile.HardcodedProfileModule_CmsEncryptionConfigFactory;
import de.adorsys.datasafe.storage.api.StorageService;
import de.adorsys.datasafe.types.api.context.overrides.OverridesRegistry;
import de.adorsys.keymanagement.api.Juggler;
import de.adorsys.keymanagement.api.config.keystore.KeyStoreConfig;
import javax.annotation.Generated;
import javax.inject.Provider;

@Generated(
    value = "dagger.internal.codegen.ComponentProcessor",
    comments = "https://dagger.dev"
)
@SuppressWarnings({
    "unchecked",
    "rawtypes"
})
public final class DaggerSwitchableDatasafeServices implements SwitchableDatasafeServices {
  private final OverridesRegistry overridesRegistry;

  private final DFSConfig config;

  private final StorageService storage;

  private final EncryptionConfig encryption;

  private Provider<OverridesRegistry> overridesRegistryProvider;

  private Provider<PublicKeySerdeImplRuntimeDelegatable> publicKeySerdeImplRuntimeDelegatableProvider;

  private Provider<GsonSerde> gsonSerdeProvider;

  private Provider<EncryptionConfig> encryptionProvider;

  private Provider<KeyStoreConfig> keyStoreConfigProvider;

  private Provider<Juggler> jugglerProvider;

  private Provider<KeyStoreServiceImplRuntimeDelegatable> keyStoreServiceImplRuntimeDelegatableProvider;

  private Provider<KeyCreationConfig> cmsEncryptionConfigProvider;

  private Provider<DFSConfig> configProvider;

  private Provider<StorageService> storageProvider;

  private Provider<KeyStoreCache> keyStoreCacheProvider;

  private Provider<GenericKeystoreOperations> genericKeystoreOperationsProvider;

  private Provider<StorageKeyStoreOperationsImplRuntimeDelegatable> storageKeyStoreOperationsImplRuntimeDelegatableProvider;

  private Provider<BucketAccessServiceImplRuntimeDelegatable> bucketAccessServiceImplRuntimeDelegatableProvider;

  private Provider<DFSRelativeProfileRetrievalServiceImpl> dFSRelativeProfileRetrievalServiceImplProvider;

  private DaggerSwitchableDatasafeServices(DFSConfig configParam, StorageService storageParam,
      OverridesRegistry overridesRegistryParam, EncryptionConfig encryptionParam) {
    this.overridesRegistry = overridesRegistryParam;
    this.config = configParam;
    this.storage = storageParam;
    this.encryption = encryptionParam;
    initialize(configParam, storageParam, overridesRegistryParam, encryptionParam);
  }

  public static SwitchableDatasafeServices.Builder builder() {
    return new Builder();
  }

  private BucketAccessServiceImplRuntimeDelegatable getBucketAccessServiceImplRuntimeDelegatable() {
    return new BucketAccessServiceImplRuntimeDelegatable(overridesRegistry, DoubleCheck.lazy((Provider) storageKeyStoreOperationsImplRuntimeDelegatableProvider));}

  private DFSRelativeProfileRetrievalServiceImpl getDFSRelativeProfileRetrievalServiceImpl() {
    return new DFSRelativeProfileRetrievalServiceImpl(config, storage, getBucketAccessServiceImplRuntimeDelegatable());}

  private ResourceResolverImplRuntimeDelegatable getResourceResolverImplRuntimeDelegatable() {
    return new ResourceResolverImplRuntimeDelegatable(overridesRegistry, getDFSRelativeProfileRetrievalServiceImpl(), getBucketAccessServiceImplRuntimeDelegatable());}

  private PathSegmentEncryptorDecryptorRuntimeDelegatable getPathSegmentEncryptorDecryptorRuntimeDelegatable(
      ) {
    return new PathSegmentEncryptorDecryptorRuntimeDelegatable(overridesRegistry, SwitchablePathEncryptionModule_SivModeFactory.sivMode());}

  private IntegrityPreservingUriEncryptionRuntimeDelegatable getIntegrityPreservingUriEncryptionRuntimeDelegatable(
      ) {
    return new IntegrityPreservingUriEncryptionRuntimeDelegatable(overridesRegistry, getPathSegmentEncryptorDecryptorRuntimeDelegatable());}

  private KeyCreationConfig getKeyCreationConfig() {
    return HardcodedProfileModule_CmsEncryptionConfigFactory.cmsEncryptionConfig(encryption);}

  private KeyStoreConfig getKeyStoreConfig() {
    return DefaultKeyStoreModule_KeyStoreConfigFactory.keyStoreConfig(encryption);}

  private Juggler getJuggler() {
    return DefaultKeyStoreModule_JugglerFactory.juggler(getKeyStoreConfig());}

  private KeyStoreServiceImplRuntimeDelegatable getKeyStoreServiceImplRuntimeDelegatable() {
    return new KeyStoreServiceImplRuntimeDelegatable(overridesRegistry, getKeyStoreConfig(), getJuggler());}

  private GenericKeystoreOperations getGenericKeystoreOperations() {
    return new GenericKeystoreOperations(getKeyCreationConfig(), config, storage, storage, keyStoreCacheProvider.get(), getKeyStoreServiceImplRuntimeDelegatable());}

  private DocumentKeyStoreOperationsImplRuntimeDelegatable getDocumentKeyStoreOperationsImplRuntimeDelegatable(
      ) {
    return new DocumentKeyStoreOperationsImplRuntimeDelegatable(overridesRegistry, getKeyCreationConfig(), getGenericKeystoreOperations(), config, getBucketAccessServiceImplRuntimeDelegatable(), getDFSRelativeProfileRetrievalServiceImpl(), storage, keyStoreCacheProvider.get(), getKeyStoreServiceImplRuntimeDelegatable());}

  private DFSPrivateKeyServiceImplRuntimeDelegatable getDFSPrivateKeyServiceImplRuntimeDelegatable(
      ) {
    return new DFSPrivateKeyServiceImplRuntimeDelegatable(overridesRegistry, getDocumentKeyStoreOperationsImplRuntimeDelegatable());}

  private SwitchablePathEncryptionImpl getSwitchablePathEncryptionImpl() {
    return new SwitchablePathEncryptionImpl(getIntegrityPreservingUriEncryptionRuntimeDelegatable(), getDFSPrivateKeyServiceImplRuntimeDelegatable());}

  private EncryptedResourceResolverImplRuntimeDelegatable getEncryptedResourceResolverImplRuntimeDelegatable(
      ) {
    return new EncryptedResourceResolverImplRuntimeDelegatable(overridesRegistry, getBucketAccessServiceImplRuntimeDelegatable(), getResourceResolverImplRuntimeDelegatable(), getSwitchablePathEncryptionImpl());}

  private ListPrivateImplRuntimeDelegatable getListPrivateImplRuntimeDelegatable() {
    return new ListPrivateImplRuntimeDelegatable(overridesRegistry, getEncryptedResourceResolverImplRuntimeDelegatable(), storage);}

  private CmsEncryptionConfig getCmsEncryptionConfig() {
    return SwitchableCMSEncryptionModule_CmsEncryptionConfigFactory.cmsEncryptionConfig(encryption);}

  private ASNCmsEncryptionConfig getASNCmsEncryptionConfig() {
    return new ASNCmsEncryptionConfig(getCmsEncryptionConfig());}

  private SwitchableCmsEncryptionImpl getSwitchableCmsEncryptionImpl() {
    return new SwitchableCmsEncryptionImpl(getASNCmsEncryptionConfig());}

  private CMSDocumentReadServiceRuntimeDelegatable getCMSDocumentReadServiceRuntimeDelegatable() {
    return new CMSDocumentReadServiceRuntimeDelegatable(overridesRegistry, storage, getDFSPrivateKeyServiceImplRuntimeDelegatable(), getSwitchableCmsEncryptionImpl());}

  private ReadFromPrivateImplRuntimeDelegatable getReadFromPrivateImplRuntimeDelegatable() {
    return new ReadFromPrivateImplRuntimeDelegatable(overridesRegistry, getEncryptedResourceResolverImplRuntimeDelegatable(), getCMSDocumentReadServiceRuntimeDelegatable());}

  private CMSDocumentWriteServiceRuntimeDelegatable getCMSDocumentWriteServiceRuntimeDelegatable() {
    return new CMSDocumentWriteServiceRuntimeDelegatable(overridesRegistry, storage, getSwitchableCmsEncryptionImpl());}

  private WriteToPrivateImplRuntimeDelegatable getWriteToPrivateImplRuntimeDelegatable() {
    return new WriteToPrivateImplRuntimeDelegatable(overridesRegistry, getDFSPrivateKeyServiceImplRuntimeDelegatable(), getEncryptedResourceResolverImplRuntimeDelegatable(), getCMSDocumentWriteServiceRuntimeDelegatable());}

  private RemoveFromPrivateImplRuntimeDelegatable getRemoveFromPrivateImplRuntimeDelegatable() {
    return new RemoveFromPrivateImplRuntimeDelegatable(overridesRegistry, getEncryptedResourceResolverImplRuntimeDelegatable(), storage);}

  private PrivateSpaceServiceImplRuntimeDelegatable getPrivateSpaceServiceImplRuntimeDelegatable() {
    return new PrivateSpaceServiceImplRuntimeDelegatable(overridesRegistry, getListPrivateImplRuntimeDelegatable(), getReadFromPrivateImplRuntimeDelegatable(), getWriteToPrivateImplRuntimeDelegatable(), getRemoveFromPrivateImplRuntimeDelegatable());}

  private ListInboxImplRuntimeDelegatable getListInboxImplRuntimeDelegatable() {
    return new ListInboxImplRuntimeDelegatable(overridesRegistry, getDFSPrivateKeyServiceImplRuntimeDelegatable(), getDFSRelativeProfileRetrievalServiceImpl(), getResourceResolverImplRuntimeDelegatable(), storage);}

  private ReadFromInboxImplRuntimeDelegatable getReadFromInboxImplRuntimeDelegatable() {
    return new ReadFromInboxImplRuntimeDelegatable(overridesRegistry, getResourceResolverImplRuntimeDelegatable(), getCMSDocumentReadServiceRuntimeDelegatable());}

  private PublicKeySerdeImplRuntimeDelegatable getPublicKeySerdeImplRuntimeDelegatable() {
    return new PublicKeySerdeImplRuntimeDelegatable(overridesRegistry);}

  private GsonSerde getGsonSerde() {
    return new GsonSerde(getPublicKeySerdeImplRuntimeDelegatable());}

  private DFSPublicKeyServiceImplRuntimeDelegatable getDFSPublicKeyServiceImplRuntimeDelegatable() {
    return new DFSPublicKeyServiceImplRuntimeDelegatable(overridesRegistry, keyStoreCacheProvider.get(), getBucketAccessServiceImplRuntimeDelegatable(), getDFSRelativeProfileRetrievalServiceImpl(), storage, getGsonSerde());}

  private WriteToInboxImplRuntimeDelegatable getWriteToInboxImplRuntimeDelegatable() {
    return new WriteToInboxImplRuntimeDelegatable(overridesRegistry, getDFSPublicKeyServiceImplRuntimeDelegatable(), getResourceResolverImplRuntimeDelegatable(), getCMSDocumentWriteServiceRuntimeDelegatable());}

  private RemoveFromInboxImplRuntimeDelegatable getRemoveFromInboxImplRuntimeDelegatable() {
    return new RemoveFromInboxImplRuntimeDelegatable(overridesRegistry, getDFSPrivateKeyServiceImplRuntimeDelegatable(), getResourceResolverImplRuntimeDelegatable(), storage);}

  private InboxServiceImplRuntimeDelegatable getInboxServiceImplRuntimeDelegatable() {
    return new InboxServiceImplRuntimeDelegatable(overridesRegistry, getListInboxImplRuntimeDelegatable(), getReadFromInboxImplRuntimeDelegatable(), getWriteToInboxImplRuntimeDelegatable(), getRemoveFromInboxImplRuntimeDelegatable());}

  private StorageKeyStoreOperationsImplRuntimeDelegatable getStorageKeyStoreOperationsImplRuntimeDelegatable(
      ) {
    return new StorageKeyStoreOperationsImplRuntimeDelegatable(overridesRegistry, getGsonSerde(), getKeyStoreServiceImplRuntimeDelegatable(), getGenericKeystoreOperations(), getDFSRelativeProfileRetrievalServiceImpl(), getBucketAccessServiceImplRuntimeDelegatable(), keyStoreCacheProvider.get());}

  private DFSRelativeProfileRegistrationServiceImpl getDFSRelativeProfileRegistrationServiceImpl() {
    return new DFSRelativeProfileRegistrationServiceImpl(getStorageKeyStoreOperationsImplRuntimeDelegatable(), getDocumentKeyStoreOperationsImplRuntimeDelegatable(), getBucketAccessServiceImplRuntimeDelegatable(), storage, storage, getGsonSerde(), config);}

  private DFSRelativeProfileRemovalServiceImpl getDFSRelativeProfileRemovalServiceImpl() {
    return new DFSRelativeProfileRemovalServiceImpl(getDFSPrivateKeyServiceImplRuntimeDelegatable(), keyStoreCacheProvider.get(), storage, getBucketAccessServiceImplRuntimeDelegatable(), config, storage, getDFSRelativeProfileRetrievalServiceImpl());}

  private DFSRelativeProfileUpdatingServiceImpl getDFSRelativeProfileUpdatingServiceImpl() {
    return new DFSRelativeProfileUpdatingServiceImpl(getDFSPrivateKeyServiceImplRuntimeDelegatable(), getStorageKeyStoreOperationsImplRuntimeDelegatable(), getDocumentKeyStoreOperationsImplRuntimeDelegatable());}

  private ProfileStorageCredentialsServiceImplRuntimeDelegatable getProfileStorageCredentialsServiceImplRuntimeDelegatable(
      ) {
    return new ProfileStorageCredentialsServiceImplRuntimeDelegatable(overridesRegistry, getStorageKeyStoreOperationsImplRuntimeDelegatable(), getDFSPrivateKeyServiceImplRuntimeDelegatable());}

  private DFSBasedProfileStorageImplRuntimeDelegatable getDFSBasedProfileStorageImplRuntimeDelegatable(
      ) {
    return new DFSBasedProfileStorageImplRuntimeDelegatable(overridesRegistry, getDFSRelativeProfileRegistrationServiceImpl(), getDFSRelativeProfileRetrievalServiceImpl(), getDFSRelativeProfileRemovalServiceImpl(), getDFSRelativeProfileUpdatingServiceImpl(), getProfileStorageCredentialsServiceImplRuntimeDelegatable());}

  @SuppressWarnings("unchecked")
  private void initialize(final DFSConfig configParam, final StorageService storageParam,
      final OverridesRegistry overridesRegistryParam, final EncryptionConfig encryptionParam) {
    this.overridesRegistryProvider = InstanceFactory.createNullable(overridesRegistryParam);
    this.publicKeySerdeImplRuntimeDelegatableProvider = PublicKeySerdeImplRuntimeDelegatable_Factory.create(overridesRegistryProvider);
    this.gsonSerdeProvider = GsonSerde_Factory.create((Provider) publicKeySerdeImplRuntimeDelegatableProvider);
    this.encryptionProvider = InstanceFactory.createNullable(encryptionParam);
    this.keyStoreConfigProvider = DefaultKeyStoreModule_KeyStoreConfigFactory.create(encryptionProvider);
    this.jugglerProvider = DefaultKeyStoreModule_JugglerFactory.create(keyStoreConfigProvider);
    this.keyStoreServiceImplRuntimeDelegatableProvider = KeyStoreServiceImplRuntimeDelegatable_Factory.create(overridesRegistryProvider, keyStoreConfigProvider, jugglerProvider);
    this.cmsEncryptionConfigProvider = HardcodedProfileModule_CmsEncryptionConfigFactory.create(encryptionProvider);
    this.configProvider = InstanceFactory.create(configParam);
    this.storageProvider = InstanceFactory.create(storageParam);
    this.keyStoreCacheProvider = DoubleCheck.provider(DefaultKeystoreCacheModule_KeyStoreCacheFactory.create(overridesRegistryProvider));
    this.genericKeystoreOperationsProvider = GenericKeystoreOperations_Factory.create(cmsEncryptionConfigProvider, configProvider, (Provider) storageProvider, (Provider) storageProvider, keyStoreCacheProvider, (Provider) keyStoreServiceImplRuntimeDelegatableProvider);
    this.storageKeyStoreOperationsImplRuntimeDelegatableProvider = new DelegateFactory<>();
    this.bucketAccessServiceImplRuntimeDelegatableProvider = BucketAccessServiceImplRuntimeDelegatable_Factory.create(overridesRegistryProvider, (Provider) storageKeyStoreOperationsImplRuntimeDelegatableProvider);
    this.dFSRelativeProfileRetrievalServiceImplProvider = DFSRelativeProfileRetrievalServiceImpl_Factory.create(configProvider, (Provider) storageProvider, (Provider) bucketAccessServiceImplRuntimeDelegatableProvider);
    DelegateFactory.setDelegate(storageKeyStoreOperationsImplRuntimeDelegatableProvider, StorageKeyStoreOperationsImplRuntimeDelegatable_Factory.create(overridesRegistryProvider, gsonSerdeProvider, (Provider) keyStoreServiceImplRuntimeDelegatableProvider, genericKeystoreOperationsProvider, (Provider) dFSRelativeProfileRetrievalServiceImplProvider, (Provider) bucketAccessServiceImplRuntimeDelegatableProvider, keyStoreCacheProvider));
  }

  @Override
  public PrivateSpaceService privateService() {
    return getPrivateSpaceServiceImplRuntimeDelegatable();}

  @Override
  public InboxService inboxService() {
    return getInboxServiceImplRuntimeDelegatable();}

  @Override
  public ProfileOperations userProfile() {
    return getDFSBasedProfileStorageImplRuntimeDelegatable();}

  private static final class Builder implements SwitchableDatasafeServices.Builder {
    private DFSConfig config;

    private StorageService storage;

    private OverridesRegistry overridesRegistry;

    private EncryptionConfig encryption;

    @Override
    public Builder config(DFSConfig config) {
      this.config = Preconditions.checkNotNull(config);
      return this;
    }

    @Override
    public Builder storage(StorageService storageService) {
      this.storage = Preconditions.checkNotNull(storageService);
      return this;
    }

    @Override
    public Builder overridesRegistry(OverridesRegistry overridesRegistry) {
      this.overridesRegistry = overridesRegistry;
      return this;
    }

    @Override
    public Builder encryption(EncryptionConfig encryptionConfig) {
      this.encryption = encryptionConfig;
      return this;
    }

    @Override
    public SwitchableDatasafeServices build() {
      Preconditions.checkBuilderRequirement(config, DFSConfig.class);
      Preconditions.checkBuilderRequirement(storage, StorageService.class);
      return new DaggerSwitchableDatasafeServices(config, storage, overridesRegistry, encryption);
    }
  }
}
