/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.simple.adapter.impl.legacy.pathencryption;

import de.adorsys.datasafe.simple.adapter.api.legacy.pathencryption.LegacyPathEncryptionConfig;
import de.adorsys.datasafe.simple.adapter.impl.legacy.pathencryption.LegacyPathDigestConfig;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.inject.Inject;

public class LegacyPathEncryptor
implements LegacyPathEncryptionConfig {
    private final LegacyPathDigestConfig digestConfig;

    @Inject
    public LegacyPathEncryptor(LegacyPathDigestConfig config) {
        this.digestConfig = config;
    }

    public Cipher encryptionCipher(SecretKey secretKey) {
        return LegacyPathEncryptor.createCipher(secretKey, this.digestConfig, 1);
    }

    public Cipher decryptionCipher(SecretKey secretKey) {
        return LegacyPathEncryptor.createCipher(secretKey, this.digestConfig, 2);
    }

    public String byteSerializer(byte[] bytes) {
        return Base64.getUrlEncoder().encodeToString(bytes);
    }

    public byte[] byteDeserializer(String input) {
        return Base64.getUrlDecoder().decode(input);
    }

    private static Cipher createCipher(SecretKey secretKey, LegacyPathDigestConfig config, int cipherMode) {
        byte[] key = secretKey.getEncoded();
        MessageDigest sha = MessageDigest.getInstance(config.getMessageDigest());
        key = sha.digest(key);
        key = Arrays.copyOf(key, config.getShaKeyPartSize());
        SecretKeySpec secretKeySpec = new SecretKeySpec(key, config.getAlgorithm());
        Cipher cipher = Cipher.getInstance(config.getAlgorithm());
        cipher.init(cipherMode, secretKeySpec);
        return cipher;
    }
}

