/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.simple.adapter.impl.legacy.pathencryption;

import de.adorsys.datasafe.directory.api.profile.keys.PrivateKeyService;
import de.adorsys.datasafe.encrypiton.api.pathencryption.PathEncryption;
import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.encrypiton.api.types.keystore.AuthPathEncryptionSecretKey;
import de.adorsys.datasafe.simple.adapter.api.legacy.pathencryption.LegacySymmetricPathEncryptionService;
import de.adorsys.datasafe.types.api.resource.Uri;
import java.util.function.Function;
import javax.inject.Inject;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacyPathEncryptionImpl
implements PathEncryption {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LegacyPathEncryptionImpl.class);
    private final LegacySymmetricPathEncryptionService symmetricPathEncryptionService;
    private final PrivateKeyService privateKeyService;

    @Inject
    public LegacyPathEncryptionImpl(LegacySymmetricPathEncryptionService symmetricPathEncryptionService, PrivateKeyService privateKeyService) {
        this.symmetricPathEncryptionService = symmetricPathEncryptionService;
        this.privateKeyService = privateKeyService;
    }

    public Uri encrypt(UserIDAuth forUser, Uri path) {
        AuthPathEncryptionSecretKey keySpec = this.privateKeyService.pathEncryptionSecretKey(forUser);
        Uri encrypt = this.symmetricPathEncryptionService.encrypt(keySpec.getSecretKey().getSecretKey(), path);
        log.debug("encrypted path {} for user {} path {}", new Object[]{encrypt, forUser.getUserID(), path});
        return encrypt;
    }

    public Function<Uri, Uri> decryptor(UserIDAuth forUser) {
        AuthPathEncryptionSecretKey keySpec = this.privateKeyService.pathEncryptionSecretKey(forUser);
        return encryptedPath -> {
            Uri decrypt = this.symmetricPathEncryptionService.decrypt(keySpec.getSecretKey().getSecretKey(), encryptedPath);
            log.debug("decrypted path {} for user {} path {}", new Object[]{decrypt, forUser.getUserID(), encryptedPath});
            return decrypt;
        };
    }
}

