/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.simple.adapter.impl.legacy.pathencryption;

import de.adorsys.datasafe.simple.adapter.api.legacy.pathencryption.LegacyPathEncryptionConfig;
import de.adorsys.datasafe.simple.adapter.api.legacy.pathencryption.LegacySymmetricPathEncryptionService;
import de.adorsys.datasafe.types.api.resource.Uri;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.inject.Inject;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacyIntegrityPreservingUriEncryption
implements LegacySymmetricPathEncryptionService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LegacyIntegrityPreservingUriEncryption.class);
    private static final String PATH_SEPARATOR = "/";
    private final LegacyPathEncryptionConfig encryptionConfig;

    @Inject
    public LegacyIntegrityPreservingUriEncryption(LegacyPathEncryptionConfig encryptionConfig) {
        this.encryptionConfig = encryptionConfig;
    }

    public Uri encrypt(SecretKey secretKey, Uri bucketPath) {
        LegacyIntegrityPreservingUriEncryption.validateArgs(secretKey, bucketPath);
        LegacyIntegrityPreservingUriEncryption.validateUriIsRelative(bucketPath);
        Cipher cipher = this.encryptionConfig.encryptionCipher(secretKey);
        return LegacyIntegrityPreservingUriEncryption.processURIparts(bucketPath, str -> this.encode((String)str, cipher));
    }

    public Uri decrypt(SecretKey secretKey, Uri bucketPath) {
        LegacyIntegrityPreservingUriEncryption.validateArgs(secretKey, bucketPath);
        LegacyIntegrityPreservingUriEncryption.validateUriIsRelative(bucketPath);
        Cipher cipher = this.encryptionConfig.decryptionCipher(secretKey);
        return LegacyIntegrityPreservingUriEncryption.processURIparts(bucketPath, str -> this.decode((String)str, cipher));
    }

    private String decode(String str, Cipher cipher) {
        if (str.isEmpty()) {
            return str;
        }
        return new String(cipher.doFinal(this.encryptionConfig.byteDeserializer(str)), StandardCharsets.UTF_8);
    }

    private String encode(String str, Cipher cipher) {
        if (str.isEmpty()) {
            return str;
        }
        return this.encryptionConfig.byteSerializer(cipher.doFinal(str.getBytes(StandardCharsets.UTF_8)));
    }

    private static Uri processURIparts(Uri bucketPath, Function<String, String> process) {
        StringBuilder result = new StringBuilder();
        String path = bucketPath.getRawPath();
        if (bucketPath.getRawPath().startsWith("./")) {
            result.append("./");
            path = bucketPath.getRawPath().substring(2);
        }
        if (path.isEmpty()) {
            return new Uri(result.toString());
        }
        return new Uri(URI.create(Arrays.stream(path.split(PATH_SEPARATOR, -1)).map(process).collect(Collectors.joining(PATH_SEPARATOR))));
    }

    private static void validateArgs(SecretKey secretKey, Uri bucketPath) {
        if (null == secretKey) {
            throw new IllegalArgumentException("Secret key should not be null");
        }
        if (null == bucketPath) {
            throw new IllegalArgumentException("Bucket path should not be null");
        }
    }

    private static void validateUriIsRelative(Uri uri) {
        if (uri.isAbsolute()) {
            throw new IllegalArgumentException("URI should be relative");
        }
    }
}

