/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.simple.adapter.impl.profile;

import de.adorsys.datasafe.directory.api.config.DFSConfig;
import de.adorsys.datasafe.directory.api.profile.dfs.BucketAccessService;
import de.adorsys.datasafe.directory.api.types.CreateUserPrivateProfile;
import de.adorsys.datasafe.directory.api.types.CreateUserPublicProfile;
import de.adorsys.datasafe.directory.api.types.UserPrivateProfile;
import de.adorsys.datasafe.directory.api.types.UserPublicProfile;
import de.adorsys.datasafe.directory.impl.profile.operations.actions.ProfileRetrievalServiceImpl;
import de.adorsys.datasafe.encrypiton.api.types.UserID;
import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.storage.api.actions.StorageCheckService;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DFSRelativeProfileRetrievalServiceImpl
extends ProfileRetrievalServiceImpl {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DFSRelativeProfileRetrievalServiceImpl.class);
    private final DFSConfig dfsConfig;
    private final StorageCheckService checkService;
    private final BucketAccessService access;

    public DFSRelativeProfileRetrievalServiceImpl(DFSConfig dfsConfig, StorageCheckService checkService, BucketAccessService access) {
        super(null, null, null, null, null, null);
        this.dfsConfig = dfsConfig;
        this.checkService = checkService;
        this.access = access;
    }

    public UserPublicProfile publicProfile(UserID ofUser) {
        CreateUserPublicProfile createUserPublicProfile = this.dfsConfig.defaultPublicTemplate(ofUser);
        UserPublicProfile userPublicProfile = createUserPublicProfile.removeAccess();
        log.debug("get public profile {} for user {}", (Object)userPublicProfile, (Object)ofUser);
        return userPublicProfile;
    }

    public UserPrivateProfile privateProfile(UserIDAuth ofUser) {
        CreateUserPrivateProfile privateProfile = this.dfsConfig.defaultPrivateTemplate(ofUser);
        UserPrivateProfile userPrivateProfile = privateProfile.removeAccess();
        log.debug("get private profile {} for user {}", (Object)userPrivateProfile, (Object)ofUser);
        return userPrivateProfile;
    }

    public boolean userExists(UserID ofUser) {
        return this.checkService.objectExists(this.access.withSystemAccess(this.dfsConfig.defaultPublicTemplate(ofUser).getPublicKeys()));
    }
}

