/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.simple.adapter.impl;

import de.adorsys.datasafe.directory.api.profile.keys.PrivateKeyService;
import de.adorsys.datasafe.encrypiton.api.pathencryption.encryption.SymmetricPathEncryptionService;
import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.encrypiton.impl.pathencryption.PathEncryptionImpl;
import de.adorsys.datasafe.types.api.resource.Uri;
import java.util.function.Function;
import javax.inject.Inject;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwitchablePathEncryptionImpl
extends PathEncryptionImpl {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SwitchablePathEncryptionImpl.class);
    public static final String NO_BUCKETPATH_ENCRYPTION = "SC-NO-BUCKETPATH-ENCRYPTION";
    private boolean withPathEncryption = SwitchablePathEncryptionImpl.checkIsPathEncryptionToUse();

    @Inject
    public SwitchablePathEncryptionImpl(SymmetricPathEncryptionService bucketPathEncryptionService, PrivateKeyService privateKeyService) {
        super(bucketPathEncryptionService, privateKeyService);
    }

    public Uri encrypt(UserIDAuth forUser, Uri path) {
        if (this.withPathEncryption) {
            return super.encrypt(forUser, path);
        }
        return path;
    }

    public Function<Uri, Uri> decryptor(UserIDAuth forUser) {
        if (this.withPathEncryption) {
            return super.decryptor(forUser);
        }
        return Function.identity();
    }

    public static boolean checkIsPathEncryptionToUse() {
        String value = System.getProperty(NO_BUCKETPATH_ENCRYPTION);
        if (value != null) {
            if (value.equalsIgnoreCase(Boolean.FALSE.toString())) {
                log.debug("path encryption is on");
                return true;
            }
            if (value.equalsIgnoreCase(Boolean.TRUE.toString())) {
                log.debug("path encryption is off");
                return false;
            }
            throw new RuntimeException("value " + value + " for " + NO_BUCKETPATH_ENCRYPTION + " is unknown");
        }
        log.debug("path encryption is on");
        return true;
    }
}

