/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.simple.adapter.impl;

import de.adorsys.datasafe.encrypiton.api.types.keystore.KeyID;
import de.adorsys.datasafe.encrypiton.api.types.keystore.PublicKeyIDWithPublicKey;
import de.adorsys.datasafe.encrypiton.impl.cmsencryption.CMSEncryptionConfig;
import de.adorsys.datasafe.encrypiton.impl.cmsencryption.CMSEncryptionServiceImpl;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.crypto.SecretKey;
import javax.inject.Inject;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwitchableCmsEncryptionImpl
extends CMSEncryptionServiceImpl {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SwitchableCmsEncryptionImpl.class);
    public static final String NO_CMSENCRYPTION_AT_ALL = "SC-NO-CMSENCRYPTION-AT-ALL";
    private boolean withCmsEncryption = SwitchableCmsEncryptionImpl.checkCmsEnccryptionToUse();

    @Inject
    public SwitchableCmsEncryptionImpl(CMSEncryptionConfig encryptionConfig) {
        super(encryptionConfig);
    }

    public OutputStream buildEncryptionOutputStream(OutputStream dataContentStream, Set<PublicKeyIDWithPublicKey> publicKeys) {
        if (this.withCmsEncryption) {
            return super.buildEncryptionOutputStream(dataContentStream, publicKeys);
        }
        return dataContentStream;
    }

    public OutputStream buildEncryptionOutputStream(OutputStream dataContentStream, SecretKey secretKey, KeyID secretKeyID) {
        if (this.withCmsEncryption) {
            return super.buildEncryptionOutputStream(dataContentStream, secretKey, secretKeyID);
        }
        return dataContentStream;
    }

    public InputStream buildDecryptionInputStream(InputStream inputStream, Function<Set<String>, Map<String, Key>> keysByIds) {
        if (this.withCmsEncryption) {
            return super.buildDecryptionInputStream(inputStream, keysByIds);
        }
        return inputStream;
    }

    public static boolean checkCmsEnccryptionToUse() {
        String value = System.getProperty(NO_CMSENCRYPTION_AT_ALL);
        if (value != null) {
            if (value.equalsIgnoreCase(Boolean.FALSE.toString())) {
                log.debug("cms encryption is on");
                return true;
            }
            if (value.equalsIgnoreCase(Boolean.TRUE.toString())) {
                log.debug("cms encryption is off");
                return false;
            }
            throw new RuntimeException("value " + value + " for " + NO_CMSENCRYPTION_AT_ALL + " is unknown");
        }
        log.debug("cms encryption is on");
        return true;
    }
}

